/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import javax.xml.namespace.QName;

public final class ElemAttrs {
    private static final int OFFSET_NS_URI = 1;
    private final String[] mRawAttrs;
    private final int mDefaultOffset;
    private final int[] mAttrMap;
    private final int mAttrHashSize;
    private final int mAttrSpillEnd;

    public ElemAttrs(String[] rawAttrs, int defOffset) {
        this.mRawAttrs = rawAttrs;
        this.mAttrMap = null;
        this.mAttrHashSize = 0;
        this.mAttrSpillEnd = 0;
        this.mDefaultOffset = defOffset << 2;
    }

    public ElemAttrs(String[] rawAttrs, int defOffset, int[] attrMap, int hashSize, int spillEnd) {
        this.mRawAttrs = rawAttrs;
        this.mDefaultOffset = defOffset << 2;
        this.mAttrMap = attrMap;
        this.mAttrHashSize = hashSize;
        this.mAttrSpillEnd = spillEnd;
    }

    public String[] getRawAttrs() {
        return this.mRawAttrs;
    }

    public int findIndex(QName name) {
        if (this.mAttrMap != null) {
            return this.findMapIndex(name.getNamespaceURI(), name.getLocalPart());
        }
        String ln = name.getLocalPart();
        String uri = name.getNamespaceURI();
        boolean defaultNs = uri == null || uri.length() == 0;
        String[] raw2 = this.mRawAttrs;
        int len2 = raw2.length;
        for (int i = 0; i < len2; i += 4) {
            if (!ln.equals(raw2[i])) continue;
            String thisUri = raw2[i + 1];
            if (!(defaultNs ? thisUri == null || thisUri.length() == 0 : thisUri != null && (thisUri == uri || thisUri.equals(uri)))) continue;
            return i;
        }
        return -1;
    }

    public int getFirstDefaultOffset() {
        return this.mDefaultOffset;
    }

    public boolean isDefault(int ix) {
        return ix >= this.mDefaultOffset;
    }

    private final int findMapIndex(String nsURI, String localName) {
        int hash2 = localName.hashCode();
        if (nsURI == null) {
            nsURI = "";
        } else if (nsURI.length() > 0) {
            hash2 ^= nsURI.hashCode();
        }
        int ix = this.mAttrMap[hash2 & this.mAttrHashSize - 1];
        if (ix == 0) {
            return -1;
        }
        String[] raw2 = this.mRawAttrs;
        String thisName = raw2[ix = ix - 1 << 2];
        if (thisName == localName || thisName.equals(localName)) {
            String thisURI = raw2[ix + 1];
            if (thisURI == nsURI) {
                return ix;
            }
            if (thisURI == null ? nsURI.length() == 0 : thisURI.equals(nsURI)) {
                return ix;
            }
        }
        int len2 = this.mAttrSpillEnd;
        for (int i = this.mAttrHashSize; i < len2; i += 2) {
            if (this.mAttrMap[i] != hash2 || (thisName = raw2[ix = this.mAttrMap[i + 1] << 2]) != localName && !thisName.equals(localName)) continue;
            String thisURI = raw2[ix + 1];
            if (thisURI == nsURI) {
                return ix;
            }
            if (!(thisURI == null ? nsURI.length() == 0 : thisURI.equals(nsURI))) continue;
            return ix;
        }
        return -1;
    }
}

