/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.sw.EncodingXmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public final class AsciiXmlWriter
extends EncodingXmlWriter {
    public AsciiXmlWriter(OutputStream out, WriterConfig cfg, boolean autoclose) throws IOException {
        super(out, cfg, "US-ASCII", autoclose);
    }

    public void writeRaw(char[] cbuf, int offset2, int len2) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        int ptr = this.mOutputPtr;
        while (len2 > 0) {
            int inEnd;
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len2) {
                max2 = len2;
            }
            if (this.mCheckContent) {
                inEnd = offset2 + max2;
                while (offset2 < inEnd) {
                    char c2 = cbuf[offset2];
                    if (c2 < ' ') {
                        if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                            this.mOutputPtr = ptr;
                            c2 = this.handleInvalidChar(c2);
                        }
                    } else if (c2 > '~') {
                        this.mOutputPtr = ptr;
                        if (c2 > '\u007f') {
                            this.handleInvalidAsciiChar(c2);
                        } else if (this.mXml11) {
                            c2 = this.handleInvalidChar(c2);
                        }
                    }
                    this.mOutputBuffer[ptr++] = (byte)c2;
                    ++offset2;
                }
            } else {
                inEnd = offset2 + max2;
                while (offset2 < inEnd) {
                    this.mOutputBuffer[ptr++] = (byte)cbuf[offset2];
                    ++offset2;
                }
            }
            len2 -= max2;
        }
        this.mOutputPtr = ptr;
    }

    public void writeRaw(String str, int offset2, int len2) throws IOException {
        if (this.mSurrogate != 0) {
            this.throwUnpairedSurrogate();
        }
        int ptr = this.mOutputPtr;
        while (len2 > 0) {
            int inEnd;
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len2) {
                max2 = len2;
            }
            if (this.mCheckContent) {
                inEnd = offset2 + max2;
                while (offset2 < inEnd) {
                    char c2 = str.charAt(offset2);
                    if (c2 < ' ') {
                        if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                            this.mOutputPtr = ptr;
                            c2 = this.handleInvalidChar(c2);
                        }
                    } else if (c2 > '~') {
                        this.mOutputPtr = ptr;
                        if (c2 > '\u007f') {
                            this.handleInvalidAsciiChar(c2);
                        } else if (this.mXml11) {
                            c2 = this.handleInvalidChar(c2);
                        }
                    }
                    this.mOutputBuffer[ptr++] = (byte)c2;
                    ++offset2;
                }
            } else {
                inEnd = offset2 + max2;
                while (offset2 < inEnd) {
                    this.mOutputBuffer[ptr++] = (byte)str.charAt(offset2);
                    ++offset2;
                }
            }
            len2 -= max2;
        }
        this.mOutputPtr = ptr;
    }

    protected void writeAttrValue(String data2) throws IOException {
        int offset2 = 0;
        int len2 = data2.length();
        int ptr = this.mOutputPtr;
        block0: while (len2 > 0) {
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                int sec = data2.charAt(offset2++);
                sec = this.calcSurrogate(sec);
                this.mOutputPtr = ptr;
                ptr = this.writeAsEntity(sec);
                --len2;
                continue;
            }
            if (max2 > len2) {
                max2 = len2;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                int c2;
                if ((c2 = data2.charAt(offset2++)) < 32) {
                    if (c2 == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[ptr++] = (byte)c2;
                            continue;
                        }
                    } else if (c2 != 10 && c2 != 9 && this.mCheckContent && (!this.mXml11 || c2 == 0)) {
                        c2 = this.handleInvalidChar(c2);
                        this.mOutputBuffer[ptr++] = (byte)c2;
                        continue;
                    }
                } else if (c2 < 127) {
                    if (c2 != 60 && c2 != 38 && c2 != 34) {
                        this.mOutputBuffer[ptr++] = (byte)c2;
                        continue;
                    }
                } else if (c2 >= 55296 && c2 <= 57343) {
                    this.mSurrogate = c2;
                    if (offset2 == inEnd) break;
                    c2 = this.calcSurrogate(data2.charAt(offset2++));
                }
                this.mOutputPtr = ptr;
                ptr = this.writeAsEntity(c2);
                len2 = data2.length() - offset2;
                continue block0;
            }
            len2 -= max2;
        }
        this.mOutputPtr = ptr;
    }

    protected void writeAttrValue(char[] data2, int offset2, int len2) throws IOException {
        int ptr = this.mOutputPtr;
        while (len2 > 0) {
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                int sec = data2[offset2++];
                sec = this.calcSurrogate(sec);
                this.mOutputPtr = ptr;
                ptr = this.writeAsEntity(sec);
                --len2;
                continue;
            }
            if (max2 > len2) {
                max2 = len2;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                int c2;
                if ((c2 = data2[offset2++]) < 32) {
                    if (c2 == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[ptr++] = (byte)c2;
                            continue;
                        }
                    } else if (c2 != 10 && c2 != 9 && this.mCheckContent && (!this.mXml11 || c2 == 0)) {
                        c2 = this.handleInvalidChar(c2);
                        this.mOutputBuffer[ptr++] = (byte)c2;
                        continue;
                    }
                } else if (c2 < 127) {
                    if (c2 != 60 && c2 != 38 && c2 != 34) {
                        this.mOutputBuffer[ptr++] = (byte)c2;
                        continue;
                    }
                } else if (c2 >= 55296 && c2 <= 57343) {
                    this.mSurrogate = c2;
                    if (offset2 == inEnd) break;
                    c2 = this.calcSurrogate(data2[offset2++]);
                }
                this.mOutputPtr = ptr;
                ptr = this.writeAsEntity(c2);
                max2 -= inEnd - offset2;
                break;
            }
            len2 -= max2;
        }
        this.mOutputPtr = ptr;
    }

    protected int writeCDataContent(String data2) throws IOException {
        int offset2 = 0;
        int len2 = data2.length();
        if (!this.mCheckContent) {
            this.writeRaw(data2, offset2, len2);
            return -1;
        }
        int ptr = this.mOutputPtr;
        block0: while (len2 > 0) {
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len2) {
                max2 = len2;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                char c2;
                block9: {
                    block10: {
                        block11: {
                            block8: {
                                if ((c2 = data2.charAt(offset2++)) >= ' ') break block8;
                                if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                                    this.mOutputPtr = ptr;
                                    c2 = this.handleInvalidChar(c2);
                                }
                                break block9;
                            }
                            if (c2 <= '~') break block10;
                            this.mOutputPtr = ptr;
                            if (c2 <= '\u007f') break block11;
                            this.handleInvalidAsciiChar(c2);
                            break block9;
                        }
                        if (!this.mXml11) break block9;
                        c2 = this.handleInvalidChar(c2);
                        break block9;
                    }
                    if (c2 == '>' && offset2 > 2 && data2.charAt(offset2 - 2) == ']' && data2.charAt(offset2 - 3) == ']') {
                        if (!this.mFixContent) {
                            return offset2 - 3;
                        }
                        this.mOutputPtr = ptr;
                        this.writeCDataEnd();
                        this.writeCDataStart();
                        this.writeAscii((byte)62);
                        ptr = this.mOutputPtr;
                        len2 = data2.length() - offset2;
                        continue block0;
                    }
                }
                this.mOutputBuffer[ptr++] = (byte)c2;
            }
            len2 -= max2;
        }
        this.mOutputPtr = ptr;
        return -1;
    }

    protected int writeCDataContent(char[] cbuf, int start2, int len2) throws IOException {
        if (!this.mCheckContent) {
            this.writeRaw(cbuf, start2, len2);
            return -1;
        }
        int ptr = this.mOutputPtr;
        int offset2 = start2;
        while (len2 > 0) {
            int max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len2) {
                max2 = len2;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                char c2;
                block9: {
                    block10: {
                        block11: {
                            block8: {
                                if ((c2 = cbuf[offset2++]) >= ' ') break block8;
                                if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                                    this.mOutputPtr = ptr;
                                    c2 = this.handleInvalidChar(c2);
                                }
                                break block9;
                            }
                            if (c2 <= '~') break block10;
                            this.mOutputPtr = ptr;
                            if (c2 <= '\u007f') break block11;
                            this.handleInvalidAsciiChar(c2);
                            break block9;
                        }
                        if (!this.mXml11) break block9;
                        c2 = this.handleInvalidChar(c2);
                        break block9;
                    }
                    if (c2 == '>' && offset2 >= start2 + 3 && cbuf[offset2 - 2] == ']' && cbuf[offset2 - 3] == ']') {
                        if (!this.mFixContent) {
                            return offset2 - 3;
                        }
                        this.mOutputPtr = ptr;
                        this.writeCDataEnd();
                        this.writeCDataStart();
                        this.writeAscii((byte)62);
                        ptr = this.mOutputPtr;
                        max2 -= inEnd - offset2;
                        break;
                    }
                }
                this.mOutputBuffer[ptr++] = (byte)c2;
            }
            len2 -= max2;
        }
        this.mOutputPtr = ptr;
        return -1;
    }

    protected int writeCommentContent(String data2) throws IOException {
        int max2;
        int len2;
        int offset2 = 0;
        if (!this.mCheckContent) {
            this.writeRaw(data2, offset2, len2);
            return -1;
        }
        int ptr = this.mOutputPtr;
        block0: for (len2 = data2.length(); len2 > 0; len2 -= max2) {
            max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len2) {
                max2 = len2;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                char c2;
                block10: {
                    block11: {
                        block12: {
                            block9: {
                                if ((c2 = data2.charAt(offset2++)) >= ' ') break block9;
                                if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                                    this.mOutputPtr = ptr;
                                    c2 = this.handleInvalidChar(c2);
                                }
                                break block10;
                            }
                            if (c2 <= '~') break block11;
                            this.mOutputPtr = ptr;
                            if (c2 <= '\u007f') break block12;
                            this.handleInvalidAsciiChar(c2);
                            break block10;
                        }
                        if (!this.mXml11) break block10;
                        c2 = this.handleInvalidChar(c2);
                        break block10;
                    }
                    if (c2 == '-' && offset2 > 1 && data2.charAt(offset2 - 2) == '-') {
                        if (!this.mFixContent) {
                            return offset2 - 2;
                        }
                        this.mOutputBuffer[ptr++] = 32;
                        if (ptr >= this.mOutputBuffer.length) {
                            this.mOutputPtr = ptr;
                            this.flushBuffer();
                            ptr = 0;
                        }
                        this.mOutputBuffer[ptr++] = 45;
                        max2 -= inEnd - offset2;
                        continue block0;
                    }
                }
                this.mOutputBuffer[ptr++] = (byte)c2;
            }
        }
        this.mOutputPtr = ptr;
        return -1;
    }

    protected int writePIData(String data2) throws IOException, XMLStreamException {
        int max2;
        int len2;
        int offset2 = 0;
        if (!this.mCheckContent) {
            this.writeRaw(data2, offset2, len2);
            return -1;
        }
        int ptr = this.mOutputPtr;
        for (len2 = data2.length(); len2 > 0; len2 -= max2) {
            max2 = this.mOutputBuffer.length - ptr;
            if (max2 < 1) {
                this.mOutputPtr = ptr;
                this.flushBuffer();
                ptr = 0;
                max2 = this.mOutputBuffer.length;
            }
            if (max2 > len2) {
                max2 = len2;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                char c2 = data2.charAt(offset2);
                if (c2 < ' ') {
                    if (c2 != '\n' && c2 != '\r' && c2 != '\t') {
                        this.mOutputPtr = ptr;
                        c2 = this.handleInvalidChar(c2);
                    }
                } else if (c2 > '~') {
                    this.mOutputPtr = ptr;
                    if (c2 > '\u007f') {
                        this.handleInvalidAsciiChar(c2);
                    } else if (this.mXml11) {
                        c2 = this.handleInvalidChar(c2);
                    }
                } else if (c2 == '>' && offset2 > 0 && data2.charAt(offset2 - 1) == '?') {
                    return offset2 - 2;
                }
                this.mOutputBuffer[ptr++] = (byte)c2;
                ++offset2;
            }
        }
        this.mOutputPtr = ptr;
        return -1;
    }

    protected void writeTextContent(String data2) throws IOException {
        int offset2 = 0;
        int len2 = data2.length();
        block0: while (len2 > 0) {
            int max2 = this.mOutputBuffer.length - this.mOutputPtr;
            if (max2 < 1) {
                this.flushBuffer();
                max2 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                int sec = data2.charAt(offset2++);
                sec = this.calcSurrogate(sec);
                this.writeAsEntity(sec);
                --len2;
                continue;
            }
            if (max2 > len2) {
                max2 = len2;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                int c2;
                if ((c2 = data2.charAt(offset2++)) < 32) {
                    if (c2 == 10 || c2 == 9) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c2;
                        continue;
                    }
                    if (c2 == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[this.mOutputPtr++] = (byte)c2;
                            continue;
                        }
                    } else if ((!this.mXml11 || c2 == 0) && this.mCheckContent) {
                        c2 = this.handleInvalidChar(c2);
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c2;
                        continue;
                    }
                } else if (c2 < 127) {
                    if (c2 != 60 && c2 != 38 && (c2 != 62 || offset2 > 1 && data2.charAt(offset2 - 2) != ']')) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c2;
                        continue;
                    }
                } else if (c2 >= 55296 && c2 <= 57343) {
                    this.mSurrogate = c2;
                    if (offset2 == inEnd) break;
                    c2 = this.calcSurrogate(data2.charAt(offset2++));
                }
                this.writeAsEntity(c2);
                len2 = data2.length() - offset2;
                continue block0;
            }
            len2 -= max2;
        }
    }

    protected void writeTextContent(char[] cbuf, int offset2, int len2) throws IOException {
        while (len2 > 0) {
            int max2 = this.mOutputBuffer.length - this.mOutputPtr;
            if (max2 < 1) {
                this.flushBuffer();
                max2 = this.mOutputBuffer.length;
            }
            if (this.mSurrogate != 0) {
                int sec = cbuf[offset2++];
                sec = this.calcSurrogate(sec);
                this.writeAsEntity(sec);
                --len2;
                continue;
            }
            if (max2 > len2) {
                max2 = len2;
            }
            int inEnd = offset2 + max2;
            while (offset2 < inEnd) {
                int c2;
                if ((c2 = cbuf[offset2++]) < 32) {
                    if (c2 == 10 || c2 == 9) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c2;
                        continue;
                    }
                    if (c2 == 13) {
                        if (!this.mEscapeCR) {
                            this.mOutputBuffer[this.mOutputPtr++] = (byte)c2;
                            continue;
                        }
                    } else if ((!this.mXml11 || c2 == 0) && this.mCheckContent) {
                        c2 = this.handleInvalidChar(c2);
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c2;
                        continue;
                    }
                } else if (c2 < 127) {
                    if (c2 != 60 && c2 != 38 && (c2 != 62 || offset2 > 1 && cbuf[offset2 - 2] != ']')) {
                        this.mOutputBuffer[this.mOutputPtr++] = (byte)c2;
                        continue;
                    }
                } else if (c2 >= 55296 && c2 <= 57343) {
                    this.mSurrogate = c2;
                    if (offset2 == inEnd) break;
                    c2 = this.calcSurrogate(cbuf[offset2++]);
                }
                this.writeAsEntity(c2);
                max2 -= inEnd - offset2;
                break;
            }
            len2 -= max2;
        }
    }

    protected void handleInvalidAsciiChar(int c2) throws IOException {
        this.flush();
        throw new IOException("Invalid XML character (0x" + Integer.toHexString(c2) + "); can only be output using character entity when using US-ASCII encoding");
    }
}

