/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.EmptyElementHandler;
import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.exc.WstxIOException;
import com.ctc.wstx.sw.SimpleOutputElement;
import com.ctc.wstx.sw.TypedStreamWriter;
import com.ctc.wstx.sw.XmlWriter;
import com.ctc.wstx.util.DefaultXmlSymbolTable;
import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.codehaus.stax2.ri.typed.AsciiValueEncoder;

public abstract class BaseNsStreamWriter
extends TypedStreamWriter {
    protected static final String sPrefixXml = DefaultXmlSymbolTable.getXmlSymbol();
    protected static final String sPrefixXmlns = DefaultXmlSymbolTable.getXmlnsSymbol();
    protected static final String ERR_NSDECL_WRONG_STATE = "Trying to write a namespace declaration when there is no open start element.";
    protected final boolean mAutomaticNS;
    protected final EmptyElementHandler mEmptyElementHandler;
    protected SimpleOutputElement mCurrElem = SimpleOutputElement.createRoot();
    protected NamespaceContext mRootNsContext = null;
    protected SimpleOutputElement mOutputElemPool = null;
    static final int MAX_POOL_SIZE = 8;
    protected int mPoolSize = 0;

    public BaseNsStreamWriter(XmlWriter xw, String enc, WriterConfig cfg, boolean repairing) {
        super(xw, enc, cfg);
        this.mAutomaticNS = repairing;
        this.mEmptyElementHandler = cfg.getEmptyElementHandler();
    }

    public NamespaceContext getNamespaceContext() {
        return this.mCurrElem;
    }

    public String getPrefix(String uri) {
        return this.mCurrElem.getPrefix(uri);
    }

    public abstract void setDefaultNamespace(String var1) throws XMLStreamException;

    public void setNamespaceContext(NamespaceContext ctxt) throws XMLStreamException {
        if (this.mState != 1) {
            BaseNsStreamWriter.throwOutputError("Called setNamespaceContext() after having already output root element.");
        }
        this.mRootNsContext = ctxt;
        this.mCurrElem.setRootNsContext(ctxt);
    }

    public void setPrefix(String prefix2, String uri) throws XMLStreamException {
        if (prefix2 == null) {
            throw new NullPointerException("Can not pass null 'prefix' value");
        }
        if (prefix2.length() == 0) {
            this.setDefaultNamespace(uri);
            return;
        }
        if (uri == null) {
            throw new NullPointerException("Can not pass null 'uri' value");
        }
        if (prefix2.equals(sPrefixXml)) {
            if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, uri);
            }
        } else if (prefix2.equals(sPrefixXmlns)) {
            if (!uri.equals("http://www.w3.org/2000/xmlns/")) {
                BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, uri);
            }
        } else if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, prefix2);
        } else if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, prefix2);
        }
        if (!this.mXml11 && uri.length() == 0) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_EMPTY);
        }
        this.doSetPrefix(prefix2, uri);
    }

    public void writeAttribute(String localName, String value2) throws XMLStreamException {
        if (!this.mStartElementOpen && this.mCheckStructure) {
            BaseNsStreamWriter.reportNwfStructure(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        this.doWriteAttr(localName, null, null, value2);
    }

    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.checkStartElement(localName, null);
        if (this.mValidator != null) {
            this.mValidator.validateElementStart(localName, "", "");
        }
        this.mEmptyElement = true;
        if (this.mOutputElemPool != null) {
            SimpleOutputElement newCurr = this.mOutputElemPool;
            this.mOutputElemPool = newCurr.reuseAsChild(this.mCurrElem, localName);
            --this.mPoolSize;
            this.mCurrElem = newCurr;
        } else {
            this.mCurrElem = this.mCurrElem.createChild(localName);
        }
        this.doWriteStartTag(localName);
    }

    public void writeEmptyElement(String nsURI, String localName) throws XMLStreamException {
        this.writeStartOrEmpty(localName, nsURI);
        this.mEmptyElement = true;
    }

    public void writeEmptyElement(String prefix2, String localName, String nsURI) throws XMLStreamException {
        this.writeStartOrEmpty(prefix2, localName, nsURI);
        this.mEmptyElement = true;
    }

    public void writeEndElement() throws XMLStreamException {
        this.doWriteEndTag(null, this.mCfgAutomaticEmptyElems);
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.checkStartElement(localName, null);
        if (this.mValidator != null) {
            this.mValidator.validateElementStart(localName, "", "");
        }
        this.mEmptyElement = false;
        if (this.mOutputElemPool != null) {
            SimpleOutputElement newCurr = this.mOutputElemPool;
            this.mOutputElemPool = newCurr.reuseAsChild(this.mCurrElem, localName);
            --this.mPoolSize;
            this.mCurrElem = newCurr;
        } else {
            this.mCurrElem = this.mCurrElem.createChild(localName);
        }
        this.doWriteStartTag(localName);
    }

    public void writeStartElement(String nsURI, String localName) throws XMLStreamException {
        this.writeStartOrEmpty(localName, nsURI);
        this.mEmptyElement = false;
    }

    public void writeStartElement(String prefix2, String localName, String nsURI) throws XMLStreamException {
        this.writeStartOrEmpty(prefix2, localName, nsURI);
        this.mEmptyElement = false;
    }

    protected void writeTypedAttribute(String prefix2, String nsURI, String localName, AsciiValueEncoder enc) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        if (this.mCheckAttrs) {
            this.mCurrElem.checkAttrWrite(nsURI, localName);
        }
        try {
            if (this.mValidator == null) {
                if (prefix2 == null || prefix2.length() == 0) {
                    this.mWriter.writeTypedAttribute(localName, enc);
                } else {
                    this.mWriter.writeTypedAttribute(prefix2, localName, enc);
                }
            } else {
                this.mWriter.writeTypedAttribute(prefix2, localName, nsURI, enc, this.mValidator, this.getCopyBuffer());
            }
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    public void writeFullEndElement() throws XMLStreamException {
        this.doWriteEndTag(null, false);
    }

    public QName getCurrentElementName() {
        return this.mCurrElem.getName();
    }

    public String getNamespaceURI(String prefix2) {
        return this.mCurrElem.getNamespaceURI(prefix2);
    }

    public void writeEndElement(QName name) throws XMLStreamException {
        this.doWriteEndTag(this.mCheckStructure ? name : null, this.mCfgAutomaticEmptyElems);
    }

    protected void closeStartElement(boolean emptyElem) throws XMLStreamException {
        this.mStartElementOpen = false;
        try {
            if (emptyElem) {
                this.mWriter.writeStartTagEmptyEnd();
            } else {
                this.mWriter.writeStartTagEnd();
            }
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
        if (this.mValidator != null) {
            this.mVldContent = this.mValidator.validateElementAndAttributes();
        }
        if (emptyElem) {
            SimpleOutputElement curr = this.mCurrElem;
            this.mCurrElem = curr.getParent();
            if (this.mCurrElem.isRoot()) {
                this.mState = 3;
            }
            if (this.mValidator != null) {
                this.mVldContent = this.mValidator.validateElementEnd(curr.getLocalName(), curr.getNamespaceURI(), curr.getPrefix());
            }
            if (this.mPoolSize < 8) {
                curr.addToPool(this.mOutputElemPool);
                this.mOutputElemPool = curr;
                ++this.mPoolSize;
            }
        }
    }

    protected String getTopElementDesc() {
        return this.mCurrElem.getNameDesc();
    }

    protected void checkStartElement(String localName, String prefix2) throws XMLStreamException {
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        } else if (this.mState == 1) {
            this.verifyRootElement(localName, prefix2);
        } else if (this.mState == 3) {
            if (this.mCheckStructure) {
                String name = prefix2 == null || prefix2.length() == 0 ? localName : prefix2 + ":" + localName;
                BaseNsStreamWriter.reportNwfStructure(ErrorConsts.WERR_PROLOG_SECOND_ROOT, name);
            }
            this.mState = 2;
        }
    }

    protected final void doWriteAttr(String localName, String nsURI, String prefix2, String value2) throws XMLStreamException {
        if (this.mCheckAttrs) {
            this.mCurrElem.checkAttrWrite(nsURI, localName);
        }
        if (this.mValidator != null) {
            this.mValidator.validateAttribute(localName, nsURI, prefix2, value2);
        }
        try {
            int vlen = value2.length();
            if (vlen >= 12) {
                char[] buf = this.mCopyBuffer;
                if (buf == null) {
                    this.mCopyBuffer = buf = this.mConfig.allocMediumCBuffer(512);
                }
                if (vlen <= buf.length) {
                    value2.getChars(0, vlen, buf, 0);
                    if (prefix2 != null && prefix2.length() > 0) {
                        this.mWriter.writeAttribute(prefix2, localName, buf, 0, vlen);
                    } else {
                        this.mWriter.writeAttribute(localName, buf, 0, vlen);
                    }
                    return;
                }
            }
            if (prefix2 != null && prefix2.length() > 0) {
                this.mWriter.writeAttribute(prefix2, localName, value2);
            } else {
                this.mWriter.writeAttribute(localName, value2);
            }
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    protected final void doWriteAttr(String localName, String nsURI, String prefix2, char[] buf, int start2, int len2) throws XMLStreamException {
        if (this.mCheckAttrs) {
            this.mCurrElem.checkAttrWrite(nsURI, localName);
        }
        if (this.mValidator != null) {
            this.mValidator.validateAttribute(localName, nsURI, prefix2, buf, start2, len2);
        }
        try {
            if (prefix2 != null && prefix2.length() > 0) {
                this.mWriter.writeAttribute(prefix2, localName, buf, start2, len2);
            } else {
                this.mWriter.writeAttribute(localName, buf, start2, len2);
            }
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    protected void doWriteNamespace(String prefix2, String nsURI) throws XMLStreamException {
        try {
            int vlen = nsURI.length();
            if (vlen >= 12) {
                char[] buf = this.mCopyBuffer;
                if (buf == null) {
                    this.mCopyBuffer = buf = this.mConfig.allocMediumCBuffer(512);
                }
                if (vlen <= buf.length) {
                    nsURI.getChars(0, vlen, buf, 0);
                    this.mWriter.writeAttribute("xmlns", prefix2, buf, 0, vlen);
                    return;
                }
            }
            this.mWriter.writeAttribute("xmlns", prefix2, nsURI);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    protected void doWriteDefaultNs(String nsURI) throws XMLStreamException {
        try {
            int vlen;
            int n = vlen = nsURI == null ? 0 : nsURI.length();
            if (vlen >= 12) {
                char[] buf = this.mCopyBuffer;
                if (buf == null) {
                    this.mCopyBuffer = buf = this.mConfig.allocMediumCBuffer(512);
                }
                if (vlen <= buf.length) {
                    nsURI.getChars(0, vlen, buf, 0);
                    this.mWriter.writeAttribute("xmlns", buf, 0, vlen);
                    return;
                }
            }
            this.mWriter.writeAttribute("xmlns", nsURI);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    protected final void doWriteStartTag(String localName) throws XMLStreamException {
        this.mAnyOutput = true;
        this.mStartElementOpen = true;
        try {
            this.mWriter.writeStartTagStart(localName);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    protected final void doWriteStartTag(String prefix2, String localName) throws XMLStreamException {
        this.mAnyOutput = true;
        this.mStartElementOpen = true;
        try {
            boolean hasPrefix;
            boolean bl = hasPrefix = prefix2 != null && prefix2.length() > 0;
            if (hasPrefix) {
                this.mWriter.writeStartTagStart(prefix2, localName);
            } else {
                this.mWriter.writeStartTagStart(localName);
            }
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
    }

    protected void doWriteEndTag(QName expName, boolean allowEmpty) throws XMLStreamException {
        if (this.mStartElementOpen && this.mEmptyElement) {
            this.mEmptyElement = false;
            this.closeStartElement(true);
        }
        if (this.mState != 2) {
            BaseNsStreamWriter.reportNwfStructure("No open start element, when trying to write end element");
        }
        SimpleOutputElement thisElem = this.mCurrElem;
        String prefix2 = thisElem.getPrefix();
        String localName = thisElem.getLocalName();
        String nsURI = thisElem.getNamespaceURI();
        this.mCurrElem = thisElem.getParent();
        if (this.mPoolSize < 8) {
            thisElem.addToPool(this.mOutputElemPool);
            this.mOutputElemPool = thisElem;
            ++this.mPoolSize;
        }
        if (this.mCheckStructure && expName != null && !localName.equals(expName.getLocalPart())) {
            BaseNsStreamWriter.reportNwfStructure("Mismatching close element local name, '" + localName + "'; expected '" + expName.getLocalPart() + "'.");
        }
        if (this.mStartElementOpen) {
            if (this.mValidator != null) {
                this.mVldContent = this.mValidator.validateElementAndAttributes();
            }
            this.mStartElementOpen = false;
            try {
                if (this.mEmptyElementHandler != null) {
                    allowEmpty = this.mEmptyElementHandler.allowEmptyElement(prefix2, localName, nsURI, allowEmpty);
                }
                if (allowEmpty) {
                    this.mWriter.writeStartTagEmptyEnd();
                    if (this.mCurrElem.isRoot()) {
                        this.mState = 3;
                    }
                    if (this.mValidator != null) {
                        this.mVldContent = this.mValidator.validateElementEnd(localName, nsURI, prefix2);
                    }
                    return;
                }
                this.mWriter.writeStartTagEnd();
            }
            catch (IOException ioe) {
                throw new WstxIOException(ioe);
            }
        }
        try {
            this.mWriter.writeEndTag(prefix2, localName);
        }
        catch (IOException ioe) {
            throw new WstxIOException(ioe);
        }
        if (this.mCurrElem.isRoot()) {
            this.mState = 3;
        }
        if (this.mValidator != null) {
            this.mVldContent = this.mValidator.validateElementEnd(localName, nsURI, prefix2);
        }
    }

    public abstract void doSetPrefix(String var1, String var2) throws XMLStreamException;

    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    public abstract void writeNamespace(String var1, String var2) throws XMLStreamException;

    public abstract void writeStartElement(StartElement var1) throws XMLStreamException;

    protected abstract void writeStartOrEmpty(String var1, String var2) throws XMLStreamException;

    protected abstract void writeStartOrEmpty(String var1, String var2, String var3) throws XMLStreamException;
}

