/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.io.CharsetNames;
import com.ctc.wstx.io.CompletelyCloseable;
import com.ctc.wstx.sw.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.typed.AsciiValueEncoder;
import org.codehaus.stax2.validation.XMLValidator;

public final class BufferingXmlWriter
extends XmlWriter
implements XMLStreamConstants {
    static final int DEFAULT_BUFFER_SIZE = 1000;
    static final int DEFAULT_SMALL_SIZE = 256;
    protected static final int HIGHEST_ENCODABLE_ATTR_CHAR = 60;
    protected static final int HIGHEST_ENCODABLE_TEXT_CHAR = 62;
    protected final Writer mOut;
    protected char[] mOutputBuffer;
    protected final int mSmallWriteSize;
    protected int mOutputPtr;
    protected int mOutputBufLen;
    protected final OutputStream mUnderlyingStream;
    private final int mEncHighChar;
    final char mEncQuoteChar;
    final String mEncQuoteEntity;

    public BufferingXmlWriter(Writer out, WriterConfig cfg, String enc, boolean autoclose, OutputStream outs, int bitsize) throws IOException {
        super(cfg, enc, autoclose);
        this.mOut = out;
        this.mOutputBuffer = cfg.allocFullCBuffer(1000);
        this.mOutputBufLen = this.mOutputBuffer.length;
        this.mSmallWriteSize = 256;
        this.mOutputPtr = 0;
        this.mUnderlyingStream = outs;
        this.mEncQuoteChar = (char)34;
        this.mEncQuoteEntity = "&quot;";
        if (bitsize < 1) {
            bitsize = BufferingXmlWriter.guessEncodingBitSize(enc);
        }
        this.mEncHighChar = bitsize < 16 ? 1 << bitsize : 65534;
    }

    protected int getOutputPtr() {
        return this.mOutputPtr;
    }

    protected final OutputStream getOutputStream() {
        return this.mUnderlyingStream;
    }

    protected final Writer getWriter() {
        return this.mOut;
    }

    public void close(boolean forceRealClose) throws IOException {
        this.flush();
        this.mTextWriter = null;
        this.mAttrValueWriter = null;
        char[] buf = this.mOutputBuffer;
        if (buf != null) {
            this.mOutputBuffer = null;
            this.mConfig.freeFullCBuffer(buf);
        }
        if (forceRealClose || this.mAutoCloseOutput) {
            if (this.mOut instanceof CompletelyCloseable) {
                ((CompletelyCloseable)((Object)this.mOut)).closeCompletely();
            } else {
                this.mOut.close();
            }
        }
    }

    public final void flush() throws IOException {
        this.flushBuffer();
        this.mOut.flush();
    }

    public void writeRaw(char[] cbuf, int offset2, int len2) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (len2 < this.mSmallWriteSize) {
            if (this.mOutputPtr + len2 > this.mOutputBufLen) {
                this.flushBuffer();
            }
            System.arraycopy(cbuf, offset2, this.mOutputBuffer, this.mOutputPtr, len2);
            this.mOutputPtr += len2;
            return;
        }
        int ptr = this.mOutputPtr;
        if (ptr > 0) {
            if (ptr < this.mSmallWriteSize) {
                int needed = this.mSmallWriteSize - ptr;
                System.arraycopy(cbuf, offset2, this.mOutputBuffer, ptr, needed);
                this.mOutputPtr = ptr + needed;
                len2 -= needed;
                offset2 += needed;
            }
            this.flushBuffer();
        }
        this.mOut.write(cbuf, offset2, len2);
    }

    public final void writeRawAscii(char[] cbuf, int offset2, int len2) throws IOException {
        this.writeRaw(cbuf, offset2, len2);
    }

    public void writeRaw(String str) throws IOException {
        if (this.mOut == null) {
            return;
        }
        int len2 = str.length();
        if (len2 < this.mSmallWriteSize) {
            if (this.mOutputPtr + len2 >= this.mOutputBufLen) {
                this.flushBuffer();
            }
            str.getChars(0, len2, this.mOutputBuffer, this.mOutputPtr);
            this.mOutputPtr += len2;
            return;
        }
        this.writeRaw(str, 0, len2);
    }

    public void writeRaw(String str, int offset2, int len2) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (len2 < this.mSmallWriteSize) {
            if (this.mOutputPtr + len2 >= this.mOutputBufLen) {
                this.flushBuffer();
            }
            str.getChars(offset2, offset2 + len2, this.mOutputBuffer, this.mOutputPtr);
            this.mOutputPtr += len2;
            return;
        }
        int ptr = this.mOutputPtr;
        if (ptr > 0) {
            if (ptr < this.mSmallWriteSize) {
                int needed = this.mSmallWriteSize - ptr;
                str.getChars(offset2, offset2 + needed, this.mOutputBuffer, ptr);
                this.mOutputPtr = ptr + needed;
                len2 -= needed;
                offset2 += needed;
            }
            this.flushBuffer();
        }
        this.mOut.write(str, offset2, len2);
    }

    public final void writeCDataStart() throws IOException {
        this.fastWriteRaw("<![CDATA[");
    }

    public final void writeCDataEnd() throws IOException {
        this.fastWriteRaw("]]>");
    }

    public final void writeCommentStart() throws IOException {
        this.fastWriteRaw("<!--");
    }

    public final void writeCommentEnd() throws IOException {
        this.fastWriteRaw("-->");
    }

    public final void writePIStart(String target2, boolean addSpace) throws IOException {
        this.fastWriteRaw('<', '?');
        this.fastWriteRaw(target2);
        if (addSpace) {
            this.fastWriteRaw(' ');
        }
    }

    public final void writePIEnd() throws IOException {
        this.fastWriteRaw('?', '>');
    }

    public int writeCData(String data2) throws IOException {
        int ix;
        if (this.mCheckContent && (ix = this.verifyCDataContent(data2)) >= 0) {
            if (!this.mFixContent) {
                return ix;
            }
            this.writeSegmentedCData(data2, ix);
            return -1;
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(data2, 0, data2.length());
        this.fastWriteRaw("]]>");
        return -1;
    }

    public int writeCData(char[] cbuf, int offset2, int len2) throws IOException {
        int ix;
        if (this.mCheckContent && (ix = this.verifyCDataContent(cbuf, offset2, len2)) >= 0) {
            if (!this.mFixContent) {
                return ix;
            }
            this.writeSegmentedCData(cbuf, offset2, len2, ix);
            return -1;
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(cbuf, offset2, len2);
        this.fastWriteRaw("]]>");
        return -1;
    }

    public void writeCharacters(String text2) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (this.mTextWriter != null) {
            this.mTextWriter.write(text2);
            return;
        }
        int inPtr = 0;
        int len2 = text2.length();
        int highChar = this.mEncHighChar;
        block0: while (true) {
            String ent = null;
            while (inPtr < len2) {
                block14: {
                    char c2;
                    block12: {
                        block10: {
                            block16: {
                                block15: {
                                    block11: {
                                        block13: {
                                            if ((c2 = text2.charAt(inPtr++)) > '>') break block10;
                                            if (c2 > ' ') break block11;
                                            if (c2 == ' ' || c2 == '\n' || c2 == '\t') break block12;
                                            if (c2 != '\r') break block13;
                                            if (!this.mEscapeCR) break block12;
                                            break block14;
                                        }
                                        if (this.mXml11 && c2 != '\u0000') break block14;
                                        c2 = this.handleInvalidChar(c2);
                                        break block12;
                                    }
                                    if (c2 != '<') break block15;
                                    ent = "&lt;";
                                    break block14;
                                }
                                if (c2 != '&') break block16;
                                ent = "&amp;";
                                break block14;
                            }
                            if (c2 != '>' || inPtr >= 2 && text2.charAt(inPtr - 2) != ']') break block12;
                            ent = "&gt;";
                            break block14;
                        }
                        if (c2 >= highChar) break block14;
                    }
                    if (this.mOutputPtr >= this.mOutputBufLen) {
                        this.flushBuffer();
                    }
                    this.mOutputBuffer[this.mOutputPtr++] = c2;
                    continue;
                }
                if (ent != null) {
                    this.writeRaw(ent);
                    continue block0;
                }
                this.writeAsEntity(text2.charAt(inPtr - 1));
                continue block0;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeCharacters(char[] cbuf, int offset2, int len2) throws IOException {
        if (this.mOut == null) {
            return;
        }
        if (this.mTextWriter != null) {
            this.mTextWriter.write(cbuf, offset2, len2);
            return;
        }
        len2 += offset2;
        do {
            int outLen;
            char c2 = '\u0000';
            int highChar = this.mEncHighChar;
            int start2 = offset2;
            String ent = null;
            while (offset2 < len2) {
                block15: {
                    block16: {
                        c2 = cbuf[offset2];
                        if (c2 > '>') break block16;
                        if (c2 == '<') {
                            ent = "&lt;";
                            break;
                        }
                        if (c2 == '&') {
                            ent = "&amp;";
                            break;
                        }
                        if (c2 == '>') {
                            if (offset2 == start2 || cbuf[offset2 - 1] == ']') {
                                ent = "&gt;";
                                break;
                            }
                            break block15;
                        } else if (c2 < ' ' && c2 != '\n' && c2 != '\t') {
                            if (c2 == '\r') {
                                if (this.mEscapeCR) {
                                    break;
                                }
                                break block15;
                            } else {
                                if (this.mXml11 && c2 != '\u0000') break;
                                c2 = this.handleInvalidChar(c2);
                                ent = String.valueOf(c2);
                                break;
                            }
                        }
                        break block15;
                    }
                    if (c2 >= highChar) break;
                }
                ++offset2;
            }
            if ((outLen = offset2 - start2) > 0) {
                this.writeRaw(cbuf, start2, outLen);
            }
            if (ent != null) {
                this.writeRaw(ent);
                ent = null;
                continue;
            }
            if (offset2 >= len2) continue;
            this.writeAsEntity(c2);
        } while (++offset2 < len2);
    }

    public int writeComment(String data2) throws IOException {
        int ix;
        if (this.mCheckContent && (ix = this.verifyCommentContent(data2)) >= 0) {
            if (!this.mFixContent) {
                return ix;
            }
            this.writeSegmentedComment(data2, ix);
            return -1;
        }
        this.fastWriteRaw("<!--");
        this.writeRaw(data2);
        this.fastWriteRaw("-->");
        return -1;
    }

    public void writeDTD(String data2) throws IOException {
        this.writeRaw(data2);
    }

    public void writeDTD(String rootName, String systemId, String publicId, String internalSubset) throws IOException, XMLStreamException {
        this.fastWriteRaw("<!DOCTYPE ");
        if (this.mCheckNames) {
            this.verifyNameValidity(rootName, false);
        }
        this.fastWriteRaw(rootName);
        if (systemId != null) {
            if (publicId != null) {
                this.fastWriteRaw(" PUBLIC \"");
                this.fastWriteRaw(publicId);
                this.fastWriteRaw("\" \"");
            } else {
                this.fastWriteRaw(" SYSTEM \"");
            }
            this.fastWriteRaw(systemId);
            this.fastWriteRaw('\"');
        }
        if (internalSubset != null && internalSubset.length() > 0) {
            this.fastWriteRaw(' ', '[');
            this.fastWriteRaw(internalSubset);
            this.fastWriteRaw(']');
        }
        this.fastWriteRaw('>');
    }

    public void writeEntityReference(String name) throws IOException, XMLStreamException {
        if (this.mCheckNames) {
            this.verifyNameValidity(name, this.mNsAware);
        }
        this.fastWriteRaw('&');
        this.fastWriteRaw(name);
        this.fastWriteRaw(';');
    }

    public void writeXmlDeclaration(String version, String encoding, String standalone) throws IOException {
        this.fastWriteRaw("<?xml version='");
        this.fastWriteRaw(version);
        this.fastWriteRaw('\'');
        if (encoding != null && encoding.length() > 0) {
            this.fastWriteRaw(" encoding='");
            this.fastWriteRaw(encoding);
            this.fastWriteRaw('\'');
        }
        if (standalone != null) {
            this.fastWriteRaw(" standalone='");
            this.fastWriteRaw(standalone);
            this.fastWriteRaw('\'');
        }
        this.fastWriteRaw('?', '>');
    }

    public int writePI(String target2, String data2) throws IOException, XMLStreamException {
        if (this.mCheckNames) {
            this.verifyNameValidity(target2, this.mNsAware);
        }
        this.fastWriteRaw('<', '?');
        this.fastWriteRaw(target2);
        if (data2 != null && data2.length() > 0) {
            int ix;
            if (this.mCheckContent && (ix = data2.indexOf(63)) >= 0 && (ix = data2.indexOf("?>", ix)) >= 0) {
                return ix;
            }
            this.fastWriteRaw(' ');
            this.writeRaw(data2);
        }
        this.fastWriteRaw('?', '>');
        return -1;
    }

    public void writeStartTagStart(String localName) throws IOException, XMLStreamException {
        int ptr;
        int extra;
        if (this.mCheckNames) {
            this.verifyNameValidity(localName, this.mNsAware);
        }
        if ((extra = this.mOutputBufLen - (ptr = this.mOutputPtr) - (1 + localName.length())) < 0) {
            this.fastWriteRaw('<');
            this.fastWriteRaw(localName);
        } else {
            char[] buf = this.mOutputBuffer;
            buf[ptr++] = 60;
            int len2 = localName.length();
            localName.getChars(0, len2, buf, ptr);
            this.mOutputPtr = ptr + len2;
        }
    }

    public void writeStartTagStart(String prefix2, String localName) throws IOException, XMLStreamException {
        if (prefix2 == null || prefix2.length() == 0) {
            this.writeStartTagStart(localName);
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(prefix2, this.mNsAware);
            this.verifyNameValidity(localName, this.mNsAware);
        }
        int ptr = this.mOutputPtr;
        int len2 = prefix2.length();
        int extra = this.mOutputBufLen - ptr - (2 + localName.length() + len2);
        if (extra < 0) {
            this.fastWriteRaw('<');
            this.fastWriteRaw(prefix2);
            this.fastWriteRaw(':');
            this.fastWriteRaw(localName);
        } else {
            char[] buf = this.mOutputBuffer;
            buf[ptr++] = 60;
            prefix2.getChars(0, len2, buf, ptr);
            ptr += len2;
            buf[ptr++] = 58;
            len2 = localName.length();
            localName.getChars(0, len2, buf, ptr);
            this.mOutputPtr = ptr + len2;
        }
    }

    public void writeStartTagEnd() throws IOException {
        this.fastWriteRaw('>');
    }

    public void writeStartTagEmptyEnd() throws IOException {
        int ptr = this.mOutputPtr;
        if (ptr + 3 >= this.mOutputBufLen) {
            if (this.mOut == null) {
                return;
            }
            this.flushBuffer();
            ptr = this.mOutputPtr;
        }
        char[] buf = this.mOutputBuffer;
        if (this.mAddSpaceAfterEmptyElem) {
            buf[ptr++] = 32;
        }
        buf[ptr++] = 47;
        buf[ptr++] = 62;
        this.mOutputPtr = ptr;
    }

    public void writeEndTag(String localName) throws IOException {
        int ptr = this.mOutputPtr;
        int extra = this.mOutputBufLen - ptr - (3 + localName.length());
        if (extra < 0) {
            this.fastWriteRaw('<', '/');
            this.fastWriteRaw(localName);
            this.fastWriteRaw('>');
        } else {
            char[] buf = this.mOutputBuffer;
            buf[ptr++] = 60;
            buf[ptr++] = 47;
            int len2 = localName.length();
            localName.getChars(0, len2, buf, ptr);
            ptr += len2;
            buf[ptr++] = 62;
            this.mOutputPtr = ptr;
        }
    }

    public void writeEndTag(String prefix2, String localName) throws IOException {
        if (prefix2 == null || prefix2.length() == 0) {
            this.writeEndTag(localName);
            return;
        }
        int ptr = this.mOutputPtr;
        int len2 = prefix2.length();
        int extra = this.mOutputBufLen - ptr - (4 + localName.length() + len2);
        if (extra < 0) {
            this.fastWriteRaw('<', '/');
            this.fastWriteRaw(prefix2);
            this.fastWriteRaw(':');
            this.fastWriteRaw(localName);
            this.fastWriteRaw('>');
        } else {
            char[] buf = this.mOutputBuffer;
            buf[ptr++] = 60;
            buf[ptr++] = 47;
            prefix2.getChars(0, len2, buf, ptr);
            ptr += len2;
            buf[ptr++] = 58;
            len2 = localName.length();
            localName.getChars(0, len2, buf, ptr);
            ptr += len2;
            buf[ptr++] = 62;
            this.mOutputPtr = ptr;
        }
    }

    public void writeAttribute(String localName, String value2) throws IOException, XMLStreamException {
        int len2;
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(localName, this.mNsAware);
        }
        if (this.mOutputBufLen - this.mOutputPtr - (3 + (len2 = localName.length())) < 0) {
            this.fastWriteRaw(' ');
            this.fastWriteRaw(localName);
            this.fastWriteRaw('=', '\"');
        } else {
            int ptr = this.mOutputPtr;
            char[] buf = this.mOutputBuffer;
            buf[ptr++] = 32;
            localName.getChars(0, len2, buf, ptr);
            ptr += len2;
            buf[ptr++] = 61;
            buf[ptr++] = 34;
            this.mOutputPtr = ptr;
        }
        int n = len2 = value2 == null ? 0 : value2.length();
        if (len2 > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(value2, 0, len2);
            } else {
                this.writeAttrValue(value2, len2);
            }
        }
        this.fastWriteRaw('\"');
    }

    public void writeAttribute(String localName, char[] value2, int offset2, int vlen) throws IOException, XMLStreamException {
        int len2;
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(localName, this.mNsAware);
        }
        if (this.mOutputBufLen - this.mOutputPtr - (3 + (len2 = localName.length())) < 0) {
            this.fastWriteRaw(' ');
            this.fastWriteRaw(localName);
            this.fastWriteRaw('=', '\"');
        } else {
            int ptr = this.mOutputPtr;
            char[] buf = this.mOutputBuffer;
            buf[ptr++] = 32;
            localName.getChars(0, len2, buf, ptr);
            ptr += len2;
            buf[ptr++] = 61;
            buf[ptr++] = 34;
            this.mOutputPtr = ptr;
        }
        if (vlen > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(value2, offset2, vlen);
            } else {
                this.writeAttrValue(value2, offset2, vlen);
            }
        }
        this.fastWriteRaw('\"');
    }

    public void writeAttribute(String prefix2, String localName, String value2) throws IOException, XMLStreamException {
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(prefix2, this.mNsAware);
            this.verifyNameValidity(localName, this.mNsAware);
        }
        int len2 = prefix2.length();
        if (this.mOutputBufLen - this.mOutputPtr - (4 + localName.length() + len2) < 0) {
            this.fastWriteRaw(' ');
            if (len2 > 0) {
                this.fastWriteRaw(prefix2);
                this.fastWriteRaw(':');
            }
            this.fastWriteRaw(localName);
            this.fastWriteRaw('=', '\"');
        } else {
            int ptr = this.mOutputPtr;
            char[] buf = this.mOutputBuffer;
            buf[ptr++] = 32;
            prefix2.getChars(0, len2, buf, ptr);
            ptr += len2;
            buf[ptr++] = 58;
            len2 = localName.length();
            localName.getChars(0, len2, buf, ptr);
            ptr += len2;
            buf[ptr++] = 61;
            buf[ptr++] = 34;
            this.mOutputPtr = ptr;
        }
        int n = len2 = value2 == null ? 0 : value2.length();
        if (len2 > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(value2, 0, len2);
            } else {
                this.writeAttrValue(value2, len2);
            }
        }
        this.fastWriteRaw('\"');
    }

    public void writeAttribute(String prefix2, String localName, char[] value2, int offset2, int vlen) throws IOException, XMLStreamException {
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(prefix2, this.mNsAware);
            this.verifyNameValidity(localName, this.mNsAware);
        }
        int len2 = prefix2.length();
        if (this.mOutputBufLen - this.mOutputPtr - (4 + localName.length() + len2) < 0) {
            this.fastWriteRaw(' ');
            if (len2 > 0) {
                this.fastWriteRaw(prefix2);
                this.fastWriteRaw(':');
            }
            this.fastWriteRaw(localName);
            this.fastWriteRaw('=', '\"');
        } else {
            int ptr = this.mOutputPtr;
            char[] buf = this.mOutputBuffer;
            buf[ptr++] = 32;
            prefix2.getChars(0, len2, buf, ptr);
            ptr += len2;
            buf[ptr++] = 58;
            len2 = localName.length();
            localName.getChars(0, len2, buf, ptr);
            ptr += len2;
            buf[ptr++] = 61;
            buf[ptr++] = 34;
            this.mOutputPtr = ptr;
        }
        if (vlen > 0) {
            if (this.mAttrValueWriter != null) {
                this.mAttrValueWriter.write(value2, offset2, vlen);
            } else {
                this.writeAttrValue(value2, offset2, vlen);
            }
        }
        this.fastWriteRaw('\"');
    }

    private final void writeAttrValue(String value2, int len2) throws IOException {
        int inPtr = 0;
        char qchar = this.mEncQuoteChar;
        int highChar = this.mEncHighChar;
        block0: while (true) {
            String ent = null;
            while (inPtr < len2) {
                block11: {
                    char c2;
                    block10: {
                        block7: {
                            block13: {
                                block12: {
                                    block8: {
                                        block9: {
                                            if ((c2 = value2.charAt(inPtr++)) > '<') break block7;
                                            if (c2 >= ' ') break block8;
                                            if (c2 != '\r') break block9;
                                            if (!this.mEscapeCR) break block10;
                                            break block11;
                                        }
                                        if (c2 == '\n' || c2 == '\t' || this.mXml11 && c2 != '\u0000') break block11;
                                        c2 = this.handleInvalidChar(c2);
                                        break block10;
                                    }
                                    if (c2 != qchar) break block12;
                                    ent = this.mEncQuoteEntity;
                                    break block11;
                                }
                                if (c2 != '<') break block13;
                                ent = "&lt;";
                                break block11;
                            }
                            if (c2 != '&') break block10;
                            ent = "&amp;";
                            break block11;
                        }
                        if (c2 >= highChar) break block11;
                    }
                    if (this.mOutputPtr >= this.mOutputBufLen) {
                        this.flushBuffer();
                    }
                    this.mOutputBuffer[this.mOutputPtr++] = c2;
                    continue;
                }
                if (ent != null) {
                    this.writeRaw(ent);
                    continue block0;
                }
                this.writeAsEntity(value2.charAt(inPtr - 1));
                continue block0;
            }
            break;
        }
    }

    private final void writeAttrValue(char[] value2, int offset2, int len2) throws IOException {
        len2 += offset2;
        char qchar = this.mEncQuoteChar;
        int highChar = this.mEncHighChar;
        block0: while (true) {
            String ent = null;
            while (offset2 < len2) {
                block11: {
                    char c2;
                    block10: {
                        block7: {
                            block13: {
                                block12: {
                                    block8: {
                                        block9: {
                                            if ((c2 = value2[offset2++]) > '<') break block7;
                                            if (c2 >= ' ') break block8;
                                            if (c2 != '\r') break block9;
                                            if (!this.mEscapeCR) break block10;
                                            break block11;
                                        }
                                        if (c2 == '\n' || c2 == '\t' || this.mXml11 && c2 != '\u0000') break block11;
                                        c2 = this.handleInvalidChar(c2);
                                        break block10;
                                    }
                                    if (c2 != qchar) break block12;
                                    ent = this.mEncQuoteEntity;
                                    break block11;
                                }
                                if (c2 != '<') break block13;
                                ent = "&lt;";
                                break block11;
                            }
                            if (c2 != '&') break block10;
                            ent = "&amp;";
                            break block11;
                        }
                        if (c2 >= highChar) break block11;
                    }
                    if (this.mOutputPtr >= this.mOutputBufLen) {
                        this.flushBuffer();
                    }
                    this.mOutputBuffer[this.mOutputPtr++] = c2;
                    continue;
                }
                if (ent != null) {
                    this.writeRaw(ent);
                    continue block0;
                }
                this.writeAsEntity(value2[offset2 - 1]);
                continue block0;
            }
            break;
        }
    }

    public final void writeTypedElement(AsciiValueEncoder enc) throws IOException {
        if (this.mOut == null) {
            return;
        }
        int free = this.mOutputBufLen - this.mOutputPtr;
        if (enc.bufferNeedsFlush(free)) {
            this.flush();
        }
        while (true) {
            this.mOutputPtr = enc.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
            if (enc.isCompleted()) break;
            this.flush();
        }
    }

    public final void writeTypedElement(AsciiValueEncoder enc, XMLValidator validator, char[] copyBuffer) throws IOException, XMLStreamException {
        if (this.mOut == null) {
            return;
        }
        int free = this.mOutputBufLen - this.mOutputPtr;
        if (enc.bufferNeedsFlush(free)) {
            this.flush();
        }
        int start2 = this.mOutputPtr;
        while (true) {
            this.mOutputPtr = enc.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
            validator.validateText(this.mOutputBuffer, start2, this.mOutputPtr, false);
            if (enc.isCompleted()) break;
            this.flush();
            start2 = this.mOutputPtr;
        }
    }

    public void writeTypedAttribute(String localName, AsciiValueEncoder enc) throws IOException, XMLStreamException {
        int len2;
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(localName, this.mNsAware);
        }
        if (this.mOutputPtr + 3 + (len2 = localName.length()) > this.mOutputBufLen) {
            this.fastWriteRaw(' ');
            this.fastWriteRaw(localName);
            this.fastWriteRaw('=', '\"');
        } else {
            int ptr = this.mOutputPtr;
            char[] buf = this.mOutputBuffer;
            buf[ptr++] = 32;
            localName.getChars(0, len2, buf, ptr);
            ptr += len2;
            buf[ptr++] = 61;
            buf[ptr++] = 34;
            this.mOutputPtr = ptr;
        }
        int free = this.mOutputBufLen - this.mOutputPtr;
        if (enc.bufferNeedsFlush(free)) {
            this.flush();
        }
        while (true) {
            this.mOutputPtr = enc.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
            if (enc.isCompleted()) break;
            this.flush();
        }
        this.fastWriteRaw('\"');
    }

    public void writeTypedAttribute(String prefix2, String localName, AsciiValueEncoder enc) throws IOException, XMLStreamException {
        int llen;
        int plen;
        if (this.mOut == null) {
            return;
        }
        if (this.mCheckNames) {
            this.verifyNameValidity(prefix2, this.mNsAware);
            this.verifyNameValidity(localName, this.mNsAware);
        }
        if (this.mOutputPtr + 4 + (plen = prefix2.length()) + (llen = localName.length()) > this.mOutputBufLen) {
            this.writePrefixedName(prefix2, localName);
            this.fastWriteRaw('=', '\"');
        } else {
            int ptr = this.mOutputPtr;
            char[] buf = this.mOutputBuffer;
            buf[ptr++] = 32;
            if (plen > 0) {
                prefix2.getChars(0, plen, buf, ptr);
                ptr += plen;
                buf[ptr++] = 58;
            }
            localName.getChars(0, llen, buf, ptr);
            ptr += llen;
            buf[ptr++] = 61;
            buf[ptr++] = 34;
            this.mOutputPtr = ptr;
        }
        int free = this.mOutputBufLen - this.mOutputPtr;
        if (enc.bufferNeedsFlush(free)) {
            this.flush();
        }
        while (true) {
            this.mOutputPtr = enc.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
            if (enc.isCompleted()) break;
            this.flush();
        }
        this.fastWriteRaw('\"');
    }

    public void writeTypedAttribute(String prefix2, String localName, String nsURI, AsciiValueEncoder enc, XMLValidator validator, char[] copyBuffer) throws IOException, XMLStreamException {
        if (this.mOut == null) {
            return;
        }
        if (prefix2 == null) {
            prefix2 = "";
        }
        if (nsURI == null) {
            nsURI = "";
        }
        int plen = prefix2.length();
        if (this.mCheckNames) {
            if (plen > 0) {
                this.verifyNameValidity(prefix2, this.mNsAware);
            }
            this.verifyNameValidity(localName, this.mNsAware);
        }
        if (this.mOutputBufLen - this.mOutputPtr - (4 + localName.length() + plen) < 0) {
            this.writePrefixedName(prefix2, localName);
            this.fastWriteRaw('=', '\"');
        } else {
            int ptr = this.mOutputPtr;
            char[] buf = this.mOutputBuffer;
            buf[ptr++] = 32;
            if (plen > 0) {
                prefix2.getChars(0, plen, buf, ptr);
                ptr += plen;
                buf[ptr++] = 58;
            }
            int llen = localName.length();
            localName.getChars(0, llen, buf, ptr);
            ptr += llen;
            buf[ptr++] = 61;
            buf[ptr++] = 34;
            this.mOutputPtr = ptr;
        }
        int free = this.mOutputBufLen - this.mOutputPtr;
        if (enc.bufferNeedsFlush(free)) {
            this.flush();
        }
        int start2 = this.mOutputPtr;
        this.mOutputPtr = enc.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
        if (enc.isCompleted()) {
            validator.validateAttribute(localName, nsURI, prefix2, this.mOutputBuffer, start2, this.mOutputPtr);
            return;
        }
        StringBuffer sb = new StringBuffer(this.mOutputBuffer.length << 1);
        sb.append(this.mOutputBuffer, start2, this.mOutputPtr - start2);
        do {
            this.flush();
            start2 = this.mOutputPtr;
            this.mOutputPtr = enc.encodeMore(this.mOutputBuffer, this.mOutputPtr, this.mOutputBufLen);
            sb.append(this.mOutputBuffer, start2, this.mOutputPtr - start2);
        } while (!enc.isCompleted());
        this.fastWriteRaw('\"');
        String valueStr = sb.toString();
        validator.validateAttribute(localName, nsURI, prefix2, valueStr);
    }

    protected final void writePrefixedName(String prefix2, String localName) throws IOException {
        this.fastWriteRaw(' ');
        if (prefix2.length() > 0) {
            this.fastWriteRaw(prefix2);
            this.fastWriteRaw(':');
        }
        this.fastWriteRaw(localName);
    }

    private final void flushBuffer() throws IOException {
        if (this.mOutputPtr > 0 && this.mOutputBuffer != null) {
            int ptr = this.mOutputPtr;
            this.mLocPastChars += ptr;
            this.mLocRowStartOffset -= ptr;
            this.mOutputPtr = 0;
            this.mOut.write(this.mOutputBuffer, 0, ptr);
        }
    }

    private final void fastWriteRaw(char c2) throws IOException {
        if (this.mOutputPtr >= this.mOutputBufLen) {
            if (this.mOut == null) {
                return;
            }
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputPtr++] = c2;
    }

    private final void fastWriteRaw(char c1, char c2) throws IOException {
        if (this.mOutputPtr + 1 >= this.mOutputBufLen) {
            if (this.mOut == null) {
                return;
            }
            this.flushBuffer();
        }
        this.mOutputBuffer[this.mOutputPtr++] = c1;
        this.mOutputBuffer[this.mOutputPtr++] = c2;
    }

    private final void fastWriteRaw(String str) throws IOException {
        int ptr = this.mOutputPtr;
        int len2 = str.length();
        if (ptr + len2 >= this.mOutputBufLen) {
            if (this.mOut == null) {
                return;
            }
            if (len2 > this.mOutputBufLen) {
                this.writeRaw(str);
                return;
            }
            this.flushBuffer();
            ptr = this.mOutputPtr;
        }
        str.getChars(0, len2, this.mOutputBuffer, ptr);
        this.mOutputPtr = ptr + len2;
    }

    protected int verifyCDataContent(String content2) {
        int ix;
        if (content2 != null && content2.length() >= 3 && (ix = content2.indexOf(93)) >= 0) {
            return content2.indexOf("]]>", ix);
        }
        return -1;
    }

    protected int verifyCDataContent(char[] c2, int start2, int end2) {
        if (c2 != null) {
            start2 += 2;
            while (start2 < end2) {
                char ch = c2[start2];
                if (ch == ']') {
                    ++start2;
                    continue;
                }
                if (ch == '>' && c2[start2 - 1] == ']' && c2[start2 - 2] == ']') {
                    return start2 - 2;
                }
                start2 += 2;
            }
        }
        return -1;
    }

    protected int verifyCommentContent(String content2) {
        int ix = content2.indexOf(45);
        if (ix >= 0 && ix < content2.length() - 1) {
            ix = content2.indexOf("--", ix);
        }
        return ix;
    }

    protected void writeSegmentedCData(String content2, int index2) throws IOException {
        int start2 = 0;
        while (index2 >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(content2, start2, index2 + 2 - start2);
            this.fastWriteRaw("]]>");
            start2 = index2 + 2;
            index2 = content2.indexOf("]]>", start2);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(content2, start2, content2.length() - start2);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedCData(char[] c2, int start2, int len2, int index2) throws IOException {
        int end2 = start2 + len2;
        while (index2 >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(c2, start2, index2 + 2 - start2);
            this.fastWriteRaw("]]>");
            start2 = index2 + 2;
            index2 = this.verifyCDataContent(c2, start2, end2);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(c2, start2, end2 - start2);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedComment(String content2, int index2) throws IOException {
        int len2 = content2.length();
        if (index2 == len2 - 1) {
            this.fastWriteRaw("<!--");
            this.writeRaw(content2);
            this.fastWriteRaw(" -->");
            return;
        }
        this.fastWriteRaw("<!--");
        int start2 = 0;
        while (index2 >= 0) {
            this.writeRaw(content2, start2, index2 + 1 - start2);
            this.fastWriteRaw(' ');
            start2 = index2 + 1;
            index2 = content2.indexOf("--", start2);
        }
        this.writeRaw(content2, start2, len2 - start2);
        if (content2.charAt(len2 - 1) == '-') {
            this.fastWriteRaw(' ');
        }
        this.fastWriteRaw("-->");
    }

    public static int guessEncodingBitSize(String enc) {
        if (enc == null || enc.length() == 0) {
            return 16;
        }
        if ((enc = CharsetNames.normalize(enc)) == "UTF-8") {
            return 16;
        }
        if (enc == "ISO-8859-1") {
            return 8;
        }
        if (enc == "US-ASCII") {
            return 7;
        }
        if (enc == "UTF-16" || enc == "UTF-16BE" || enc == "UTF-16LE" || enc == "UTF-32BE" || enc == "UTF-32LE") {
            return 16;
        }
        return 8;
    }

    protected final void writeAsEntity(int c2) throws IOException {
        int ptr = this.mOutputPtr;
        char[] buf = this.mOutputBuffer;
        if (ptr + 10 >= buf.length) {
            this.flushBuffer();
            ptr = this.mOutputPtr;
        }
        buf[ptr++] = 38;
        if (c2 < 256) {
            if (c2 == 38) {
                buf[ptr++] = 97;
                buf[ptr++] = 109;
                buf[ptr++] = 112;
            } else if (c2 == 60) {
                buf[ptr++] = 108;
                buf[ptr++] = 116;
            } else if (c2 == 62) {
                buf[ptr++] = 103;
                buf[ptr++] = 116;
            } else if (c2 == 39) {
                buf[ptr++] = 97;
                buf[ptr++] = 112;
                buf[ptr++] = 111;
                buf[ptr++] = 115;
            } else if (c2 == 34) {
                buf[ptr++] = 113;
                buf[ptr++] = 117;
                buf[ptr++] = 111;
                buf[ptr++] = 116;
            } else {
                buf[ptr++] = 35;
                buf[ptr++] = 120;
                if (c2 >= 16) {
                    int digit2 = c2 >> 4;
                    buf[ptr++] = (char)(digit2 < 10 ? 48 + digit2 : 87 + digit2);
                    c2 &= 0xF;
                }
                buf[ptr++] = (char)(c2 < 10 ? 48 + c2 : 87 + c2);
            }
        } else {
            buf[ptr++] = 35;
            buf[ptr++] = 120;
            int shift2 = 20;
            int origPtr = ptr;
            do {
                int digit3;
                if ((digit3 = c2 >> shift2 & 0xF) <= 0 && ptr == origPtr) continue;
                buf[ptr++] = (char)(digit3 < 10 ? 48 + digit3 : 87 + digit3);
            } while ((shift2 -= 4) > 0);
            buf[ptr++] = (char)((c2 &= 0xF) < 10 ? 48 + c2 : 87 + c2);
        }
        buf[ptr++] = 59;
        this.mOutputPtr = ptr;
    }
}

