/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.util.BijectiveNsMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.EmptyIterator;

public abstract class OutputElementBase
implements NamespaceContext {
    public static final int PREFIX_UNBOUND = 0;
    public static final int PREFIX_OK = 1;
    public static final int PREFIX_MISBOUND = 2;
    static final String sXmlNsPrefix = "xml";
    static final String sXmlNsURI = "http://www.w3.org/XML/1998/namespace";
    protected NamespaceContext mRootNsContext;
    protected String mDefaultNsURI;
    protected BijectiveNsMap mNsMapping;
    protected boolean mNsMapShared;

    protected OutputElementBase() {
        this.mNsMapping = null;
        this.mNsMapShared = false;
        this.mDefaultNsURI = "";
        this.mRootNsContext = null;
    }

    protected OutputElementBase(OutputElementBase parent2, BijectiveNsMap ns) {
        this.mNsMapping = ns;
        this.mNsMapShared = ns != null;
        this.mDefaultNsURI = parent2.mDefaultNsURI;
        this.mRootNsContext = parent2.mRootNsContext;
    }

    protected void relink(OutputElementBase parent2) {
        this.mNsMapping = parent2.mNsMapping;
        this.mNsMapShared = this.mNsMapping != null;
        this.mDefaultNsURI = parent2.mDefaultNsURI;
        this.mRootNsContext = parent2.mRootNsContext;
    }

    protected abstract void setRootNsContext(NamespaceContext var1);

    public abstract boolean isRoot();

    public abstract String getNameDesc();

    public final String getDefaultNsUri() {
        return this.mDefaultNsURI;
    }

    public final String getExplicitPrefix(String uri) {
        String prefix2;
        if (this.mNsMapping != null && (prefix2 = this.mNsMapping.findPrefixByUri(uri)) != null) {
            return prefix2;
        }
        if (this.mRootNsContext != null && (prefix2 = this.mRootNsContext.getPrefix(uri)) != null && prefix2.length() > 0) {
            return prefix2;
        }
        return null;
    }

    public final int isPrefixValid(String prefix2, String nsURI, boolean isElement) throws XMLStreamException {
        if (nsURI == null) {
            nsURI = "";
        }
        if (prefix2 == null || prefix2.length() == 0) {
            if (isElement ? nsURI == this.mDefaultNsURI || nsURI.equals(this.mDefaultNsURI) : nsURI.length() == 0) {
                return 1;
            }
            return 2;
        }
        if (prefix2.equals(sXmlNsPrefix)) {
            if (!nsURI.equals(sXmlNsURI)) {
                this.throwOutputError("Namespace prefix 'xml' can not be bound to non-default namespace ('" + nsURI + "'); has to be the default '" + sXmlNsURI + "'");
            }
            return 1;
        }
        String act = this.mNsMapping != null ? this.mNsMapping.findUriByPrefix(prefix2) : null;
        if (act == null && this.mRootNsContext != null) {
            act = this.mRootNsContext.getNamespaceURI(prefix2);
        }
        if (act == null) {
            return 0;
        }
        return act == nsURI || act.equals(nsURI) ? 1 : 2;
    }

    public abstract void setDefaultNsUri(String var1);

    public final String generateMapping(String prefixBase, String uri, int[] seqArr) {
        if (this.mNsMapping == null) {
            this.mNsMapping = BijectiveNsMap.createEmpty();
        } else if (this.mNsMapShared) {
            this.mNsMapping = this.mNsMapping.createChild();
            this.mNsMapShared = false;
        }
        return this.mNsMapping.addGeneratedMapping(prefixBase, this.mRootNsContext, uri, seqArr);
    }

    public final void addPrefix(String prefix2, String uri) {
        if (this.mNsMapping == null) {
            this.mNsMapping = BijectiveNsMap.createEmpty();
        } else if (this.mNsMapShared) {
            this.mNsMapping = this.mNsMapping.createChild();
            this.mNsMapShared = false;
        }
        this.mNsMapping.addMapping(prefix2, uri);
    }

    public final String getNamespaceURI(String prefix2) {
        String uri;
        if (prefix2.length() == 0) {
            return this.mDefaultNsURI;
        }
        if (this.mNsMapping != null && (uri = this.mNsMapping.findUriByPrefix(prefix2)) != null) {
            return uri;
        }
        return this.mRootNsContext != null ? this.mRootNsContext.getNamespaceURI(prefix2) : null;
    }

    public final String getPrefix(String uri) {
        String prefix2;
        if (this.mDefaultNsURI.equals(uri)) {
            return "";
        }
        if (this.mNsMapping != null && (prefix2 = this.mNsMapping.findPrefixByUri(uri)) != null) {
            return prefix2;
        }
        return this.mRootNsContext != null ? this.mRootNsContext.getPrefix(uri) : null;
    }

    public final Iterator getPrefixes(String uri) {
        List<String> l = null;
        if (this.mDefaultNsURI.equals(uri)) {
            l = new ArrayList<String>();
            l.add("");
        }
        if (this.mNsMapping != null) {
            l = this.mNsMapping.getPrefixesBoundToUri(uri, l);
        }
        if (this.mRootNsContext != null) {
            Iterator<String> it = this.mRootNsContext.getPrefixes(uri);
            while (it.hasNext()) {
                String prefix2 = it.next();
                if (prefix2.length() == 0) continue;
                if (l == null) {
                    l = new ArrayList();
                } else if (l.contains(prefix2)) continue;
                l.add(prefix2);
            }
        }
        return l == null ? EmptyIterator.getInstance() : l.iterator();
    }

    protected final void throwOutputError(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg);
    }
}

