/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import com.ctc.wstx.util.ElementId;
import com.ctc.wstx.util.ExceptionUtil;
import com.ctc.wstx.util.PrefixedName;
import javax.xml.stream.Location;

public final class ElementIdMap {
    protected static final int DEFAULT_SIZE = 128;
    protected static final int MIN_SIZE = 16;
    protected static final int FILL_PCT = 80;
    protected ElementId[] mTable;
    protected int mSize;
    protected int mSizeThreshold;
    protected int mIndexMask;
    protected ElementId mHead;
    protected ElementId mTail;

    public ElementIdMap() {
        this(128);
    }

    public ElementIdMap(int initialSize) {
        int actual;
        for (actual = 16; actual < initialSize; actual += actual) {
        }
        this.mTable = new ElementId[actual];
        this.mIndexMask = actual - 1;
        this.mSize = 0;
        this.mSizeThreshold = actual * 80 / 100;
        this.mTail = null;
        this.mHead = null;
    }

    public ElementId getFirstUndefined() {
        return this.mHead;
    }

    public ElementId addReferenced(char[] buffer, int start2, int len2, int hash2, Location loc, PrefixedName elemName, PrefixedName attrName) {
        ElementId id2;
        int index2 = hash2 & this.mIndexMask;
        for (id2 = this.mTable[index2]; id2 != null; id2 = id2.nextColliding()) {
            if (!id2.idMatches(buffer, start2, len2)) continue;
            return id2;
        }
        if (this.mSize >= this.mSizeThreshold) {
            this.rehash();
            index2 = hash2 & this.mIndexMask;
        }
        ++this.mSize;
        String idStr = new String(buffer, start2, len2);
        id2 = new ElementId(idStr, loc, false, elemName, attrName);
        id2.setNextColliding(this.mTable[index2]);
        this.mTable[index2] = id2;
        if (this.mHead == null) {
            this.mHead = this.mTail = id2;
        } else {
            this.mTail.linkUndefined(id2);
            this.mTail = id2;
        }
        return id2;
    }

    public ElementId addReferenced(String idStr, Location loc, PrefixedName elemName, PrefixedName attrName) {
        ElementId id2;
        int hash2 = ElementIdMap.calcHash(idStr);
        int index2 = hash2 & this.mIndexMask;
        for (id2 = this.mTable[index2]; id2 != null; id2 = id2.nextColliding()) {
            if (!id2.idMatches(idStr)) continue;
            return id2;
        }
        if (this.mSize >= this.mSizeThreshold) {
            this.rehash();
            index2 = hash2 & this.mIndexMask;
        }
        ++this.mSize;
        id2 = new ElementId(idStr, loc, false, elemName, attrName);
        id2.setNextColliding(this.mTable[index2]);
        this.mTable[index2] = id2;
        if (this.mHead == null) {
            this.mHead = this.mTail = id2;
        } else {
            this.mTail.linkUndefined(id2);
            this.mTail = id2;
        }
        return id2;
    }

    public ElementId addDefined(char[] buffer, int start2, int len2, int hash2, Location loc, PrefixedName elemName, PrefixedName attrName) {
        ElementId id2;
        int index2 = hash2 & this.mIndexMask;
        for (id2 = this.mTable[index2]; id2 != null && !id2.idMatches(buffer, start2, len2); id2 = id2.nextColliding()) {
        }
        if (id2 == null) {
            if (this.mSize >= this.mSizeThreshold) {
                this.rehash();
                index2 = hash2 & this.mIndexMask;
            }
            ++this.mSize;
            String idStr = new String(buffer, start2, len2);
            id2 = new ElementId(idStr, loc, true, elemName, attrName);
            id2.setNextColliding(this.mTable[index2]);
            this.mTable[index2] = id2;
        } else if (!id2.isDefined()) {
            id2.markDefined(loc);
            if (id2 == this.mHead) {
                do {
                    this.mHead = this.mHead.nextUndefined();
                } while (this.mHead != null && this.mHead.isDefined());
                if (this.mHead == null) {
                    this.mTail = null;
                }
            }
        }
        return id2;
    }

    public ElementId addDefined(String idStr, Location loc, PrefixedName elemName, PrefixedName attrName) {
        ElementId id2;
        int hash2 = ElementIdMap.calcHash(idStr);
        int index2 = hash2 & this.mIndexMask;
        for (id2 = this.mTable[index2]; id2 != null && !id2.idMatches(idStr); id2 = id2.nextColliding()) {
        }
        if (id2 == null) {
            if (this.mSize >= this.mSizeThreshold) {
                this.rehash();
                index2 = hash2 & this.mIndexMask;
            }
            ++this.mSize;
            id2 = new ElementId(idStr, loc, true, elemName, attrName);
            id2.setNextColliding(this.mTable[index2]);
            this.mTable[index2] = id2;
        } else if (!id2.isDefined()) {
            id2.markDefined(loc);
            if (id2 == this.mHead) {
                do {
                    this.mHead = this.mHead.nextUndefined();
                } while (this.mHead != null && this.mHead.isDefined());
                if (this.mHead == null) {
                    this.mTail = null;
                }
            }
        }
        return id2;
    }

    public static int calcHash(char[] buffer, int start2, int len2) {
        int hash2 = buffer[0];
        for (int i = 1; i < len2; ++i) {
            hash2 = hash2 * 31 + buffer[i];
        }
        return hash2;
    }

    public static int calcHash(String key) {
        int hash2 = key.charAt(0);
        int len2 = key.length();
        for (int i = 1; i < len2; ++i) {
            hash2 = hash2 * 31 + key.charAt(i);
        }
        return hash2;
    }

    private void rehash() {
        int size2 = this.mTable.length;
        int newSize = size2 << 2;
        ElementId[] oldSyms = this.mTable;
        this.mTable = new ElementId[newSize];
        this.mIndexMask = newSize - 1;
        this.mSizeThreshold <<= 2;
        int count2 = 0;
        for (int i = 0; i < size2; ++i) {
            ElementId id2 = oldSyms[i];
            while (id2 != null) {
                ++count2;
                int index2 = ElementIdMap.calcHash(id2.getId()) & this.mIndexMask;
                ElementId nextIn = id2.nextColliding();
                id2.setNextColliding(this.mTable[index2]);
                this.mTable[index2] = id2;
                id2 = nextIn;
            }
        }
        if (count2 != this.mSize) {
            ExceptionUtil.throwInternal("on rehash(): had " + this.mSize + " entries; now have " + count2 + ".");
        }
    }
}

