/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import java.util.Collection;
import java.util.Iterator;

public final class StringUtil {
    static final char CHAR_SPACE = ' ';
    private static final char INT_SPACE = ' ';
    static String sLF = null;
    private static final int EOS = 65536;

    public static String getLF() {
        String lf = sLF;
        if (lf == null) {
            try {
                lf = System.getProperty("line.separator");
                sLF = lf == null ? "\n" : lf;
            }
            catch (Throwable t2) {
                lf = "\n";
                sLF = "\n";
            }
        }
        return lf;
    }

    public static void appendLF(StringBuffer sb) {
        sb.append(StringUtil.getLF());
    }

    public static String concatEntries(Collection coll, String sep, String lastSep) {
        if (lastSep == null) {
            lastSep = sep;
        }
        int len2 = coll.size();
        StringBuffer sb = new StringBuffer(16 + (len2 << 3));
        Iterator it = coll.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i != 0) {
                if (i == len2 - 1) {
                    sb.append(lastSep);
                } else {
                    sb.append(sep);
                }
            }
            ++i;
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static String normalizeSpaces(char[] buf, int origStart, int origEnd) {
        int start2;
        int end2 = --origEnd;
        for (start2 = origStart; start2 <= end2 && buf[start2] == ' '; ++start2) {
        }
        if (start2 > end2) {
            return "";
        }
        while (end2 > start2 && buf[end2] == ' ') {
            --end2;
        }
        int i = start2 + 1;
        while (i < end2) {
            if (buf[i] == ' ') {
                if (buf[i + 1] == ' ') break;
                i += 2;
                continue;
            }
            ++i;
        }
        if (i >= end2) {
            if (start2 == origStart && end2 == origEnd) {
                return null;
            }
            return new String(buf, start2, end2 - start2 + 1);
        }
        StringBuffer sb = new StringBuffer(end2 - start2);
        sb.append(buf, start2, i - start2);
        while (i <= end2) {
            char c2;
            if ((c2 = buf[i++]) == ' ') {
                sb.append(' ');
                while ((c2 = buf[i++]) == ' ') {
                }
                sb.append(c2);
                continue;
            }
            sb.append(c2);
        }
        return sb.toString();
    }

    public static boolean isAllWhitespace(String str) {
        int len2 = str.length();
        for (int i = 0; i < len2; ++i) {
            if (str.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAllWhitespace(char[] ch, int start2, int len2) {
        len2 += start2;
        while (start2 < len2) {
            if (ch[start2] > ' ') {
                return false;
            }
            ++start2;
        }
        return true;
    }

    public static boolean equalEncodings(String str1, String str2) {
        int len1 = str1.length();
        int len2 = str2.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < len1 || i2 < len2) {
            int c2;
            int c1 = i1 >= len1 ? 65536 : (int)str1.charAt(i1++);
            if (c1 == (c2 = i2 >= len2 ? 65536 : (int)str2.charAt(i2++))) continue;
            while (c1 <= 32 || c1 == 95 || c1 == 45) {
                c1 = i1 >= len1 ? 65536 : (int)str1.charAt(i1++);
            }
            while (c2 <= 32 || c2 == 95 || c2 == 45) {
                c2 = i2 >= len2 ? 65536 : (int)str2.charAt(i2++);
            }
            if (c1 == c2) continue;
            if (c1 == 65536 || c2 == 65536) {
                return false;
            }
            if (c1 < 127) {
                if (c1 <= 90 && c1 >= 65) {
                    c1 += 32;
                }
            } else {
                c1 = Character.toLowerCase((char)c1);
            }
            if (c2 < 127) {
                if (c2 <= 90 && c2 >= 65) {
                    c2 += 32;
                }
            } else {
                c2 = Character.toLowerCase((char)c2);
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static boolean encodingStartsWith(String enc, String prefix2) {
        int len1 = enc.length();
        int len2 = prefix2.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < len1 || i2 < len2) {
            int c2;
            int c1 = i1 >= len1 ? 65536 : (int)enc.charAt(i1++);
            if (c1 == (c2 = i2 >= len2 ? 65536 : (int)prefix2.charAt(i2++))) continue;
            while (c1 <= 32 || c1 == 95 || c1 == 45) {
                c1 = i1 >= len1 ? 65536 : (int)enc.charAt(i1++);
            }
            while (c2 <= 32 || c2 == 95 || c2 == 45) {
                c2 = i2 >= len2 ? 65536 : (int)prefix2.charAt(i2++);
            }
            if (c1 == c2) continue;
            if (c2 == 65536) {
                return true;
            }
            if (c1 == 65536) {
                return false;
            }
            if (Character.toLowerCase((char)c1) == Character.toLowerCase((char)c2)) continue;
            return false;
        }
        return true;
    }

    public static String trimEncoding(String str, boolean upperCase) {
        char c2;
        int i;
        int len2 = str.length();
        for (i = 0; i < len2 && (c2 = str.charAt(i)) > ' ' && Character.isLetterOrDigit(c2); ++i) {
        }
        if (i == len2) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (i > 0) {
            sb.append(str.substring(0, i));
        }
        while (i < len2) {
            char c3 = str.charAt(i);
            if (c3 > ' ' && Character.isLetterOrDigit(c3)) {
                if (upperCase) {
                    c3 = Character.toUpperCase(c3);
                }
                sb.append(c3);
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean matches(String str, char[] cbuf, int offset2, int len2) {
        if (str.length() != len2) {
            return false;
        }
        for (int i = 0; i < len2; ++i) {
            if (str.charAt(i) == cbuf[offset2 + i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSpace(char c2) {
        return c2 <= ' ';
    }
}

