/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import com.ctc.wstx.util.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public final class URLUtil {
    private URLUtil() {
    }

    public static URL urlFromSystemId(String sysId) throws IOException {
        try {
            int ix = sysId.indexOf(58, 0);
            if (ix >= 3 && ix <= 8) {
                return new URL(sysId);
            }
            String absPath = new File(sysId).getAbsolutePath();
            char sep = File.separatorChar;
            if (sep != '/') {
                absPath = absPath.replace(sep, '/');
            }
            if (absPath.length() > 0 && absPath.charAt(0) != '/') {
                absPath = "/" + absPath;
            }
            return new URL("file", "", absPath);
        }
        catch (MalformedURLException e2) {
            URLUtil.throwIOException(e2, sysId);
            return null;
        }
    }

    public static URI uriFromSystemId(String sysId) throws IOException {
        try {
            int ix = sysId.indexOf(58, 0);
            if (ix >= 3 && ix <= 8) {
                return new URI(sysId);
            }
            String absPath = new File(sysId).getAbsolutePath();
            char sep = File.separatorChar;
            if (sep != '/') {
                absPath = absPath.replace(sep, '/');
            }
            if (absPath.length() > 0 && absPath.charAt(0) != '/') {
                absPath = "/" + absPath;
            }
            return new URI("file", absPath, null);
        }
        catch (URISyntaxException e2) {
            URLUtil.throwIOException(e2, sysId);
            return null;
        }
    }

    public static URL urlFromSystemId(String sysId, URL ctxt) throws IOException {
        if (ctxt == null) {
            return URLUtil.urlFromSystemId(sysId);
        }
        try {
            return new URL(ctxt, sysId);
        }
        catch (MalformedURLException e2) {
            URLUtil.throwIOException(e2, sysId);
            return null;
        }
    }

    public static URL urlFromCurrentDir() throws MalformedURLException {
        return new File("a").getAbsoluteFile().getParentFile().toURL();
    }

    public static InputStream inputStreamFromURL(URL url) throws IOException {
        String host;
        if ("file".equals(url.getProtocol()) && ((host = url.getHost()) == null || host.length() == 0)) {
            String path2 = url.getPath();
            if (path2.indexOf(37) >= 0) {
                path2 = URLDecoder.decode(path2, "UTF-8");
            }
            return new FileInputStream(path2);
        }
        return url.openStream();
    }

    public static OutputStream outputStreamFromURL(URL url) throws IOException {
        String host;
        if ("file".equals(url.getProtocol()) && ((host = url.getHost()) == null || host.length() == 0)) {
            return new FileOutputStream(url.getPath());
        }
        return url.openConnection().getOutputStream();
    }

    private static void throwIOException(Exception mex, String sysId) throws IOException {
        IOException ie = new IOException("[resolving systemId '" + sysId + "']: " + mex.toString());
        ExceptionUtil.setInitCause(ie, mex);
        throw ie;
    }
}

