/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAPFaultSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class clazz2, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPFault sOAPFault = (SOAPFault)extensibilityElement;
        if (sOAPFault != null) {
            String string2 = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/soap/", "fault", definition);
            printWriter.print("        <" + string2);
            DOMUtils.printAttribute("name", sOAPFault.getName(), printWriter);
            DOMUtils.printAttribute("use", sOAPFault.getUse(), printWriter);
            DOMUtils.printAttribute("encodingStyle", StringUtils.getNMTokens(sOAPFault.getEncodingStyles()), printWriter);
            DOMUtils.printAttribute("namespace", sOAPFault.getNamespaceURI(), printWriter);
            Boolean bl = sOAPFault.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            printWriter.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class clazz2, QName qName, Element element2, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPFault sOAPFault = (SOAPFault)extensionRegistry.createExtension(clazz2, qName);
        QName qName2 = DOMUtils.getQualifiedAttributeValue(element2, "message", "header", false, definition);
        String string2 = DOMUtils.getAttribute(element2, "name");
        String string3 = DOMUtils.getAttribute(element2, "use");
        String string4 = DOMUtils.getAttribute(element2, "encodingStyle");
        String string5 = DOMUtils.getAttribute(element2, "namespace");
        String string6 = DOMUtils.getAttributeNS(element2, "http://schemas.xmlsoap.org/wsdl/", "required");
        if (string2 != null) {
            sOAPFault.setName(string2);
        }
        if (string3 != null) {
            sOAPFault.setUse(string3);
        }
        if (string4 != null) {
            sOAPFault.setEncodingStyles(StringUtils.parseNMTokens(string4));
        }
        if (string5 != null) {
            sOAPFault.setNamespaceURI(string5);
        }
        if (string6 != null) {
            sOAPFault.setRequired(new Boolean(string6));
        }
        return sOAPFault;
    }
}

