/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap12;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAP12BindingSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class clazz2, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAP12Binding sOAP12Binding = (SOAP12Binding)extensibilityElement;
        if (sOAP12Binding != null) {
            String string2 = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/soap12/", "binding", definition);
            printWriter.print("    <" + string2);
            DOMUtils.printAttribute("style", sOAP12Binding.getStyle(), printWriter);
            DOMUtils.printAttribute("transport", sOAP12Binding.getTransportURI(), printWriter);
            Boolean bl = sOAP12Binding.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            printWriter.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class clazz2, QName qName, Element element2, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAP12Binding sOAP12Binding = (SOAP12Binding)extensionRegistry.createExtension(clazz2, qName);
        String string2 = DOMUtils.getAttribute(element2, "transport");
        String string3 = DOMUtils.getAttribute(element2, "style");
        String string4 = DOMUtils.getAttributeNS(element2, "http://schemas.xmlsoap.org/wsdl/", "required");
        if (string2 != null) {
            sOAP12Binding.setTransportURI(string2);
        }
        if (string3 != null) {
            sOAP12Binding.setStyle(string3);
        }
        if (string4 != null) {
            sOAP12Binding.setRequired(new Boolean(string4));
        }
        return sOAP12Binding;
    }
}

