/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.util.xml;

import com.ibm.wsdl.util.ObjectRegistry;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOM2Writer {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static String NS_URI_XML = "http://www.w3.org/XML/1998/namespace";
    private static Map xmlEncodingMap = new HashMap();

    public static String nodeToString(Node node4) {
        return DOM2Writer.nodeToString(node4, new HashMap());
    }

    public static String nodeToString(Node node4, Map map3) {
        StringWriter stringWriter = new StringWriter();
        DOM2Writer.serializeAsXML(node4, map3, stringWriter);
        return stringWriter.toString();
    }

    public static void serializeElementAsDocument(Element element2, Writer writer) {
        DOM2Writer.serializeElementAsDocument(element2, new HashMap(), writer);
    }

    public static void serializeElementAsDocument(Element element2, Map map3, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer);
        String string2 = writer instanceof OutputStreamWriter ? ((OutputStreamWriter)writer).getEncoding() : null;
        String string3 = DOM2Writer.java2XMLEncoding(string2);
        if (string3 != null) {
            printWriter.println("<?xml version=\"1.0\" encoding=\"" + string3 + "\"?>");
        } else {
            printWriter.println("<?xml version=\"1.0\"?>");
        }
        DOM2Writer.serializeAsXML(element2, map3, writer);
    }

    public static void serializeAsXML(Node node4, Writer writer) {
        DOM2Writer.serializeAsXML(node4, new HashMap(), writer);
    }

    public static void serializeAsXML(Node node4, Map map3, Writer writer) {
        ObjectRegistry objectRegistry = new ObjectRegistry(map3);
        objectRegistry.register("xml", NS_URI_XML);
        PrintWriter printWriter = new PrintWriter(writer);
        String string2 = writer instanceof OutputStreamWriter ? ((OutputStreamWriter)writer).getEncoding() : null;
        DOM2Writer.print(node4, objectRegistry, printWriter, DOM2Writer.java2XMLEncoding(string2));
    }

    private static void print(Node node4, ObjectRegistry objectRegistry, PrintWriter printWriter, String string2) {
        if (node4 == null) {
            return;
        }
        boolean bl = false;
        short s2 = node4.getNodeType();
        switch (s2) {
            case 9: {
                if (string2 != null) {
                    printWriter.println("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>");
                } else {
                    printWriter.println("<?xml version=\"1.0\"?>");
                }
                NodeList nodeList = node4.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    DOM2Writer.print(nodeList.item(n2), objectRegistry, printWriter, string2);
                    ++n2;
                }
                break;
            }
            case 1: {
                Object object;
                NamedNodeMap namedNodeMap;
                objectRegistry = new ObjectRegistry(objectRegistry);
                printWriter.print('<' + node4.getNodeName());
                String string3 = node4.getPrefix();
                String string4 = node4.getNamespaceURI();
                if (string3 != null && string4 != null) {
                    boolean bl2 = false;
                    try {
                        String string5 = (String)objectRegistry.lookup(string3);
                        if (string4.equals(string5)) {
                            bl2 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (!bl2) {
                        DOM2Writer.printNamespaceDecl(node4, objectRegistry, printWriter);
                    }
                }
                int n = (namedNodeMap = node4.getAttributes()) != null ? namedNodeMap.getLength() : 0;
                int n3 = 0;
                while (n3 < n) {
                    object = (Attr)namedNodeMap.item(n3);
                    printWriter.print(' ' + object.getNodeName() + "=\"" + DOM2Writer.normalize(object.getValue()) + '\"');
                    String string6 = object.getPrefix();
                    String string7 = object.getNamespaceURI();
                    if (string6 != null && string7 != null) {
                        boolean bl3 = false;
                        try {
                            String string8 = (String)objectRegistry.lookup(string6);
                            if (string7.equals(string8)) {
                                bl3 = true;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        if (!bl3) {
                            DOM2Writer.printNamespaceDecl((Node)object, objectRegistry, printWriter);
                        }
                    }
                    ++n3;
                }
                object = node4.getChildNodes();
                if (object != null) {
                    int n4 = object.getLength();
                    boolean bl4 = bl = n4 > 0;
                    if (bl) {
                        printWriter.print('>');
                    }
                    int n5 = 0;
                    while (n5 < n4) {
                        DOM2Writer.print(object.item(n5), objectRegistry, printWriter, string2);
                        ++n5;
                    }
                } else {
                    bl = false;
                }
                if (bl) break;
                printWriter.print("/>");
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node4.getNodeName());
                printWriter.print(';');
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node4.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 3: {
                printWriter.print(DOM2Writer.normalize(node4.getNodeValue()));
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node4.getNodeValue());
                printWriter.print("-->");
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node4.getNodeName());
                String string9 = node4.getNodeValue();
                if (string9 != null && string9.length() > 0) {
                    printWriter.print(' ');
                    printWriter.print(string9);
                }
                printWriter.println("?>");
            }
        }
        if (s2 == 1 && bl) {
            printWriter.print("</");
            printWriter.print(node4.getNodeName());
            printWriter.print('>');
            bl = false;
        }
    }

    public static String java2XMLEncoding(String string2) {
        return (String)xmlEncodingMap.get(string2);
    }

    private static void printNamespaceDecl(Node node4, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        switch (node4.getNodeType()) {
            case 2: {
                DOM2Writer.printNamespaceDecl(((Attr)node4).getOwnerElement(), node4, objectRegistry, printWriter);
                break;
            }
            case 1: {
                DOM2Writer.printNamespaceDecl((Element)node4, node4, objectRegistry, printWriter);
            }
        }
    }

    private static void printNamespaceDecl(Element element2, Node node4, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        String string2 = node4.getNamespaceURI();
        String string3 = node4.getPrefix();
        if (!string2.equals(NS_URI_XMLNS) || !string3.equals("xmlns")) {
            if (DOMUtils.getAttributeNS(element2, NS_URI_XMLNS, string3) == null) {
                printWriter.print(" xmlns:" + string3 + "=\"" + string2 + '\"');
            }
        } else {
            string3 = node4.getLocalName();
            string2 = node4.getNodeValue();
        }
        objectRegistry.register(string3, string2);
    }

    private static String normalize(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2 != null ? string2.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c2 = string2.charAt(n2);
            switch (c2) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': {
                    if (n2 > 0) {
                        char c3 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c3 != '\r') {
                            stringBuffer.append(StringUtils.lineSeparator);
                            break;
                        }
                        stringBuffer.append('\n');
                        break;
                    }
                    stringBuffer.append(StringUtils.lineSeparator);
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static {
        xmlEncodingMap.put(null, "UTF-8");
        xmlEncodingMap.put(System.getProperty("file.encoding"), "UTF-8");
        xmlEncodingMap.put("UTF8", "UTF-8");
        xmlEncodingMap.put("UTF-16", "UTF-16");
        xmlEncodingMap.put("UnicodeBig", "UTF-16");
        xmlEncodingMap.put("UnicodeLittle", "UTF-16");
        xmlEncodingMap.put("ASCII", "US-ASCII");
        xmlEncodingMap.put("ISO8859_1", "ISO-8859-1");
        xmlEncodingMap.put("ISO8859_2", "ISO-8859-2");
        xmlEncodingMap.put("ISO8859_3", "ISO-8859-3");
        xmlEncodingMap.put("ISO8859_4", "ISO-8859-4");
        xmlEncodingMap.put("ISO8859_5", "ISO-8859-5");
        xmlEncodingMap.put("ISO8859_6", "ISO-8859-6");
        xmlEncodingMap.put("ISO8859_7", "ISO-8859-7");
        xmlEncodingMap.put("ISO8859_8", "ISO-8859-8");
        xmlEncodingMap.put("ISO8859_9", "ISO-8859-9");
        xmlEncodingMap.put("ISO8859_13", "ISO-8859-13");
        xmlEncodingMap.put("ISO8859_15_FDIS", "ISO-8859-15");
        xmlEncodingMap.put("GBK", "GBK");
        xmlEncodingMap.put("Big5", "Big5");
    }
}

