/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ExportControlled {
    private static final String SQL_STATE_BAD_SSL_PARAMS = "08000";

    protected static boolean enabled() {
        return true;
    }

    protected static void transformSocketToSSLSocket(MysqlIO mysqlIO) throws SQLException {
        SSLSocketFactory sslFact = ExportControlled.getSSLSocketFactoryDefaultOrConfigured(mysqlIO);
        try {
            mysqlIO.mysqlConnection = sslFact.createSocket(mysqlIO.mysqlConnection, mysqlIO.host, mysqlIO.port, true);
            ((SSLSocket)mysqlIO.mysqlConnection).setEnabledProtocols(new String[]{"TLSv1"});
            ((SSLSocket)mysqlIO.mysqlConnection).startHandshake();
            mysqlIO.mysqlInput = mysqlIO.connection.getUseUnbufferedInput() ? mysqlIO.mysqlConnection.getInputStream() : new BufferedInputStream(mysqlIO.mysqlConnection.getInputStream(), 16384);
            mysqlIO.mysqlOutput = new BufferedOutputStream(mysqlIO.mysqlConnection.getOutputStream(), 16384);
            mysqlIO.mysqlOutput.flush();
        }
        catch (IOException ioEx) {
            throw SQLError.createCommunicationsException(mysqlIO.connection, mysqlIO.getLastPacketSentTimeMs(), mysqlIO.getLastPacketReceivedTimeMs(), ioEx);
        }
    }

    private ExportControlled() {
    }

    private static SSLSocketFactory getSSLSocketFactoryDefaultOrConfigured(MysqlIO mysqlIO) throws SQLException {
        char[] password;
        URL ksURL;
        String clientCertificateKeyStoreUrl = mysqlIO.connection.getClientCertificateKeyStoreUrl();
        String trustCertificateKeyStoreUrl = mysqlIO.connection.getTrustCertificateKeyStoreUrl();
        String clientCertificateKeyStoreType = mysqlIO.connection.getClientCertificateKeyStoreType();
        String clientCertificateKeyStorePassword = mysqlIO.connection.getClientCertificateKeyStorePassword();
        String trustCertificateKeyStoreType = mysqlIO.connection.getTrustCertificateKeyStoreType();
        String trustCertificateKeyStorePassword = mysqlIO.connection.getTrustCertificateKeyStorePassword();
        if (StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl) && StringUtils.isNullOrEmpty(trustCertificateKeyStoreUrl) && mysqlIO.connection.getVerifyServerCertificate()) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        TrustManagerFactory tmf = null;
        KeyManagerFactory kmf = null;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw SQLError.createSQLException("Default algorithm definitions for TrustManager and/or KeyManager are invalid.  Check java security properties file.", SQL_STATE_BAD_SSL_PARAMS, 0, false);
        }
        if (StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl)) {
            try {
                if (!StringUtils.isNullOrEmpty(clientCertificateKeyStoreType)) {
                    KeyStore clientKeyStore = KeyStore.getInstance(clientCertificateKeyStoreType);
                    ksURL = new URL(clientCertificateKeyStoreUrl);
                    password = clientCertificateKeyStorePassword == null ? new char[]{} : clientCertificateKeyStorePassword.toCharArray();
                    clientKeyStore.load(ksURL.openStream(), password);
                    kmf.init(clientKeyStore, password);
                }
            }
            catch (UnrecoverableKeyException uke) {
                throw SQLError.createSQLException("Could not recover keys from client keystore.  Check password?", SQL_STATE_BAD_SSL_PARAMS, 0, false);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw SQLError.createSQLException("Unsupported keystore algorithm [" + nsae.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false);
            }
            catch (KeyStoreException kse) {
                throw SQLError.createSQLException("Could not create KeyStore instance [" + kse.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false);
            }
            catch (CertificateException nsae) {
                throw SQLError.createSQLException("Could not load client" + clientCertificateKeyStoreType + " keystore from " + clientCertificateKeyStoreUrl);
            }
            catch (MalformedURLException mue) {
                throw SQLError.createSQLException(clientCertificateKeyStoreUrl + " does not appear to be a valid URL.", SQL_STATE_BAD_SSL_PARAMS, 0, false);
            }
            catch (IOException ioe) {
                SQLException sqlEx = SQLError.createSQLException("Cannot open " + clientCertificateKeyStoreUrl + " [" + ioe.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false);
                sqlEx.initCause(ioe);
                throw sqlEx;
            }
        }
        if (StringUtils.isNullOrEmpty(trustCertificateKeyStoreUrl)) {
            try {
                if (!StringUtils.isNullOrEmpty(trustCertificateKeyStoreType)) {
                    KeyStore trustKeyStore = KeyStore.getInstance(trustCertificateKeyStoreType);
                    ksURL = new URL(trustCertificateKeyStoreUrl);
                    password = trustCertificateKeyStorePassword == null ? new char[]{} : trustCertificateKeyStorePassword.toCharArray();
                    trustKeyStore.load(ksURL.openStream(), password);
                    tmf.init(trustKeyStore);
                }
            }
            catch (NoSuchAlgorithmException nsae) {
                throw SQLError.createSQLException("Unsupported keystore algorithm [" + nsae.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false);
            }
            catch (KeyStoreException kse) {
                throw SQLError.createSQLException("Could not create KeyStore instance [" + kse.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false);
            }
            catch (CertificateException nsae) {
                throw SQLError.createSQLException("Could not load trust" + trustCertificateKeyStoreType + " keystore from " + trustCertificateKeyStoreUrl, SQL_STATE_BAD_SSL_PARAMS, 0, false);
            }
            catch (MalformedURLException mue) {
                throw SQLError.createSQLException(trustCertificateKeyStoreUrl + " does not appear to be a valid URL.", SQL_STATE_BAD_SSL_PARAMS, 0, false);
            }
            catch (IOException ioe) {
                SQLException sqlEx = SQLError.createSQLException("Cannot open " + trustCertificateKeyStoreUrl + " [" + ioe.getMessage() + "]", SQL_STATE_BAD_SSL_PARAMS, 0, false);
                sqlEx.initCause(ioe);
                throw sqlEx;
            }
        }
        SSLContext sslContext = null;
        try {
            TrustManager[] trustManagerArray;
            sslContext = SSLContext.getInstance("TLS");
            KeyManager[] keyManagerArray = StringUtils.isNullOrEmpty(clientCertificateKeyStoreUrl) ? null : kmf.getKeyManagers();
            if (mysqlIO.connection.getVerifyServerCertificate()) {
                trustManagerArray = tmf.getTrustManagers();
            } else {
                X509TrustManager[] x509TrustManagerArray = new X509TrustManager[1];
                trustManagerArray = x509TrustManagerArray;
                x509TrustManagerArray[0] = new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain2, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] chain2, String authType) throws CertificateException {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
            }
            sslContext.init(keyManagerArray, trustManagerArray, null);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw SQLError.createSQLException("TLS is not a valid SSL protocol.", SQL_STATE_BAD_SSL_PARAMS, 0, false);
        }
        catch (KeyManagementException kme) {
            throw SQLError.createSQLException("KeyManagementException: " + kme.getMessage(), SQL_STATE_BAD_SSL_PARAMS, 0, false);
        }
    }
}

