/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Blob;
import com.mysql.jdbc.Clob;
import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.JDBC4ClientInfoProvider;
import com.mysql.jdbc.JDBC4MysqlSQLXML;
import com.mysql.jdbc.JDBC4NClob;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.Util;
import java.sql.Array;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Properties;
import java.util.TimerTask;

public class JDBC4Connection
extends ConnectionImpl {
    private JDBC4ClientInfoProvider infoProvider;

    public JDBC4Connection(String hostToConnectTo, int portToConnectTo, Properties info2, String databaseToConnectTo, String url) throws SQLException {
        super(hostToConnectTo, portToConnectTo, info2, databaseToConnectTo, url);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return new JDBC4MysqlSQLXML();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SQLError.notImplemented();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes2) throws SQLException {
        throw SQLError.notImplemented();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.getClientInfoProviderImpl().getClientInfo(this);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.getClientInfoProviderImpl().getClientInfo(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean isValid(int timeout) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        TimerTask timeoutTask = null;
        if (timeout != 0) {
            timeoutTask = new TimerTask(){

                @Override
                public void run() {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                JDBC4Connection.this.abortInternal();
                            }
                            catch (Throwable t2) {
                                throw new RuntimeException(t2);
                            }
                        }
                    }.start();
                }
            };
            JDBC4Connection.getCancelTimer().schedule(timeoutTask, timeout * 1000);
        }
        try {
            Object object = this.getMutex();
            synchronized (object) {
                try {
                    this.pingInternal(false);
                    if (timeoutTask != null) {
                        timeoutTask.cancel();
                    }
                    if ((timeoutTask = null) == null) return true;
                    timeoutTask.cancel();
                }
                catch (Throwable t2) {
                    try {
                        try {
                            this.abortInternal();
                        }
                        catch (Throwable ignoreThrown) {
                            // empty catch block
                        }
                        boolean bl = false;
                        return bl;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        if (timeoutTask != null) {
                            timeoutTask.cancel();
                        }
                    }
                }
                return true;
            }
        }
        catch (Throwable t3) {
            return false;
        }
    }

    @Override
    public void setClientInfo(Properties properties2) throws SQLClientInfoException {
        try {
            this.getClientInfoProviderImpl().setClientInfo(this, properties2);
        }
        catch (SQLClientInfoException ciEx) {
            throw ciEx;
        }
        catch (SQLException sqlEx) {
            SQLClientInfoException clientInfoEx = new SQLClientInfoException();
            clientInfoEx.initCause(sqlEx);
            throw clientInfoEx;
        }
    }

    @Override
    public void setClientInfo(String name, String value2) throws SQLClientInfoException {
        try {
            this.getClientInfoProviderImpl().setClientInfo(this, name, value2);
        }
        catch (SQLClientInfoException ciEx) {
            throw ciEx;
        }
        catch (SQLException sqlEx) {
            SQLClientInfoException clientInfoEx = new SQLClientInfoException();
            clientInfoEx.initCause(sqlEx);
            throw clientInfoEx;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009");
        }
    }

    @Override
    public java.sql.Blob createBlob() {
        return new Blob();
    }

    @Override
    public java.sql.Clob createClob() {
        return new Clob();
    }

    @Override
    public NClob createNClob() {
        return new JDBC4NClob();
    }

    protected synchronized JDBC4ClientInfoProvider getClientInfoProviderImpl() throws SQLException {
        if (this.infoProvider == null) {
            try {
                try {
                    this.infoProvider = (JDBC4ClientInfoProvider)Util.getInstance(this.getClientInfoProvider(), new Class[0], new Object[0]);
                }
                catch (SQLException sqlEx) {
                    if (sqlEx.getCause() instanceof ClassCastException) {
                        this.infoProvider = (JDBC4ClientInfoProvider)Util.getInstance("com.mysql.jdbc." + this.getClientInfoProvider(), new Class[0], new Object[0]);
                    }
                }
            }
            catch (ClassCastException cce) {
                throw SQLError.createSQLException(Messages.getString("JDBC4Connection.ClientInfoNotImplemented", new Object[]{this.getClientInfoProvider()}), "S1009");
            }
            this.infoProvider.initialize(this, this.props);
        }
        return this.infoProvider;
    }
}

