/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.BalanceStrategy;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.PingTarget;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class LoadBalancingConnectionProxy
implements InvocationHandler,
PingTarget {
    private static Method getLocalTimeMethod;
    private Connection currentConn;
    private List hostList;
    private Map liveConnections;
    private Map connectionsToHostsMap;
    private long[] responseTimes;
    private Map hostsToListIndexMap;
    private boolean inTransaction = false;
    private long transactionStartTime = 0L;
    private Properties localProps;
    private boolean isClosed = false;
    private BalanceStrategy balancer;
    private int retriesAllDown;
    static /* synthetic */ Class class$java$lang$System;

    LoadBalancingConnectionProxy(List hosts, Properties props) throws SQLException {
        this.hostList = hosts;
        int numHosts = this.hostList.size();
        this.liveConnections = new HashMap(numHosts);
        this.connectionsToHostsMap = new HashMap(numHosts);
        this.responseTimes = new long[numHosts];
        this.hostsToListIndexMap = new HashMap(numHosts);
        for (int i = 0; i < numHosts; ++i) {
            this.hostsToListIndexMap.put(this.hostList.get(i), new Integer(i));
        }
        this.localProps = (Properties)props.clone();
        this.localProps.remove("HOST");
        this.localProps.remove("PORT");
        this.localProps.setProperty("useLocalSessionState", "true");
        String strategy = this.localProps.getProperty("loadBalanceStrategy", "random");
        String retriesAllDownAsString = this.localProps.getProperty("retriesAllDown", "120");
        try {
            this.retriesAllDown = Integer.parseInt(retriesAllDownAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForRetriesAllDown", new Object[]{retriesAllDownAsString}), "S1009");
        }
        this.balancer = "random".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, "com.mysql.jdbc.RandomBalanceStrategy", "InvalidLoadBalanceStrategy").get(0) : ("bestResponseTime".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, "com.mysql.jdbc.BestResponseTimeBalanceStrategy", "InvalidLoadBalanceStrategy").get(0) : (BalanceStrategy)Util.loadExtensions(null, props, strategy, "InvalidLoadBalanceStrategy").get(0));
        this.balancer.init(null, props);
        this.pickNewConnection();
    }

    public synchronized Connection createConnectionForHost(String hostPortSpec) throws SQLException {
        Properties connProps = (Properties)this.localProps.clone();
        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(hostPortSpec);
        if (hostPortPair[1] == null) {
            hostPortPair[1] = "3306";
        }
        connProps.setProperty("HOST", hostPortSpec);
        connProps.setProperty("PORT", hostPortPair[1]);
        Connection conn = ConnectionImpl.getInstance(hostPortSpec, Integer.parseInt(hostPortPair[1]), connProps, connProps.getProperty("DBNAME"), "jdbc:mysql://" + hostPortPair[0] + ":" + hostPortPair[1] + "/");
        this.liveConnections.put(hostPortSpec, conn);
        this.connectionsToHostsMap.put(conn, hostPortSpec);
        return conn;
    }

    void dealWithInvocationException(InvocationTargetException e2) throws SQLException, Throwable, InvocationTargetException {
        Throwable t2 = e2.getTargetException();
        if (t2 != null) {
            String sqlState;
            if (t2 instanceof SQLException && (sqlState = ((SQLException)t2).getSQLState()) != null && sqlState.startsWith("08")) {
                this.invalidateCurrentConnection();
            }
            throw t2;
        }
        throw e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void invalidateCurrentConnection() throws SQLException {
        try {
            if (!this.currentConn.isClosed()) {
                this.currentConn.close();
            }
            Object var2_1 = null;
            this.liveConnections.remove(this.connectionsToHostsMap.get(this.currentConn));
        }
        catch (Throwable throwable2) {
            Object var2_2 = null;
            this.liveConnections.remove(this.connectionsToHostsMap.get(this.currentConn));
            this.connectionsToHostsMap.remove(this.currentConn);
            throw throwable2;
        }
        this.connectionsToHostsMap.remove(this.currentConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        String methodName = method.getName();
        if ("close".equals(methodName)) {
            Map map3 = this.liveConnections;
            synchronized (map3) {
                Iterator allConnections = this.liveConnections.values().iterator();
                while (allConnections.hasNext()) {
                    ((Connection)allConnections.next()).close();
                }
                if (!this.isClosed) {
                    this.balancer.destroy();
                }
                this.liveConnections.clear();
                this.connectionsToHostsMap.clear();
                return null;
            }
        }
        if ("isClosed".equals(methodName)) {
            return this.isClosed;
        }
        if (this.isClosed) {
            throw SQLError.createSQLException("No operations allowed after connection closed.", "08003");
        }
        if (!this.inTransaction) {
            this.inTransaction = true;
            this.transactionStartTime = LoadBalancingConnectionProxy.getLocalTimeBestResolution();
        }
        Object result2 = null;
        try {
            try {
                result2 = method.invoke((Object)this.currentConn, args2);
                if (result2 != null) {
                    if (result2 instanceof Statement) {
                        ((Statement)result2).setPingTarget(this);
                    }
                    result2 = this.proxyIfInterfaceIsJdbc(result2, result2.getClass());
                }
            }
            catch (InvocationTargetException e2) {
                this.dealWithInvocationException(e2);
                Object var9_10 = null;
                if (!"commit".equals(methodName)) {
                    if (!"rollback".equals(methodName)) return result2;
                }
                this.inTransaction = false;
                int hostIndex = (Integer)this.hostsToListIndexMap.get(this.connectionsToHostsMap.get(this.currentConn));
                long[] lArray = this.responseTimes;
                synchronized (this.responseTimes) {
                    this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                    // ** MonitorExit[var11_16] (shouldn't be in output)
                    this.pickNewConnection();
                    return result2;
                }
            }
            Object var9_9 = null;
            if (!"commit".equals(methodName)) {
                if (!"rollback".equals(methodName)) return result2;
            }
            this.inTransaction = false;
            int hostIndex = (Integer)this.hostsToListIndexMap.get(this.connectionsToHostsMap.get(this.currentConn));
            long[] lArray = this.responseTimes;
        }
        catch (Throwable throwable2) {
            Object var9_11 = null;
            if (!"commit".equals(methodName)) {
                if (!"rollback".equals(methodName)) throw throwable2;
            }
            this.inTransaction = false;
            int hostIndex = (Integer)this.hostsToListIndexMap.get(this.connectionsToHostsMap.get(this.currentConn));
            long[] lArray = this.responseTimes;
            synchronized (this.responseTimes) {
                this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                // ** MonitorExit[var11_17] (shouldn't be in output)
                this.pickNewConnection();
                throw throwable2;
            }
        }
        synchronized (this.responseTimes) {
            this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
            // ** MonitorExit[var11_15] (shouldn't be in output)
            this.pickNewConnection();
            return result2;
        }
    }

    private synchronized void pickNewConnection() throws SQLException {
        if (this.currentConn == null) {
            this.currentConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
            return;
        }
        Connection newConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
        newConn.setTransactionIsolation(this.currentConn.getTransactionIsolation());
        newConn.setAutoCommit(this.currentConn.getAutoCommit());
        this.currentConn = newConn;
    }

    Object proxyIfInterfaceIsJdbc(Object toProxy, Class clazz2) {
        int i = 0;
        Class<?>[] interfaces2 = clazz2.getInterfaces();
        if (i < interfaces2.length) {
            String packageName = interfaces2[i].getPackage().getName();
            if ("java.sql".equals(packageName) || "javax.sql".equals(packageName)) {
                return Proxy.newProxyInstance(toProxy.getClass().getClassLoader(), interfaces2, (InvocationHandler)new ConnectionErrorFiringInvocationHandler(toProxy));
            }
            return this.proxyIfInterfaceIsJdbc(toProxy, interfaces2[i]);
        }
        return toProxy;
    }

    private static long getLocalTimeBestResolution() {
        if (getLocalTimeMethod != null) {
            try {
                return (Long)getLocalTimeMethod.invoke(null, null);
            }
            catch (IllegalArgumentException e2) {
            }
            catch (IllegalAccessException e3) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return System.currentTimeMillis();
    }

    public synchronized void doPing() throws SQLException {
        Iterator allConns = this.liveConnections.values().iterator();
        while (allConns.hasNext()) {
            ((Connection)allConns.next()).ping();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            getLocalTimeMethod = (class$java$lang$System == null ? (class$java$lang$System = LoadBalancingConnectionProxy.class$("java.lang.System")) : class$java$lang$System).getMethod("nanoTime", new Class[0]);
        }
        catch (SecurityException e2) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected class ConnectionErrorFiringInvocationHandler
    implements InvocationHandler {
        Object invokeOn = null;

        public ConnectionErrorFiringInvocationHandler(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
        }

        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            Object result2 = null;
            try {
                result2 = method.invoke(this.invokeOn, args2);
                if (result2 != null) {
                    result2 = LoadBalancingConnectionProxy.this.proxyIfInterfaceIsJdbc(result2, result2.getClass());
                }
            }
            catch (InvocationTargetException e2) {
                LoadBalancingConnectionProxy.this.dealWithInvocationException(e2);
            }
            return result2;
        }
    }
}

