/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.Constants;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.ResultSetImpl;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public abstract class ResultSetRow {
    protected Field[] metadata;

    public abstract void closeOpenStreams();

    public abstract InputStream getBinaryInputStream(int var1) throws SQLException;

    public abstract byte[] getColumnValue(int var1) throws SQLException;

    protected final Date getDateFast(int columnIndex, byte[] dateAsBytes, int offset2, int length2, ConnectionImpl conn, ResultSetImpl rs, Calendar targetCalendar) throws SQLException {
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            int i;
            if (dateAsBytes == null) {
                return null;
            }
            boolean allZeroDate = true;
            boolean onlyTimePresent = false;
            for (i = 0; i < length2; ++i) {
                if (dateAsBytes[offset2 + i] != 58) continue;
                onlyTimePresent = true;
                break;
            }
            for (i = 0; i < length2; ++i) {
                byte b = dateAsBytes[offset2 + i];
                if (b == 32 || b == 45 || b == 47) {
                    onlyTimePresent = false;
                }
                if (b == 48 || b == 32 || b == 58 || b == 45 || b == 47 || b == 46) continue;
                allZeroDate = false;
                break;
            }
            if (!onlyTimePresent && allZeroDate) {
                if ("convertToNull".equals(conn.getZeroDateTimeBehavior())) {
                    return null;
                }
                if ("exception".equals(conn.getZeroDateTimeBehavior())) {
                    throw SQLError.createSQLException("Value '" + new String(dateAsBytes) + "' can not be represented as java.sql.Date", "S1009");
                }
                return rs.fastDateCreate(targetCalendar, 1, 1, 1);
            }
            if (this.metadata[columnIndex].getMysqlType() == 7) {
                switch (length2) {
                    case 19: 
                    case 21: {
                        year = StringUtils.getInt(dateAsBytes, offset2 + 0, offset2 + 4);
                        month = StringUtils.getInt(dateAsBytes, offset2 + 5, offset2 + 7);
                        day = StringUtils.getInt(dateAsBytes, offset2 + 8, offset2 + 10);
                        return rs.fastDateCreate(targetCalendar, year, month, day);
                    }
                    case 8: 
                    case 14: {
                        year = StringUtils.getInt(dateAsBytes, offset2 + 0, offset2 + 4);
                        month = StringUtils.getInt(dateAsBytes, offset2 + 4, offset2 + 6);
                        day = StringUtils.getInt(dateAsBytes, offset2 + 6, offset2 + 8);
                        return rs.fastDateCreate(targetCalendar, year, month, day);
                    }
                    case 6: 
                    case 10: 
                    case 12: {
                        year = StringUtils.getInt(dateAsBytes, offset2 + 0, offset2 + 2);
                        if (year <= 69) {
                            year += 100;
                        }
                        month = StringUtils.getInt(dateAsBytes, offset2 + 2, offset2 + 4);
                        day = StringUtils.getInt(dateAsBytes, offset2 + 4, offset2 + 6);
                        return rs.fastDateCreate(targetCalendar, year + 1900, month, day);
                    }
                    case 4: {
                        year = StringUtils.getInt(dateAsBytes, offset2 + 0, offset2 + 4);
                        if (year <= 69) {
                            year += 100;
                        }
                        month = StringUtils.getInt(dateAsBytes, offset2 + 2, offset2 + 4);
                        return rs.fastDateCreate(targetCalendar, year + 1900, month, 1);
                    }
                    case 2: {
                        year = StringUtils.getInt(dateAsBytes, offset2 + 0, offset2 + 2);
                        if (year <= 69) {
                            year += 100;
                        }
                        return rs.fastDateCreate(targetCalendar, year + 1900, 1, 1);
                    }
                }
                throw SQLError.createSQLException(Messages.getString("ResultSet.Bad_format_for_Date", new Object[]{new String(dateAsBytes), Constants.integerValueOf(columnIndex + 1)}), "S1009");
            }
            if (this.metadata[columnIndex].getMysqlType() == 13) {
                if (length2 == 2 || length2 == 1) {
                    year = StringUtils.getInt(dateAsBytes, offset2, offset2 + length2);
                    if (year <= 69) {
                        year += 100;
                    }
                    year += 1900;
                } else {
                    year = StringUtils.getInt(dateAsBytes, offset2 + 0, offset2 + 4);
                }
                return rs.fastDateCreate(targetCalendar, year, 1, 1);
            }
            if (this.metadata[columnIndex].getMysqlType() == 11) {
                return rs.fastDateCreate(targetCalendar, 1970, 1, 1);
            }
            if (length2 < 10) {
                if (length2 == 8) {
                    return rs.fastDateCreate(targetCalendar, 1970, 1, 1);
                }
                throw SQLError.createSQLException(Messages.getString("ResultSet.Bad_format_for_Date", new Object[]{new String(dateAsBytes), Constants.integerValueOf(columnIndex + 1)}), "S1009");
            }
            if (length2 != 18) {
                year = StringUtils.getInt(dateAsBytes, offset2 + 0, offset2 + 4);
                month = StringUtils.getInt(dateAsBytes, offset2 + 5, offset2 + 7);
                day = StringUtils.getInt(dateAsBytes, offset2 + 8, offset2 + 10);
            } else {
                StringTokenizer st = new StringTokenizer(new String(dateAsBytes, offset2, length2, "ISO8859_1"), "- ");
                year = Integer.parseInt(st.nextToken());
                month = Integer.parseInt(st.nextToken());
                day = Integer.parseInt(st.nextToken());
            }
            return rs.fastDateCreate(targetCalendar, year, month, day);
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception e2) {
            SQLException sqlEx = SQLError.createSQLException(Messages.getString("ResultSet.Bad_format_for_Date", new Object[]{new String(dateAsBytes), Constants.integerValueOf(columnIndex + 1)}), "S1009");
            sqlEx.initCause(e2);
            throw sqlEx;
        }
    }

    public abstract Date getDateFast(int var1, ConnectionImpl var2, ResultSetImpl var3, Calendar var4) throws SQLException;

    public abstract int getInt(int var1) throws SQLException;

    public abstract long getLong(int var1) throws SQLException;

    protected Date getNativeDate(int columnIndex, byte[] bits2, int offset2, int length2, ConnectionImpl conn, ResultSetImpl rs) throws SQLException {
        int year = 0;
        int month = 0;
        int day = 0;
        if (length2 != 0) {
            year = bits2[offset2 + 0] & 0xFF | (bits2[offset2 + 1] & 0xFF) << 8;
            month = bits2[offset2 + 2];
            day = bits2[offset2 + 3];
        }
        if (year == 0 && month == 0 && day == 0) {
            if ("convertToNull".equals(conn.getZeroDateTimeBehavior())) {
                return null;
            }
            if ("exception".equals(conn.getZeroDateTimeBehavior())) {
                throw SQLError.createSQLException("Value '0000-00-00' can not be represented as java.sql.Date", "S1009");
            }
            year = 1;
            month = 1;
            day = 1;
        }
        if (!rs.useLegacyDatetimeCode) {
            return TimeUtil.fastDateCreate(year, month, day, null);
        }
        return rs.fastDateCreate(rs.getCalendarInstanceForSessionOrNew(), year, month, day);
    }

    public abstract Date getNativeDate(int var1, ConnectionImpl var2, ResultSetImpl var3) throws SQLException;

    protected Object getNativeDateTimeValue(int columnIndex, byte[] bits2, int offset2, int length2, Calendar targetCalendar, int jdbcType, int mysqlType, TimeZone tz, boolean rollForward, ConnectionImpl conn, ResultSetImpl rs) throws SQLException {
        int year = 0;
        int month = 0;
        int day = 0;
        byte hour = 0;
        int minute = 0;
        int seconds = 0;
        int nanos = 0;
        if (bits2 == null) {
            return null;
        }
        Calendar sessionCalendar = conn.getUseJDBCCompliantTimezoneShift() ? conn.getUtcCalendar() : rs.getCalendarInstanceForSessionOrNew();
        boolean populatedFromDateTimeValue = false;
        switch (mysqlType) {
            case 7: 
            case 12: {
                populatedFromDateTimeValue = true;
                if (length2 == 0) break;
                year = bits2[offset2 + 0] & 0xFF | (bits2[offset2 + 1] & 0xFF) << 8;
                month = bits2[offset2 + 2];
                day = bits2[offset2 + 3];
                if (length2 > 4) {
                    hour = bits2[offset2 + 4];
                    minute = bits2[offset2 + 5];
                    seconds = bits2[offset2 + 6];
                }
                if (length2 <= 7) break;
                nanos = (bits2[offset2 + 7] & 0xFF | (bits2[offset2 + 8] & 0xFF) << 8 | (bits2[offset2 + 9] & 0xFF) << 16 | (bits2[offset2 + 10] & 0xFF) << 24) * 1000;
                break;
            }
            case 10: {
                populatedFromDateTimeValue = true;
                if (bits2.length == 0) break;
                year = bits2[offset2 + 0] & 0xFF | (bits2[offset2 + 1] & 0xFF) << 8;
                month = bits2[offset2 + 2];
                day = bits2[offset2 + 3];
                break;
            }
            case 11: {
                populatedFromDateTimeValue = true;
                if (bits2.length != 0) {
                    hour = bits2[offset2 + 5];
                    minute = bits2[offset2 + 6];
                    seconds = bits2[offset2 + 7];
                }
                year = 1970;
                month = 1;
                day = 1;
                break;
            }
            default: {
                populatedFromDateTimeValue = false;
            }
        }
        switch (jdbcType) {
            case 92: {
                if (populatedFromDateTimeValue) {
                    if (!rs.useLegacyDatetimeCode) {
                        return TimeUtil.fastTimeCreate(hour, minute, seconds, targetCalendar);
                    }
                    Time time = TimeUtil.fastTimeCreate(rs.getCalendarInstanceForSessionOrNew(), (int)hour, minute, seconds);
                    Time adjustedTime = TimeUtil.changeTimezone(conn, sessionCalendar, targetCalendar, time, conn.getServerTimezoneTZ(), tz, rollForward);
                    return adjustedTime;
                }
                return rs.getNativeTimeViaParseConversion(columnIndex + 1, targetCalendar, tz, rollForward);
            }
            case 91: {
                if (populatedFromDateTimeValue) {
                    if (year == 0 && month == 0 && day == 0) {
                        if ("convertToNull".equals(conn.getZeroDateTimeBehavior())) {
                            return null;
                        }
                        if ("exception".equals(conn.getZeroDateTimeBehavior())) {
                            throw new SQLException("Value '0000-00-00' can not be represented as java.sql.Date", "S1009");
                        }
                        year = 1;
                        month = 1;
                        day = 1;
                    }
                    if (!rs.useLegacyDatetimeCode) {
                        return TimeUtil.fastDateCreate(year, month, day, targetCalendar);
                    }
                    return rs.fastDateCreate(rs.getCalendarInstanceForSessionOrNew(), year, month, day);
                }
                return rs.getNativeDateViaParseConversion(columnIndex + 1);
            }
            case 93: {
                if (populatedFromDateTimeValue) {
                    if (year == 0 && month == 0 && day == 0) {
                        if ("convertToNull".equals(conn.getZeroDateTimeBehavior())) {
                            return null;
                        }
                        if ("exception".equals(conn.getZeroDateTimeBehavior())) {
                            throw new SQLException("Value '0000-00-00' can not be represented as java.sql.Timestamp", "S1009");
                        }
                        year = 1;
                        month = 1;
                        day = 1;
                    }
                    if (!rs.useLegacyDatetimeCode) {
                        return TimeUtil.fastTimestampCreate(tz, year, month, day, hour, minute, seconds, nanos);
                    }
                    Timestamp ts = rs.fastTimestampCreate(rs.getCalendarInstanceForSessionOrNew(), year, month, day, hour, minute, seconds, nanos);
                    Timestamp adjustedTs = TimeUtil.changeTimezone(conn, sessionCalendar, targetCalendar, ts, conn.getServerTimezoneTZ(), tz, rollForward);
                    return adjustedTs;
                }
                return rs.getNativeTimestampViaParseConversion(columnIndex + 1, targetCalendar, tz, rollForward);
            }
        }
        throw new SQLException("Internal error - conversion method doesn't support this type", "S1000");
    }

    public abstract Object getNativeDateTimeValue(int var1, Calendar var2, int var3, int var4, TimeZone var5, boolean var6, ConnectionImpl var7, ResultSetImpl var8) throws SQLException;

    protected double getNativeDouble(byte[] bits2, int offset2) {
        long valueAsLong = (long)(bits2[offset2 + 0] & 0xFF) | (long)(bits2[offset2 + 1] & 0xFF) << 8 | (long)(bits2[offset2 + 2] & 0xFF) << 16 | (long)(bits2[offset2 + 3] & 0xFF) << 24 | (long)(bits2[offset2 + 4] & 0xFF) << 32 | (long)(bits2[offset2 + 5] & 0xFF) << 40 | (long)(bits2[offset2 + 6] & 0xFF) << 48 | (long)(bits2[offset2 + 7] & 0xFF) << 56;
        return Double.longBitsToDouble(valueAsLong);
    }

    public abstract double getNativeDouble(int var1) throws SQLException;

    protected float getNativeFloat(byte[] bits2, int offset2) {
        int asInt2 = bits2[offset2 + 0] & 0xFF | (bits2[offset2 + 1] & 0xFF) << 8 | (bits2[offset2 + 2] & 0xFF) << 16 | (bits2[offset2 + 3] & 0xFF) << 24;
        return Float.intBitsToFloat(asInt2);
    }

    public abstract float getNativeFloat(int var1) throws SQLException;

    protected int getNativeInt(byte[] bits2, int offset2) {
        int valueAsInt = bits2[offset2 + 0] & 0xFF | (bits2[offset2 + 1] & 0xFF) << 8 | (bits2[offset2 + 2] & 0xFF) << 16 | (bits2[offset2 + 3] & 0xFF) << 24;
        return valueAsInt;
    }

    public abstract int getNativeInt(int var1) throws SQLException;

    protected long getNativeLong(byte[] bits2, int offset2) {
        long valueAsLong = (long)(bits2[offset2 + 0] & 0xFF) | (long)(bits2[offset2 + 1] & 0xFF) << 8 | (long)(bits2[offset2 + 2] & 0xFF) << 16 | (long)(bits2[offset2 + 3] & 0xFF) << 24 | (long)(bits2[offset2 + 4] & 0xFF) << 32 | (long)(bits2[offset2 + 5] & 0xFF) << 40 | (long)(bits2[offset2 + 6] & 0xFF) << 48 | (long)(bits2[offset2 + 7] & 0xFF) << 56;
        return valueAsLong;
    }

    public abstract long getNativeLong(int var1) throws SQLException;

    protected short getNativeShort(byte[] bits2, int offset2) {
        short asShort = (short)(bits2[offset2 + 0] & 0xFF | (bits2[offset2 + 1] & 0xFF) << 8);
        return asShort;
    }

    public abstract short getNativeShort(int var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Time getNativeTime(int columnIndex, byte[] bits2, int offset2, int length2, Calendar targetCalendar, TimeZone tz, boolean rollForward, ConnectionImpl conn, ResultSetImpl rs) throws SQLException {
        Calendar sessionCalendar;
        byte hour = 0;
        int minute = 0;
        int seconds = 0;
        if (length2 != 0) {
            hour = bits2[offset2 + 5];
            minute = bits2[offset2 + 6];
            seconds = bits2[offset2 + 7];
        }
        if (!rs.useLegacyDatetimeCode) {
            return TimeUtil.fastTimeCreate(hour, minute, seconds, targetCalendar);
        }
        Calendar calendar = sessionCalendar = rs.getCalendarInstanceForSessionOrNew();
        synchronized (calendar) {
            Time time = TimeUtil.fastTimeCreate(sessionCalendar, (int)hour, minute, seconds);
            Time adjustedTime = TimeUtil.changeTimezone(conn, sessionCalendar, targetCalendar, time, conn.getServerTimezoneTZ(), tz, rollForward);
            return adjustedTime;
        }
    }

    public abstract Time getNativeTime(int var1, Calendar var2, TimeZone var3, boolean var4, ConnectionImpl var5, ResultSetImpl var6) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Timestamp getNativeTimestamp(byte[] bits2, int offset2, int length2, Calendar targetCalendar, TimeZone tz, boolean rollForward, ConnectionImpl conn, ResultSetImpl rs) throws SQLException {
        Calendar sessionCalendar;
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int seconds = 0;
        int nanos = 0;
        if (length2 != 0) {
            year = bits2[offset2 + 0] & 0xFF | (bits2[offset2 + 1] & 0xFF) << 8;
            month = bits2[offset2 + 2];
            day = bits2[offset2 + 3];
            if (length2 > 4) {
                hour = bits2[offset2 + 4];
                minute = bits2[offset2 + 5];
                seconds = bits2[offset2 + 6];
            }
            if (length2 > 7) {
                nanos = (bits2[offset2 + 7] & 0xFF | (bits2[offset2 + 8] & 0xFF) << 8 | (bits2[offset2 + 9] & 0xFF) << 16 | (bits2[offset2 + 10] & 0xFF) << 24) * 1000;
            }
        }
        if (year == 0 && month == 0 && day == 0) {
            if ("convertToNull".equals(conn.getZeroDateTimeBehavior())) {
                return null;
            }
            if ("exception".equals(conn.getZeroDateTimeBehavior())) {
                throw SQLError.createSQLException("Value '0000-00-00' can not be represented as java.sql.Timestamp", "S1009");
            }
            year = 1;
            month = 1;
            day = 1;
        }
        if (!rs.useLegacyDatetimeCode) {
            return TimeUtil.fastTimestampCreate(tz, year, month, day, hour, minute, seconds, nanos);
        }
        Calendar calendar = sessionCalendar = conn.getUseJDBCCompliantTimezoneShift() ? conn.getUtcCalendar() : rs.getCalendarInstanceForSessionOrNew();
        synchronized (calendar) {
            Timestamp ts = rs.fastTimestampCreate(sessionCalendar, year, month, day, hour, minute, seconds, nanos);
            Timestamp adjustedTs = TimeUtil.changeTimezone(conn, sessionCalendar, targetCalendar, ts, conn.getServerTimezoneTZ(), tz, rollForward);
            return adjustedTs;
        }
    }

    public abstract Timestamp getNativeTimestamp(int var1, Calendar var2, TimeZone var3, boolean var4, ConnectionImpl var5, ResultSetImpl var6) throws SQLException;

    public abstract Reader getReader(int var1) throws SQLException;

    public abstract String getString(int var1, String var2, ConnectionImpl var3) throws SQLException;

    protected String getString(String encoding, ConnectionImpl conn, byte[] value2, int offset2, int length2) throws SQLException {
        String stringVal2 = null;
        if (conn != null && conn.getUseUnicode()) {
            try {
                if (encoding == null) {
                    stringVal2 = new String(value2);
                }
                SingleByteCharsetConverter converter = conn.getCharsetConverter(encoding);
                if (converter != null) {
                    stringVal2 = converter.toString(value2, offset2, length2);
                }
                stringVal2 = new String(value2, offset2, length2, encoding);
            }
            catch (UnsupportedEncodingException E) {
                throw SQLError.createSQLException(Messages.getString("ResultSet.Unsupported_character_encoding____101") + encoding + "'.", "0S100");
            }
        } else {
            stringVal2 = StringUtils.toAsciiString(value2, offset2, length2);
        }
        return stringVal2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Time getTimeFast(int columnIndex, byte[] timeAsBytes, int offset2, int length2, Calendar targetCalendar, TimeZone tz, boolean rollForward, ConnectionImpl conn, ResultSetImpl rs) throws SQLException {
        int hr = 0;
        int min2 = 0;
        int sec = 0;
        try {
            int i;
            if (timeAsBytes == null) {
                return null;
            }
            boolean allZeroTime = true;
            boolean onlyTimePresent = false;
            for (i = 0; i < length2; ++i) {
                if (timeAsBytes[offset2 + i] != 58) continue;
                onlyTimePresent = true;
                break;
            }
            for (i = 0; i < length2; ++i) {
                byte b = timeAsBytes[offset2 + i];
                if (b == 32 || b == 45 || b == 47) {
                    onlyTimePresent = false;
                }
                if (b == 48 || b == 32 || b == 58 || b == 45 || b == 47 || b == 46) continue;
                allZeroTime = false;
                break;
            }
            if (!onlyTimePresent && allZeroTime) {
                if ("convertToNull".equals(conn.getZeroDateTimeBehavior())) {
                    return null;
                }
                if ("exception".equals(conn.getZeroDateTimeBehavior())) {
                    throw SQLError.createSQLException("Value '" + new String(timeAsBytes) + "' can not be represented as java.sql.Time", "S1009");
                }
                return rs.fastTimeCreate(targetCalendar, 0, 0, 0);
            }
            Field timeColField = this.metadata[columnIndex];
            if (timeColField.getMysqlType() == 7) {
                switch (length2) {
                    case 19: {
                        hr = StringUtils.getInt(timeAsBytes, offset2 + length2 - 8, offset2 + length2 - 6);
                        min2 = StringUtils.getInt(timeAsBytes, offset2 + length2 - 5, offset2 + length2 - 3);
                        sec = StringUtils.getInt(timeAsBytes, offset2 + length2 - 2, offset2 + length2);
                        break;
                    }
                    case 12: 
                    case 14: {
                        hr = StringUtils.getInt(timeAsBytes, offset2 + length2 - 6, offset2 + length2 - 4);
                        min2 = StringUtils.getInt(timeAsBytes, offset2 + length2 - 4, offset2 + length2 - 2);
                        sec = StringUtils.getInt(timeAsBytes, offset2 + length2 - 2, offset2 + length2);
                        break;
                    }
                    case 10: {
                        hr = StringUtils.getInt(timeAsBytes, offset2 + 6, offset2 + 8);
                        min2 = StringUtils.getInt(timeAsBytes, offset2 + 8, offset2 + 10);
                        sec = 0;
                        break;
                    }
                    default: {
                        throw SQLError.createSQLException(Messages.getString("ResultSet.Timestamp_too_small_to_convert_to_Time_value_in_column__257") + (columnIndex + 1) + "(" + timeColField + ").", "S1009");
                    }
                }
                SQLWarning precisionLost = new SQLWarning(Messages.getString("ResultSet.Precision_lost_converting_TIMESTAMP_to_Time_with_getTime()_on_column__261") + columnIndex + "(" + timeColField + ").");
            } else if (timeColField.getMysqlType() == 12) {
                hr = StringUtils.getInt(timeAsBytes, offset2 + 11, offset2 + 13);
                min2 = StringUtils.getInt(timeAsBytes, offset2 + 14, offset2 + 16);
                sec = StringUtils.getInt(timeAsBytes, offset2 + 17, offset2 + 19);
                SQLWarning precisionLost = new SQLWarning(Messages.getString("ResultSet.Precision_lost_converting_DATETIME_to_Time_with_getTime()_on_column__264") + (columnIndex + 1) + "(" + timeColField + ").");
            } else {
                if (timeColField.getMysqlType() == 10) {
                    return rs.fastTimeCreate(null, 0, 0, 0);
                }
                if (length2 != 5 && length2 != 8) {
                    throw SQLError.createSQLException(Messages.getString("ResultSet.Bad_format_for_Time____267") + new String(timeAsBytes) + Messages.getString("ResultSet.___in_column__268") + (columnIndex + 1), "S1009");
                }
                hr = StringUtils.getInt(timeAsBytes, offset2 + 0, offset2 + 2);
                min2 = StringUtils.getInt(timeAsBytes, offset2 + 3, offset2 + 5);
                sec = length2 == 5 ? 0 : StringUtils.getInt(timeAsBytes, offset2 + 6, offset2 + 8);
            }
            Calendar sessionCalendar = rs.getCalendarInstanceForSessionOrNew();
            if (!rs.useLegacyDatetimeCode) {
                return rs.fastTimeCreate(targetCalendar, hr, min2, sec);
            }
            Calendar calendar = sessionCalendar;
            synchronized (calendar) {
                return TimeUtil.changeTimezone(conn, sessionCalendar, targetCalendar, rs.fastTimeCreate(sessionCalendar, hr, min2, sec), conn.getServerTimezoneTZ(), tz, rollForward);
            }
        }
        catch (Exception ex2) {
            SQLException sqlEx = SQLError.createSQLException(ex2.toString(), "S1009");
            sqlEx.initCause(ex2);
            throw sqlEx;
        }
    }

    public abstract Time getTimeFast(int var1, Calendar var2, TimeZone var3, boolean var4, ConnectionImpl var5, ResultSetImpl var6) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Timestamp getTimestampFast(int columnIndex, byte[] timestampAsBytes, int offset2, int length2, Calendar targetCalendar, TimeZone tz, boolean rollForward, ConnectionImpl conn, ResultSetImpl rs) throws SQLException {
        try {
            Calendar sessionCalendar;
            Calendar calendar = sessionCalendar = conn.getUseJDBCCompliantTimezoneShift() ? conn.getUtcCalendar() : rs.getCalendarInstanceForSessionOrNew();
            synchronized (calendar) {
                int i;
                boolean allZeroTimestamp = true;
                boolean onlyTimePresent = false;
                for (i = 0; i < length2; ++i) {
                    if (timestampAsBytes[offset2 + i] != 58) continue;
                    onlyTimePresent = true;
                    break;
                }
                for (i = 0; i < length2; ++i) {
                    byte b = timestampAsBytes[offset2 + i];
                    if (b == 32 || b == 45 || b == 47) {
                        onlyTimePresent = false;
                    }
                    if (b == 48 || b == 32 || b == 58 || b == 45 || b == 47 || b == 46) continue;
                    allZeroTimestamp = false;
                    break;
                }
                if (!onlyTimePresent && allZeroTimestamp) {
                    if ("convertToNull".equals(conn.getZeroDateTimeBehavior())) {
                        return null;
                    }
                    if ("exception".equals(conn.getZeroDateTimeBehavior())) {
                        throw SQLError.createSQLException("Value '" + timestampAsBytes + "' can not be represented as java.sql.Timestamp", "S1009");
                    }
                    if (!rs.useLegacyDatetimeCode) {
                        return TimeUtil.fastTimestampCreate(tz, 1, 1, 1, 0, 0, 0, 0);
                    }
                    return rs.fastTimestampCreate(null, 1, 1, 1, 0, 0, 0, 0);
                }
                if (this.metadata[columnIndex].getMysqlType() == 13) {
                    if (!rs.useLegacyDatetimeCode) {
                        return TimeUtil.fastTimestampCreate(tz, StringUtils.getInt(timestampAsBytes, offset2, 4), 1, 1, 0, 0, 0, 0);
                    }
                    return TimeUtil.changeTimezone(conn, sessionCalendar, targetCalendar, rs.fastTimestampCreate(sessionCalendar, StringUtils.getInt(timestampAsBytes, offset2, 4), 1, 1, 0, 0, 0, 0), conn.getServerTimezoneTZ(), tz, rollForward);
                }
                if (timestampAsBytes[offset2 + length2 - 1] == 46) {
                    --length2;
                }
                int year = 0;
                int month = 0;
                int day = 0;
                int hour = 0;
                int minutes = 0;
                int seconds = 0;
                int nanos = 0;
                switch (length2) {
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: {
                        year = StringUtils.getInt(timestampAsBytes, offset2 + 0, offset2 + 4);
                        month = StringUtils.getInt(timestampAsBytes, offset2 + 5, offset2 + 7);
                        day = StringUtils.getInt(timestampAsBytes, offset2 + 8, offset2 + 10);
                        hour = StringUtils.getInt(timestampAsBytes, offset2 + 11, offset2 + 13);
                        minutes = StringUtils.getInt(timestampAsBytes, offset2 + 14, offset2 + 16);
                        seconds = StringUtils.getInt(timestampAsBytes, offset2 + 17, offset2 + 19);
                        nanos = 0;
                        if (length2 <= 19) break;
                        int decimalIndex = -1;
                        for (int i2 = 0; i2 < length2; ++i2) {
                            if (timestampAsBytes[offset2 + i2] != 46) continue;
                            decimalIndex = i2;
                        }
                        if (decimalIndex == -1) break;
                        if (decimalIndex + 2 <= length2) {
                            nanos = StringUtils.getInt(timestampAsBytes, decimalIndex + 1, offset2 + length2);
                            break;
                        }
                        throw new IllegalArgumentException();
                    }
                    case 14: {
                        year = StringUtils.getInt(timestampAsBytes, offset2 + 0, offset2 + 4);
                        month = StringUtils.getInt(timestampAsBytes, offset2 + 4, offset2 + 6);
                        day = StringUtils.getInt(timestampAsBytes, offset2 + 6, offset2 + 8);
                        hour = StringUtils.getInt(timestampAsBytes, offset2 + 8, offset2 + 10);
                        minutes = StringUtils.getInt(timestampAsBytes, offset2 + 10, offset2 + 12);
                        seconds = StringUtils.getInt(timestampAsBytes, offset2 + 12, offset2 + 14);
                        break;
                    }
                    case 12: {
                        year = StringUtils.getInt(timestampAsBytes, offset2 + 0, offset2 + 2);
                        if (year <= 69) {
                            year += 100;
                        }
                        year += 1900;
                        month = StringUtils.getInt(timestampAsBytes, offset2 + 2, offset2 + 4);
                        day = StringUtils.getInt(timestampAsBytes, offset2 + 4, offset2 + 6);
                        hour = StringUtils.getInt(timestampAsBytes, offset2 + 6, offset2 + 8);
                        minutes = StringUtils.getInt(timestampAsBytes, offset2 + 8, offset2 + 10);
                        seconds = StringUtils.getInt(timestampAsBytes, offset2 + 10, offset2 + 12);
                        break;
                    }
                    case 10: {
                        boolean hasDash = false;
                        for (int i3 = 0; i3 < length2; ++i3) {
                            if (timestampAsBytes[offset2 + i3] != 45) continue;
                            hasDash = true;
                            break;
                        }
                        if (this.metadata[columnIndex].getMysqlType() == 10 || hasDash) {
                            year = StringUtils.getInt(timestampAsBytes, offset2 + 0, offset2 + 4);
                            month = StringUtils.getInt(timestampAsBytes, offset2 + 5, offset2 + 7);
                            day = StringUtils.getInt(timestampAsBytes, offset2 + 8, offset2 + 10);
                            hour = 0;
                            minutes = 0;
                            break;
                        }
                        year = StringUtils.getInt(timestampAsBytes, offset2 + 0, offset2 + 2);
                        if (year <= 69) {
                            year += 100;
                        }
                        month = StringUtils.getInt(timestampAsBytes, offset2 + 2, offset2 + 4);
                        day = StringUtils.getInt(timestampAsBytes, offset2 + 4, offset2 + 6);
                        hour = StringUtils.getInt(timestampAsBytes, offset2 + 6, offset2 + 8);
                        minutes = StringUtils.getInt(timestampAsBytes, offset2 + 8, offset2 + 10);
                        year += 1900;
                        break;
                    }
                    case 8: {
                        boolean hasColon = false;
                        for (int i4 = 0; i4 < length2; ++i4) {
                            if (timestampAsBytes[offset2 + i4] != 58) continue;
                            hasColon = true;
                            break;
                        }
                        if (hasColon) {
                            hour = StringUtils.getInt(timestampAsBytes, offset2 + 0, offset2 + 2);
                            minutes = StringUtils.getInt(timestampAsBytes, offset2 + 3, offset2 + 5);
                            seconds = StringUtils.getInt(timestampAsBytes, offset2 + 6, offset2 + 8);
                            year = 1970;
                            month = 1;
                            day = 1;
                            break;
                        }
                        year = StringUtils.getInt(timestampAsBytes, offset2 + 0, offset2 + 4);
                        month = StringUtils.getInt(timestampAsBytes, offset2 + 4, offset2 + 6);
                        day = StringUtils.getInt(timestampAsBytes, offset2 + 6, offset2 + 8);
                        year -= 1900;
                        --month;
                        break;
                    }
                    case 6: {
                        year = StringUtils.getInt(timestampAsBytes, offset2 + 0, offset2 + 2);
                        if (year <= 69) {
                            year += 100;
                        }
                        year += 1900;
                        month = StringUtils.getInt(timestampAsBytes, offset2 + 2, offset2 + 4);
                        day = StringUtils.getInt(timestampAsBytes, offset2 + 4, offset2 + 6);
                        break;
                    }
                    case 4: {
                        year = StringUtils.getInt(timestampAsBytes, offset2 + 0, offset2 + 2);
                        if (year <= 69) {
                            year += 100;
                        }
                        month = StringUtils.getInt(timestampAsBytes, offset2 + 2, offset2 + 4);
                        day = 1;
                        break;
                    }
                    case 2: {
                        year = StringUtils.getInt(timestampAsBytes, offset2 + 0, offset2 + 2);
                        if (year <= 69) {
                            year += 100;
                        }
                        year += 1900;
                        month = 1;
                        day = 1;
                        break;
                    }
                    default: {
                        throw new SQLException("Bad format for Timestamp '" + new String(timestampAsBytes) + "' in column " + (columnIndex + 1) + ".", "S1009");
                    }
                }
                if (!rs.useLegacyDatetimeCode) {
                    return TimeUtil.fastTimestampCreate(tz, year, month, day, hour, minutes, seconds, nanos);
                }
                return TimeUtil.changeTimezone(conn, sessionCalendar, targetCalendar, rs.fastTimestampCreate(sessionCalendar, year, month, day, hour, minutes, seconds, nanos), conn.getServerTimezoneTZ(), tz, rollForward);
            }
        }
        catch (Exception e2) {
            SQLException sqlEx = SQLError.createSQLException("Cannot convert value '" + this.getString(columnIndex, "ISO8859_1", conn) + "' from column " + (columnIndex + 1) + " to TIMESTAMP.", "S1009");
            sqlEx.initCause(e2);
            throw sqlEx;
        }
    }

    public abstract Timestamp getTimestampFast(int var1, Calendar var2, TimeZone var3, boolean var4, ConnectionImpl var5, ResultSetImpl var6) throws SQLException;

    public abstract boolean isFloatingPointNumber(int var1) throws SQLException;

    public abstract boolean isNull(int var1) throws SQLException;

    public abstract long length(int var1) throws SQLException;

    public abstract void setColumnValue(int var1, byte[] var2) throws SQLException;

    public ResultSetRow setMetadata(Field[] f2) throws SQLException {
        this.metadata = f2;
        return this;
    }
}

