/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.CharsetMapping;
import com.mysql.jdbc.Connection;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SingleByteCharsetConverter {
    private static final int BYTE_RANGE = 256;
    private static byte[] allBytes;
    private static final Map CONVERTER_MAP;
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static byte[] unknownCharsMap;
    private char[] byteToChars = new char[256];
    private byte[] charToByteMap = new byte[65536];

    public static synchronized SingleByteCharsetConverter getInstance(String encodingName, Connection conn) throws UnsupportedEncodingException, SQLException {
        SingleByteCharsetConverter instance = (SingleByteCharsetConverter)CONVERTER_MAP.get(encodingName);
        if (instance == null) {
            instance = SingleByteCharsetConverter.initCharset(encodingName);
        }
        return instance;
    }

    public static SingleByteCharsetConverter initCharset(String javaEncodingName) throws UnsupportedEncodingException, SQLException {
        if (CharsetMapping.isMultibyteCharset(javaEncodingName)) {
            return null;
        }
        SingleByteCharsetConverter converter = new SingleByteCharsetConverter(javaEncodingName);
        CONVERTER_MAP.put(javaEncodingName, converter);
        return converter;
    }

    public static String toStringDefaultEncoding(byte[] buffer, int startPos, int length2) {
        return new String(buffer, startPos, length2);
    }

    private SingleByteCharsetConverter(String encodingName) throws UnsupportedEncodingException {
        String allBytesString = new String(allBytes, 0, 256, encodingName);
        int allBytesLen = allBytesString.length();
        System.arraycopy(unknownCharsMap, 0, this.charToByteMap, 0, this.charToByteMap.length);
        for (int i = 0; i < 256 && i < allBytesLen; ++i) {
            char c2;
            this.byteToChars[i] = c2 = allBytesString.charAt(i);
            this.charToByteMap[c2] = allBytes[i];
        }
    }

    public final byte[] toBytes(char[] c2) {
        if (c2 == null) {
            return null;
        }
        int length2 = c2.length;
        byte[] bytes2 = new byte[length2];
        for (int i = 0; i < length2; ++i) {
            bytes2[i] = this.charToByteMap[c2[i]];
        }
        return bytes2;
    }

    public final byte[] toBytesWrapped(char[] c2, char beginWrap, char endWrap) {
        if (c2 == null) {
            return null;
        }
        int length2 = c2.length + 2;
        int charLength = c2.length;
        byte[] bytes2 = new byte[length2];
        bytes2[0] = this.charToByteMap[beginWrap];
        for (int i = 0; i < charLength; ++i) {
            bytes2[i + 1] = this.charToByteMap[c2[i]];
        }
        bytes2[length2 - 1] = this.charToByteMap[endWrap];
        return bytes2;
    }

    public final byte[] toBytes(char[] chars, int offset2, int length2) {
        if (chars == null) {
            return null;
        }
        if (length2 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes2 = new byte[length2];
        for (int i = 0; i < length2; ++i) {
            bytes2[i] = this.charToByteMap[chars[i + offset2]];
        }
        return bytes2;
    }

    public final byte[] toBytes(String s2) {
        if (s2 == null) {
            return null;
        }
        int length2 = s2.length();
        byte[] bytes2 = new byte[length2];
        for (int i = 0; i < length2; ++i) {
            bytes2[i] = this.charToByteMap[s2.charAt(i)];
        }
        return bytes2;
    }

    public final byte[] toBytesWrapped(String s2, char beginWrap, char endWrap) {
        if (s2 == null) {
            return null;
        }
        int stringLength = s2.length();
        int length2 = stringLength + 2;
        byte[] bytes2 = new byte[length2];
        bytes2[0] = this.charToByteMap[beginWrap];
        for (int i = 0; i < stringLength; ++i) {
            bytes2[i + 1] = this.charToByteMap[s2.charAt(i)];
        }
        bytes2[length2 - 1] = this.charToByteMap[endWrap];
        return bytes2;
    }

    public final byte[] toBytes(String s2, int offset2, int length2) {
        if (s2 == null) {
            return null;
        }
        if (length2 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes2 = new byte[length2];
        for (int i = 0; i < length2; ++i) {
            char c2 = s2.charAt(i + offset2);
            bytes2[i] = this.charToByteMap[c2];
        }
        return bytes2;
    }

    public final String toString(byte[] buffer) {
        return this.toString(buffer, 0, buffer.length);
    }

    public final String toString(byte[] buffer, int startPos, int length2) {
        char[] charArray = new char[length2];
        int readpoint = startPos;
        for (int i = 0; i < length2; ++i) {
            charArray[i] = this.byteToChars[buffer[readpoint] - -128];
            ++readpoint;
        }
        return new String(charArray);
    }

    static {
        int i;
        allBytes = new byte[256];
        CONVERTER_MAP = new HashMap();
        EMPTY_BYTE_ARRAY = new byte[0];
        unknownCharsMap = new byte[65536];
        for (i = -128; i <= 127; ++i) {
            SingleByteCharsetConverter.allBytes[i - -128] = (byte)i;
        }
        for (i = 0; i < unknownCharsMap.length; ++i) {
            SingleByteCharsetConverter.unknownCharsMap[i] = 63;
        }
    }
}

