/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Extension;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.StringUtils;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class Util {
    protected static Method systemNanoTimeMethod;
    private static Method CAST_METHOD;
    private static final TimeZone DEFAULT_TIMEZONE;
    private static Util enclosingInstance;
    private static boolean isJdbc4;
    private static boolean isColdFusion;
    static /* synthetic */ Class class$java$lang$System;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;

    public static boolean nanoTimeAvailable() {
        return systemNanoTimeMethod != null;
    }

    static final TimeZone getDefaultTimeZone() {
        return (TimeZone)DEFAULT_TIMEZONE.clone();
    }

    public static boolean isJdbc4() {
        return isJdbc4;
    }

    public static boolean isColdFusion() {
        return isColdFusion;
    }

    static String newCrypt(String password, String seed) {
        byte b;
        double d;
        int i;
        if (password == null || password.length() == 0) {
            return password;
        }
        long[] pw = Util.newHash(seed);
        long[] msg = Util.newHash(password);
        long max2 = 0x3FFFFFFFL;
        long seed1 = (pw[0] ^ msg[0]) % max2;
        long seed2 = (pw[1] ^ msg[1]) % max2;
        char[] chars = new char[seed.length()];
        for (i = 0; i < seed.length(); ++i) {
            seed1 = (seed1 * 3L + seed2) % max2;
            seed2 = (seed1 + seed2 + 33L) % max2;
            d = (double)seed1 / (double)max2;
            b = (byte)Math.floor(d * 31.0 + 64.0);
            chars[i] = (char)b;
        }
        seed1 = (seed1 * 3L + seed2) % max2;
        seed2 = (seed1 + seed2 + 33L) % max2;
        d = (double)seed1 / (double)max2;
        b = (byte)Math.floor(d * 31.0);
        i = 0;
        while (i < seed.length()) {
            int n = i++;
            chars[n] = (char)(chars[n] ^ (char)b);
        }
        return new String(chars);
    }

    static long[] newHash(String password) {
        long nr = 1345345333L;
        long add5 = 7L;
        long nr2 = 305419889L;
        for (int i = 0; i < password.length(); ++i) {
            if (password.charAt(i) == ' ' || password.charAt(i) == '\t') continue;
            long tmp = 0xFF & password.charAt(i);
            nr ^= ((nr & 0x3FL) + add5) * tmp + (nr << 8);
            nr2 += nr2 << 8 ^ nr;
            add5 += tmp;
        }
        long[] result2 = new long[]{nr & Integer.MAX_VALUE, nr2 & Integer.MAX_VALUE};
        return result2;
    }

    static String oldCrypt(String password, String seed) {
        long max2 = 0x1FFFFFFL;
        if (password == null || password.length() == 0) {
            return password;
        }
        long hp = Util.oldHash(seed);
        long hm = Util.oldHash(password);
        long nr = hp ^ hm;
        long s1 = nr %= max2;
        long s2 = nr / 2L;
        char[] chars = new char[seed.length()];
        for (int i = 0; i < seed.length(); ++i) {
            s1 = (s1 * 3L + s2) % max2;
            s2 = (s1 + s2 + 33L) % max2;
            double d = (double)s1 / (double)max2;
            byte b = (byte)Math.floor(d * 31.0 + 64.0);
            chars[i] = (char)b;
        }
        return new String(chars);
    }

    static long oldHash(String password) {
        long nr = 1345345333L;
        long nr2 = 7L;
        for (int i = 0; i < password.length(); ++i) {
            if (password.charAt(i) == ' ' || password.charAt(i) == '\t') continue;
            long tmp = password.charAt(i);
            nr ^= ((nr & 0x3FL) + nr2) * tmp + (nr << 8);
            nr2 += tmp;
        }
        return nr & Integer.MAX_VALUE;
    }

    private static RandStructcture randomInit(long seed1, long seed2) {
        RandStructcture randStruct = enclosingInstance.new RandStructcture();
        randStruct.maxValue = 0x3FFFFFFFL;
        randStruct.maxValueDbl = randStruct.maxValue;
        randStruct.seed1 = seed1 % randStruct.maxValue;
        randStruct.seed2 = seed2 % randStruct.maxValue;
        return randStruct;
    }

    public static Object readObject(ResultSet resultSet, int index2) throws Exception {
        ObjectInputStream objIn = new ObjectInputStream(resultSet.getBinaryStream(index2));
        Object obj = objIn.readObject();
        objIn.close();
        return obj;
    }

    private static double rnd(RandStructcture randStruct) {
        randStruct.seed1 = (randStruct.seed1 * 3L + randStruct.seed2) % randStruct.maxValue;
        randStruct.seed2 = (randStruct.seed1 + randStruct.seed2 + 33L) % randStruct.maxValue;
        return (double)randStruct.seed1 / randStruct.maxValueDbl;
    }

    public static String scramble(String message, String password) {
        byte[] to2 = new byte[8];
        String val = "";
        message = message.substring(0, 8);
        if (password != null && password.length() > 0) {
            long[] hashPass = Util.newHash(password);
            long[] hashMessage = Util.newHash(message);
            RandStructcture randStruct = Util.randomInit(hashPass[0] ^ hashMessage[0], hashPass[1] ^ hashMessage[1]);
            int msgPos = 0;
            int msgLength = message.length();
            int toPos = 0;
            while (msgPos++ < msgLength) {
                to2[toPos++] = (byte)(Math.floor(Util.rnd(randStruct) * 31.0) + 64.0);
            }
            byte extra = (byte)Math.floor(Util.rnd(randStruct) * 31.0);
            int i = 0;
            while (i < to2.length) {
                int n = i++;
                to2[n] = (byte)(to2[n] ^ extra);
            }
            val = new String(to2);
        }
        return val;
    }

    public static String stackTraceToString(Throwable ex2) {
        StringBuffer traceBuf = new StringBuffer();
        traceBuf.append(Messages.getString("Util.1"));
        if (ex2 != null) {
            traceBuf.append(ex2.getClass().getName());
            String message = ex2.getMessage();
            if (message != null) {
                traceBuf.append(Messages.getString("Util.2"));
                traceBuf.append(message);
            }
            StringWriter out = new StringWriter();
            PrintWriter printOut = new PrintWriter(out);
            ex2.printStackTrace(printOut);
            traceBuf.append(Messages.getString("Util.3"));
            traceBuf.append(out.toString());
        }
        traceBuf.append(Messages.getString("Util.4"));
        return traceBuf.toString();
    }

    public static Object getInstance(String className, Class[] argTypes, Object[] args2) throws SQLException {
        try {
            return Util.handleNewInstance(Class.forName(className).getConstructor(argTypes), args2);
        }
        catch (SecurityException e2) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e2);
        }
        catch (NoSuchMethodException e3) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e3);
        }
        catch (ClassNotFoundException e4) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e4);
        }
    }

    public static final Object handleNewInstance(Constructor ctor, Object[] args2) throws SQLException {
        try {
            return ctor.newInstance(args2);
        }
        catch (IllegalArgumentException e2) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e2);
        }
        catch (InstantiationException e3) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e3);
        }
        catch (IllegalAccessException e4) {
            throw SQLError.createSQLException("Can't instantiate required class", "S1000", e4);
        }
        catch (InvocationTargetException e5) {
            Throwable target2 = e5.getTargetException();
            if (target2 instanceof SQLException) {
                throw (SQLException)target2;
            }
            if (target2 instanceof ExceptionInInitializerError) {
                target2 = ((ExceptionInInitializerError)target2).getException();
            }
            throw SQLError.createSQLException(target2.toString(), "S1000");
        }
    }

    public static boolean interfaceExists(String hostname) {
        try {
            Class<?> networkInterfaceClass = Class.forName("java.net.NetworkInterface");
            return networkInterfaceClass.getMethod("getByName", null).invoke(networkInterfaceClass, hostname) != null;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    public static Object cast(Object invokeOn, Object toCast) {
        if (CAST_METHOD != null) {
            try {
                return CAST_METHOD.invoke(invokeOn, toCast);
            }
            catch (Throwable t2) {
                return null;
            }
        }
        return null;
    }

    public static long getCurrentTimeNanosOrMillis() {
        if (systemNanoTimeMethod != null) {
            try {
                return (Long)systemNanoTimeMethod.invoke(null, null);
            }
            catch (IllegalArgumentException e2) {
            }
            catch (IllegalAccessException e3) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return System.currentTimeMillis();
    }

    public static void resultSetToMap(Map mappedValues, ResultSet rs) throws SQLException {
        while (rs.next()) {
            mappedValues.put(rs.getObject(1), rs.getObject(2));
        }
    }

    public static Map calculateDifferences(Map map1, Map map22) {
        HashMap diffMap = new HashMap();
        Iterator map1Entries = map1.entrySet().iterator();
        while (map1Entries.hasNext()) {
            Map.Entry entry2 = map1Entries.next();
            Object key = entry2.getKey();
            Number value1 = null;
            Number value2 = null;
            if (entry2.getValue() instanceof Number) {
                value1 = (Number)entry2.getValue();
                value2 = (Number)map22.get(key);
            } else {
                try {
                    value1 = new Double(entry2.getValue().toString());
                    value2 = new Double(map22.get(key).toString());
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
            }
            if (value1.equals(value2)) continue;
            if (value1 instanceof Byte) {
                diffMap.put(key, new Byte((byte)((Byte)value2 - (Byte)value1)));
                continue;
            }
            if (value1 instanceof Short) {
                diffMap.put(key, new Short((short)((Short)value2 - (Short)value1)));
                continue;
            }
            if (value1 instanceof Integer) {
                diffMap.put(key, new Integer((Integer)value2 - (Integer)value1));
                continue;
            }
            if (value1 instanceof Long) {
                diffMap.put(key, new Long((Long)value2 - (Long)value1));
                continue;
            }
            if (value1 instanceof Float) {
                diffMap.put(key, new Float(((Float)value2).floatValue() - ((Float)value1).floatValue()));
                continue;
            }
            if (value1 instanceof Double) {
                diffMap.put(key, new Double(((Double)value2).shortValue() - ((Double)value1).shortValue()));
                continue;
            }
            if (value1 instanceof BigDecimal) {
                diffMap.put(key, ((BigDecimal)value2).subtract((BigDecimal)value1));
                continue;
            }
            if (!(value1 instanceof BigInteger)) continue;
            diffMap.put(key, ((BigInteger)value2).subtract((BigInteger)value1));
        }
        return diffMap;
    }

    public static List loadExtensions(Connection conn, Properties props, String extensionClassNames, String errorMessageKey) throws SQLException {
        LinkedList<Extension> extensionList = new LinkedList<Extension>();
        List interceptorsToCreate = StringUtils.split(extensionClassNames, ",", true);
        Iterator iter2 = interceptorsToCreate.iterator();
        String className = null;
        try {
            while (iter2.hasNext()) {
                className = iter2.next().toString();
                Extension extensionInstance = (Extension)Class.forName(className).newInstance();
                extensionInstance.init(conn, props);
                extensionList.add(extensionInstance);
            }
        }
        catch (Throwable t2) {
            SQLException sqlEx = SQLError.createSQLException(Messages.getString(errorMessageKey, new Object[]{className}));
            sqlEx.initCause(t2);
            throw sqlEx;
        }
        return extensionList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            systemNanoTimeMethod = (class$java$lang$System == null ? (class$java$lang$System = Util.class$("java.lang.System")) : class$java$lang$System).getMethod("nanoTime", null);
        }
        catch (SecurityException e2) {
            systemNanoTimeMethod = null;
        }
        catch (NoSuchMethodException e3) {
            systemNanoTimeMethod = null;
        }
        DEFAULT_TIMEZONE = TimeZone.getDefault();
        enclosingInstance = new Util();
        isJdbc4 = false;
        isColdFusion = false;
        try {
            CAST_METHOD = (class$java$lang$Class == null ? (class$java$lang$Class = Util.class$("java.lang.Class")) : class$java$lang$Class).getMethod("cast", class$java$lang$Object == null ? (class$java$lang$Object = Util.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (Throwable t2) {
            // empty catch block
        }
        try {
            Class.forName("java.sql.NClob");
            isJdbc4 = true;
        }
        catch (Throwable t3) {
            isJdbc4 = false;
        }
        String loadedFrom = Util.stackTraceToString(new Throwable());
        isColdFusion = loadedFrom != null ? loadedFrom.indexOf("coldfusion") != -1 : false;
    }

    class RandStructcture {
        long maxValue;
        double maxValueDbl;
        long seed1;
        long seed2;

        RandStructcture() {
        }
    }
}

