/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.jdbc2.optional;

import com.mysql.jdbc.jdbc2.optional.MysqlPooledConnection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Map;

abstract class WrapperBase {
    protected MysqlPooledConnection pooledConnection;
    protected Map unwrappedInterfaces = null;

    WrapperBase() {
    }

    protected void checkAndFireConnectionError(SQLException sqlEx) throws SQLException {
        if (this.pooledConnection != null && "08S01".equals(sqlEx.getSQLState())) {
            this.pooledConnection.callConnectionEventListeners(1, sqlEx);
        }
        throw sqlEx;
    }

    protected class ConnectionErrorFiringInvocationHandler
    implements InvocationHandler {
        Object invokeOn = null;

        public ConnectionErrorFiringInvocationHandler(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
        }

        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            Object result2 = null;
            try {
                result2 = method.invoke(this.invokeOn, args2);
                if (result2 != null) {
                    result2 = this.proxyIfInterfaceIsJdbc(result2, result2.getClass());
                }
            }
            catch (InvocationTargetException e2) {
                if (e2.getTargetException() instanceof SQLException) {
                    WrapperBase.this.checkAndFireConnectionError((SQLException)e2.getTargetException());
                }
                throw e2;
            }
            return result2;
        }

        private Object proxyIfInterfaceIsJdbc(Object toProxy, Class clazz2) {
            int i = 0;
            Class<?>[] interfaces2 = clazz2.getInterfaces();
            if (i < interfaces2.length) {
                String packageName = interfaces2[i].getPackage().getName();
                if ("java.sql".equals(packageName) || "javax.sql".equals(packageName)) {
                    return Proxy.newProxyInstance(toProxy.getClass().getClassLoader(), interfaces2, (InvocationHandler)new ConnectionErrorFiringInvocationHandler(toProxy));
                }
                return this.proxyIfInterfaceIsJdbc(toProxy, interfaces2[i]);
            }
            return toProxy;
        }
    }
}

