/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.PartialRequestBuilder;
import com.sun.jersey.api.client.RequestBuilder;
import com.sun.jersey.api.client.ViewUniformInterface;
import com.sun.jersey.api.client.filter.Filterable;
import com.sun.jersey.client.impl.ClientRequestImpl;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

public class ViewResource
extends Filterable
implements RequestBuilder<Builder>,
ViewUniformInterface {
    private final Client client;
    private final URI u;

    ViewResource(Client c2, URI u) {
        super(c2);
        this.client = c2;
        this.u = u;
    }

    private ViewResource(ViewResource that, UriBuilder ub) {
        super(that);
        this.client = that.client;
        this.u = ub.build(new Object[0]);
    }

    public URI getURI() {
        return this.u;
    }

    public UriBuilder getUriBuilder() {
        return UriBuilder.fromUri(this.u);
    }

    public Builder getRequestBuilder() {
        return new Builder();
    }

    public String toString() {
        return this.u.toString();
    }

    public int hashCode() {
        return this.u.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ViewResource) {
            ViewResource that = (ViewResource)obj;
            return that.u.equals(this.u);
        }
        return false;
    }

    @Override
    public <T> T head(Class<T> c2) {
        return (T)this.handle((T)c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "HEAD"));
    }

    @Override
    public <T> T head(T t2) {
        return this.handle(t2, (ClientRequest)new ClientRequestImpl(this.getURI(), "HEAD"));
    }

    @Override
    public <T> T options(Class<T> c2) {
        return (T)this.handle((T)c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    @Override
    public <T> T options(T t2) {
        return this.handle(t2, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    @Override
    public <T> T get(Class<T> c2) {
        return (T)this.handle((T)c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    @Override
    public <T> T get(T t2) {
        return this.handle(t2, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    @Override
    public <T> T put(Class<T> c2) {
        return (T)this.handle((T)c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    @Override
    public <T> T put(T t2) {
        return this.handle(t2, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    @Override
    public <T> T put(Class<T> c2, Object requestEntity) {
        return (T)this.handle((T)c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    @Override
    public <T> T put(T t2, Object requestEntity) {
        return this.handle(t2, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    @Override
    public <T> T post(Class<T> c2) {
        return (T)this.handle((T)c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    @Override
    public <T> T post(T t2) {
        return this.handle(t2, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    @Override
    public <T> T post(Class<T> c2, Object requestEntity) {
        return (T)this.handle((T)c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    @Override
    public <T> T post(T t2, Object requestEntity) {
        return this.handle(t2, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    @Override
    public <T> T delete(Class<T> c2) {
        return (T)this.handle((T)c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    @Override
    public <T> T delete(T t2) {
        return this.handle(t2, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    @Override
    public <T> T delete(Class<T> c2, Object requestEntity) {
        return (T)this.handle((T)c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    @Override
    public <T> T delete(T t2, Object requestEntity) {
        return this.handle(t2, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    @Override
    public <T> T method(String method, Class<T> c2) {
        return (T)this.handle((T)c2, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    @Override
    public <T> T method(String method, T t2) {
        return this.handle(t2, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    @Override
    public <T> T method(String method, Class<T> c2, Object requestEntity) {
        return (T)this.handle((T)c2, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    @Override
    public <T> T method(String method, T t2, Object requestEntity) {
        return this.handle(t2, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    @Override
    public Builder entity(Object entity) {
        return (Builder)this.getRequestBuilder().entity(entity);
    }

    @Override
    public Builder entity(Object entity, MediaType type) {
        return (Builder)this.getRequestBuilder().entity(entity, type);
    }

    @Override
    public Builder entity(Object entity, String type) {
        return (Builder)this.getRequestBuilder().entity(entity, type);
    }

    @Override
    public Builder type(MediaType type) {
        return (Builder)this.getRequestBuilder().type(type);
    }

    @Override
    public Builder type(String type) {
        return (Builder)this.getRequestBuilder().type(type);
    }

    @Override
    public Builder accept(MediaType ... types2) {
        return (Builder)this.getRequestBuilder().accept(types2);
    }

    @Override
    public Builder accept(String ... types2) {
        return (Builder)this.getRequestBuilder().accept(types2);
    }

    @Override
    public Builder acceptLanguage(Locale ... locales) {
        return (Builder)this.getRequestBuilder().acceptLanguage(locales);
    }

    @Override
    public Builder acceptLanguage(String ... locales) {
        return (Builder)this.getRequestBuilder().acceptLanguage(locales);
    }

    @Override
    public Builder cookie(Cookie cookie) {
        return (Builder)this.getRequestBuilder().cookie(cookie);
    }

    @Override
    public Builder header(String name, Object value2) {
        return (Builder)this.getRequestBuilder().header(name, value2);
    }

    public ViewResource path(String path2) {
        return new ViewResource(this, this.getUriBuilder().path(path2));
    }

    public ViewResource uri(URI uri) {
        String query2;
        UriBuilder b = this.getUriBuilder();
        String path2 = uri.getRawPath();
        if (path2 != null && path2.length() > 0) {
            if (path2.startsWith("/")) {
                b.replacePath(path2);
            } else {
                b.path(path2);
            }
        }
        if ((query2 = uri.getRawQuery()) != null && query2.length() > 0) {
            b.replaceQuery(query2);
        }
        return new ViewResource(this, b);
    }

    public ViewResource queryParam(String key, String value2) {
        UriBuilder b = this.getUriBuilder();
        b.queryParam(key, value2);
        return new ViewResource(this, b);
    }

    public ViewResource queryParams(MultivaluedMap<String, String> params2) {
        UriBuilder b = this.getUriBuilder();
        for (Map.Entry e2 : params2.entrySet()) {
            for (String value2 : (List)e2.getValue()) {
                b.queryParam((String)e2.getKey(), value2);
            }
        }
        return new ViewResource(this, b);
    }

    private <T> T handle(Class<T> c2, ClientRequest ro) {
        return (T)this.client.getViewProxy(c2).view(c2, ro, this.getHeadHandler());
    }

    private <T> T handle(T t2, ClientRequest ro) {
        return (T)this.client.getViewProxy(t2.getClass()).view(t2, ro, this.getHeadHandler());
    }

    public final class Builder
    extends PartialRequestBuilder<Builder>
    implements ViewUniformInterface {
        private Builder() {
        }

        private ClientRequest build(String method) {
            ClientRequestImpl ro = new ClientRequestImpl(ViewResource.this.u, method, this.entity, this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        private ClientRequest build(String method, Object e2) {
            ClientRequestImpl ro = new ClientRequestImpl(ViewResource.this.u, method, e2, this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        @Override
        public <T> T head(Class<T> c2) {
            return (T)ViewResource.this.handle((Object)c2, this.build("HEAD"));
        }

        @Override
        public <T> T head(T t2) {
            return (T)ViewResource.this.handle(t2, this.build("HEAD"));
        }

        @Override
        public <T> T options(Class<T> c2) {
            return (T)ViewResource.this.handle((Object)c2, this.build("OPTIONS"));
        }

        @Override
        public <T> T options(T t2) {
            return (T)ViewResource.this.handle(t2, this.build("OPTIONS"));
        }

        @Override
        public <T> T get(Class<T> c2) {
            return (T)ViewResource.this.handle((Object)c2, this.build("GET"));
        }

        @Override
        public <T> T get(T t2) {
            return (T)ViewResource.this.handle(t2, this.build("GET"));
        }

        @Override
        public <T> T put(Class<T> c2) {
            return (T)ViewResource.this.handle((Object)c2, this.build("PUT"));
        }

        @Override
        public <T> T put(T t2) {
            return (T)ViewResource.this.handle(t2, this.build("PUT"));
        }

        @Override
        public <T> T put(Class<T> c2, Object requestEntity) {
            return (T)ViewResource.this.handle((Object)c2, this.build("PUT", requestEntity));
        }

        @Override
        public <T> T put(T t2, Object requestEntity) {
            return (T)ViewResource.this.handle(t2, this.build("PUT", requestEntity));
        }

        @Override
        public <T> T post(Class<T> c2) {
            return (T)ViewResource.this.handle((Object)c2, this.build("POST"));
        }

        @Override
        public <T> T post(T t2) {
            return (T)ViewResource.this.handle(t2, this.build("POST"));
        }

        @Override
        public <T> T post(Class<T> c2, Object requestEntity) {
            return (T)ViewResource.this.handle((Object)c2, this.build("POST", requestEntity));
        }

        @Override
        public <T> T post(T t2, Object requestEntity) {
            return (T)ViewResource.this.handle(t2, this.build("POST", requestEntity));
        }

        @Override
        public <T> T delete(Class<T> c2) {
            return (T)ViewResource.this.handle((Object)c2, this.build("DELETE"));
        }

        @Override
        public <T> T delete(T t2) {
            return (T)ViewResource.this.handle(t2, this.build("DELETE"));
        }

        @Override
        public <T> T delete(Class<T> c2, Object requestEntity) {
            return (T)ViewResource.this.handle((Object)c2, this.build("DELETE", requestEntity));
        }

        @Override
        public <T> T delete(T t2, Object requestEntity) {
            return (T)ViewResource.this.handle(t2, this.build("DELETE", requestEntity));
        }

        @Override
        public <T> T method(String method, Class<T> c2) {
            return (T)ViewResource.this.handle((Object)c2, this.build(method));
        }

        @Override
        public <T> T method(String method, T t2) {
            return (T)ViewResource.this.handle(t2, this.build(method));
        }

        @Override
        public <T> T method(String method, Class<T> c2, Object requestEntity) {
            return (T)ViewResource.this.handle((Object)c2, this.build(method, requestEntity));
        }

        @Override
        public <T> T method(String method, T t2, Object requestEntity) {
            return (T)ViewResource.this.handle(t2, this.build(method, requestEntity));
        }
    }
}

