/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.PartialRequestBuilder;
import com.sun.jersey.api.client.RequestBuilder;
import com.sun.jersey.api.client.UniformInterface;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.filter.Filterable;
import com.sun.jersey.client.impl.ClientRequestImpl;
import com.sun.jersey.client.impl.CopyOnWriteHashMap;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

public class WebResource
extends Filterable
implements RequestBuilder<Builder>,
UniformInterface {
    private final URI u;
    private CopyOnWriteHashMap<String, Object> properties;

    WebResource(ClientHandler c2, CopyOnWriteHashMap<String, Object> properties2, URI u) {
        super(c2);
        this.u = u;
        this.properties = properties2.clone();
    }

    private WebResource(WebResource that, UriBuilder ub) {
        super(that);
        this.u = ub.build(new Object[0]);
        this.properties = that.properties == null ? null : that.properties.clone();
    }

    public URI getURI() {
        return this.u;
    }

    @Deprecated
    public UriBuilder getBuilder() {
        return UriBuilder.fromUri(this.u);
    }

    public UriBuilder getUriBuilder() {
        return UriBuilder.fromUri(this.u);
    }

    public Builder getRequestBuilder() {
        return new Builder();
    }

    public String toString() {
        return this.u.toString();
    }

    public int hashCode() {
        return this.u.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WebResource) {
            WebResource that = (WebResource)obj;
            return that.u.equals(this.u);
        }
        return false;
    }

    @Override
    public ClientResponse head() {
        return this.getHeadHandler().handle(new ClientRequestImpl(this.getURI(), "HEAD"));
    }

    @Override
    public <T> T options(Class<T> c2) throws UniformInterfaceException {
        return this.handle(c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    @Override
    public <T> T options(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "OPTIONS"));
    }

    @Override
    public <T> T get(Class<T> c2) throws UniformInterfaceException {
        return this.handle(c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    @Override
    public <T> T get(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "GET"));
    }

    @Override
    public void put() throws UniformInterfaceException {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "PUT", null));
    }

    @Override
    public void put(Object requestEntity) throws UniformInterfaceException {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    @Override
    public <T> T put(Class<T> c2) throws UniformInterfaceException {
        return this.handle(c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    @Override
    public <T> T put(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT"));
    }

    @Override
    public <T> T put(Class<T> c2, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    @Override
    public <T> T put(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "PUT", requestEntity));
    }

    @Override
    public void post() throws UniformInterfaceException {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "POST"));
    }

    @Override
    public void post(Object requestEntity) throws UniformInterfaceException {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    @Override
    public <T> T post(Class<T> c2) throws UniformInterfaceException {
        return this.handle(c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    @Override
    public <T> T post(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST"));
    }

    @Override
    public <T> T post(Class<T> c2, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    @Override
    public <T> T post(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "POST", requestEntity));
    }

    @Override
    public void delete() throws UniformInterfaceException {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    @Override
    public void delete(Object requestEntity) throws UniformInterfaceException {
        this.voidHandle(new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    @Override
    public <T> T delete(Class<T> c2) throws UniformInterfaceException {
        return this.handle(c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    @Override
    public <T> T delete(GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE"));
    }

    @Override
    public <T> T delete(Class<T> c2, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c2, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    @Override
    public <T> T delete(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), "DELETE", requestEntity));
    }

    @Override
    public void method(String method) throws UniformInterfaceException {
        this.voidHandle(new ClientRequestImpl(this.getURI(), method));
    }

    @Override
    public void method(String method, Object requestEntity) throws UniformInterfaceException {
        this.voidHandle(new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    @Override
    public <T> T method(String method, Class<T> c2) throws UniformInterfaceException {
        return this.handle(c2, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    @Override
    public <T> T method(String method, GenericType<T> gt) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), method));
    }

    @Override
    public <T> T method(String method, Class<T> c2, Object requestEntity) throws UniformInterfaceException {
        return this.handle(c2, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    @Override
    public <T> T method(String method, GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
        return this.handle(gt, (ClientRequest)new ClientRequestImpl(this.getURI(), method, requestEntity));
    }

    @Override
    public Builder entity(Object entity) {
        return (Builder)this.getRequestBuilder().entity(entity);
    }

    @Override
    public Builder entity(Object entity, MediaType type) {
        return (Builder)this.getRequestBuilder().entity(entity, type);
    }

    @Override
    public Builder entity(Object entity, String type) {
        return (Builder)this.getRequestBuilder().entity(entity, type);
    }

    @Override
    public Builder type(MediaType type) {
        return (Builder)this.getRequestBuilder().type(type);
    }

    @Override
    public Builder type(String type) {
        return (Builder)this.getRequestBuilder().type(type);
    }

    @Override
    public Builder accept(MediaType ... types2) {
        return (Builder)this.getRequestBuilder().accept(types2);
    }

    @Override
    public Builder accept(String ... types2) {
        return (Builder)this.getRequestBuilder().accept(types2);
    }

    @Override
    public Builder acceptLanguage(Locale ... locales) {
        return (Builder)this.getRequestBuilder().acceptLanguage(locales);
    }

    @Override
    public Builder acceptLanguage(String ... locales) {
        return (Builder)this.getRequestBuilder().acceptLanguage(locales);
    }

    @Override
    public Builder cookie(Cookie cookie) {
        return (Builder)this.getRequestBuilder().cookie(cookie);
    }

    @Override
    public Builder header(String name, Object value2) {
        return (Builder)this.getRequestBuilder().header(name, value2);
    }

    public WebResource path(String path2) {
        return new WebResource(this, this.getUriBuilder().path(path2));
    }

    public WebResource uri(URI uri) {
        String query2;
        UriBuilder b = this.getUriBuilder();
        String path2 = uri.getRawPath();
        if (path2 != null && path2.length() > 0) {
            if (path2.startsWith("/")) {
                b.replacePath(path2);
            } else {
                b.path(path2);
            }
        }
        if ((query2 = uri.getRawQuery()) != null && query2.length() > 0) {
            b.replaceQuery(query2);
        }
        return new WebResource(this, b);
    }

    public WebResource queryParam(String key, String value2) {
        UriBuilder b = this.getUriBuilder();
        b.queryParam(key, value2);
        return new WebResource(this, b);
    }

    public WebResource queryParams(MultivaluedMap<String, String> params2) {
        UriBuilder b = this.getUriBuilder();
        for (Map.Entry e2 : params2.entrySet()) {
            for (String value2 : (List)e2.getValue()) {
                b.queryParam((String)e2.getKey(), value2);
            }
        }
        return new WebResource(this, b);
    }

    public void setProperty(String property, Object value2) {
        this.getProperties().put(property, value2);
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new CopyOnWriteHashMap();
        }
        return this.properties;
    }

    private void setProperties(ClientRequest ro) {
        if (this.properties != null) {
            ro.setProperties(this.properties);
        }
    }

    private <T> T handle(Class<T> c2, ClientRequest ro) throws UniformInterfaceException {
        this.setProperties(ro);
        ClientResponse r = this.getHeadHandler().handle(ro);
        if (c2 == ClientResponse.class) {
            return c2.cast(r);
        }
        if (r.getStatus() < 300) {
            return r.getEntity(c2);
        }
        throw new UniformInterfaceException(r, ro.getPropertyAsFeature("com.sun.jersey.client.property.bufferResponseEntityOnException", true));
    }

    private <T> T handle(GenericType<T> gt, ClientRequest ro) throws UniformInterfaceException {
        this.setProperties(ro);
        ClientResponse r = this.getHeadHandler().handle(ro);
        if (gt.getRawClass() == ClientResponse.class) {
            return gt.getRawClass().cast(r);
        }
        if (r.getStatus() < 300) {
            return r.getEntity(gt);
        }
        throw new UniformInterfaceException(r, ro.getPropertyAsFeature("com.sun.jersey.client.property.bufferResponseEntityOnException", true));
    }

    private void voidHandle(ClientRequest ro) throws UniformInterfaceException {
        this.setProperties(ro);
        ClientResponse r = this.getHeadHandler().handle(ro);
        if (r.getStatus() >= 300) {
            throw new UniformInterfaceException(r, ro.getPropertyAsFeature("com.sun.jersey.client.property.bufferResponseEntityOnException", true));
        }
        r.close();
    }

    public final class Builder
    extends PartialRequestBuilder<Builder>
    implements UniformInterface {
        private Builder() {
        }

        private ClientRequest build(String method) {
            ClientRequestImpl ro = new ClientRequestImpl(WebResource.this.u, method, this.entity, this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        private ClientRequest build(String method, Object e2) {
            ClientRequestImpl ro = new ClientRequestImpl(WebResource.this.u, method, e2, this.metadata);
            this.entity = null;
            this.metadata = null;
            return ro;
        }

        @Override
        public ClientResponse head() {
            return WebResource.this.getHeadHandler().handle(this.build("HEAD"));
        }

        @Override
        public <T> T options(Class<T> c2) throws UniformInterfaceException {
            return (T)WebResource.this.handle(c2, this.build("OPTIONS"));
        }

        @Override
        public <T> T options(GenericType<T> gt) throws UniformInterfaceException {
            return (T)WebResource.this.handle(gt, this.build("OPTIONS"));
        }

        @Override
        public <T> T get(Class<T> c2) throws UniformInterfaceException {
            return (T)WebResource.this.handle(c2, this.build("GET"));
        }

        @Override
        public <T> T get(GenericType<T> gt) throws UniformInterfaceException {
            return (T)WebResource.this.handle(gt, this.build("GET"));
        }

        @Override
        public void put() throws UniformInterfaceException {
            WebResource.this.voidHandle(this.build("PUT"));
        }

        @Override
        public void put(Object requestEntity) throws UniformInterfaceException {
            WebResource.this.voidHandle(this.build("PUT", requestEntity));
        }

        @Override
        public <T> T put(Class<T> c2) throws UniformInterfaceException {
            return (T)WebResource.this.handle(c2, this.build("PUT"));
        }

        @Override
        public <T> T put(GenericType<T> gt) throws UniformInterfaceException {
            return (T)WebResource.this.handle(gt, this.build("PUT"));
        }

        @Override
        public <T> T put(Class<T> c2, Object requestEntity) throws UniformInterfaceException {
            return (T)WebResource.this.handle(c2, this.build("PUT", requestEntity));
        }

        @Override
        public <T> T put(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
            return (T)WebResource.this.handle(gt, this.build("PUT", requestEntity));
        }

        @Override
        public void post() throws UniformInterfaceException {
            WebResource.this.voidHandle(this.build("POST"));
        }

        @Override
        public void post(Object requestEntity) throws UniformInterfaceException {
            WebResource.this.voidHandle(this.build("POST", requestEntity));
        }

        @Override
        public <T> T post(Class<T> c2) throws UniformInterfaceException {
            return (T)WebResource.this.handle(c2, this.build("POST"));
        }

        @Override
        public <T> T post(GenericType<T> gt) throws UniformInterfaceException {
            return (T)WebResource.this.handle(gt, this.build("POST"));
        }

        @Override
        public <T> T post(Class<T> c2, Object requestEntity) throws UniformInterfaceException {
            return (T)WebResource.this.handle(c2, this.build("POST", requestEntity));
        }

        @Override
        public <T> T post(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
            return (T)WebResource.this.handle(gt, this.build("POST", requestEntity));
        }

        @Override
        public void delete() throws UniformInterfaceException {
            WebResource.this.voidHandle(this.build("DELETE"));
        }

        @Override
        public void delete(Object requestEntity) throws UniformInterfaceException {
            WebResource.this.voidHandle(this.build("DELETE", requestEntity));
        }

        @Override
        public <T> T delete(Class<T> c2) throws UniformInterfaceException {
            return (T)WebResource.this.handle(c2, this.build("DELETE"));
        }

        @Override
        public <T> T delete(GenericType<T> gt) throws UniformInterfaceException {
            return (T)WebResource.this.handle(gt, this.build("DELETE"));
        }

        @Override
        public <T> T delete(Class<T> c2, Object requestEntity) throws UniformInterfaceException {
            return (T)WebResource.this.handle(c2, this.build("DELETE", requestEntity));
        }

        @Override
        public <T> T delete(GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
            return (T)WebResource.this.handle(gt, this.build("DELETE", requestEntity));
        }

        @Override
        public void method(String method) throws UniformInterfaceException {
            WebResource.this.voidHandle(this.build(method));
        }

        @Override
        public void method(String method, Object requestEntity) throws UniformInterfaceException {
            WebResource.this.voidHandle(this.build(method, requestEntity));
        }

        @Override
        public <T> T method(String method, Class<T> c2) throws UniformInterfaceException {
            return (T)WebResource.this.handle(c2, this.build(method));
        }

        @Override
        public <T> T method(String method, GenericType<T> gt) throws UniformInterfaceException {
            return (T)WebResource.this.handle(gt, this.build(method));
        }

        @Override
        public <T> T method(String method, Class<T> c2, Object requestEntity) throws UniformInterfaceException {
            return (T)WebResource.this.handle(c2, this.build(method, requestEntity));
        }

        @Override
        public <T> T method(String method, GenericType<T> gt, Object requestEntity) throws UniformInterfaceException {
            return (T)WebResource.this.handle(gt, this.build(method, requestEntity));
        }
    }
}

