/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.uri;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;

public class UriComponent {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] SCHEME = new String[]{"0-9", "A-Z", "a-z", "+", "-", "."};
    private static final String[] UNRESERVED = new String[]{"0-9", "A-Z", "a-z", "-", ".", "_", "~"};
    private static final String[] SUB_DELIMS = new String[]{"!", "$", "&", "'", "(", ")", "*", "+", ",", ";", "="};
    private static final boolean[][] ENCODING_TABLES = UriComponent.initEncodingTables();
    private static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private static final int[] HEX_TABLE = UriComponent.initHexTable();

    private UriComponent() {
    }

    public static void validate(String s2, Type t2) {
        UriComponent.validate(s2, t2, false);
    }

    public static void validate(String s2, Type t2, boolean template) {
        int i = UriComponent._valid(s2, t2, template);
        if (i > -1) {
            throw new IllegalArgumentException("The string '" + s2 + "' for the URI component " + (Object)((Object)t2) + " contains an invalid character, '" + s2.charAt(i) + "', at index " + i);
        }
    }

    public static boolean valid(String s2, Type t2) {
        return UriComponent.valid(s2, t2, false);
    }

    public static boolean valid(String s2, Type t2, boolean template) {
        return UriComponent._valid(s2, t2, template) == -1;
    }

    private static int _valid(String s2, Type t2, boolean template) {
        boolean[] table2 = ENCODING_TABLES[t2.ordinal()];
        for (int i = 0; i < s2.length(); ++i) {
            char c2 = s2.charAt(i);
            if ((c2 >= '\u0080' || c2 == '%' || table2[c2]) && c2 < '\u0080' || template && (c2 == '{' || c2 == '}')) continue;
            return i;
        }
        return -1;
    }

    public static String contextualEncode(String s2, Type t2) {
        return UriComponent._encode(s2, t2, false, true);
    }

    public static String contextualEncode(String s2, Type t2, boolean template) {
        return UriComponent._encode(s2, t2, template, true);
    }

    public static String encode(String s2, Type t2) {
        return UriComponent._encode(s2, t2, false, false);
    }

    public static String encode(String s2, Type t2, boolean template) {
        return UriComponent._encode(s2, t2, template, false);
    }

    public static String encodeTemplateNames(String s2) {
        int i = s2.indexOf(123);
        if (i != -1) {
            s2 = s2.replace("{", "%7B");
        }
        if ((i = s2.indexOf(125)) != -1) {
            s2 = s2.replace("}", "%7D");
        }
        return s2;
    }

    private static String _encode(String s2, Type t2, boolean template, boolean contextualEncode) {
        boolean[] table2 = ENCODING_TABLES[t2.ordinal()];
        StringBuilder sb = null;
        for (int i = 0; i < s2.length(); ++i) {
            char c2 = s2.charAt(i);
            if (c2 < '\u0080' && table2[c2]) {
                if (sb == null) continue;
                sb.append(c2);
                continue;
            }
            if (template && (c2 == '{' || c2 == '}')) {
                if (sb == null) continue;
                sb.append(c2);
                continue;
            }
            if (contextualEncode && c2 == '%' && i + 2 < s2.length() && UriComponent.isHexCharacter(s2.charAt(i + 1)) && UriComponent.isHexCharacter(s2.charAt(i + 2))) {
                if (sb != null) {
                    sb.append('%').append(s2.charAt(i + 1)).append(s2.charAt(i + 2));
                }
                i += 2;
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(s2.substring(0, i));
            }
            if (c2 < '\u0080') {
                if (c2 == ' ' && t2 == Type.QUERY_PARAM) {
                    sb.append('+');
                    continue;
                }
                UriComponent.appendPercentEncodedOctet(sb, c2);
                continue;
            }
            UriComponent.appendUTF8EncodedCharacter(sb, c2);
        }
        return sb == null ? s2 : sb.toString();
    }

    private static void appendPercentEncodedOctet(StringBuilder sb, int b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4]);
        sb.append(HEX_DIGITS[b & 0xF]);
    }

    private static void appendUTF8EncodedCharacter(StringBuilder sb, char c2) {
        ByteBuffer bb = UTF_8_CHARSET.encode("" + c2);
        while (bb.hasRemaining()) {
            UriComponent.appendPercentEncodedOctet(sb, bb.get() & 0xFF);
        }
    }

    private static boolean[][] initEncodingTables() {
        boolean[][] tables = new boolean[Type.values().length][];
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(Arrays.asList(SCHEME));
        tables[Type.SCHEME.ordinal()] = UriComponent.initEncodingTable(l);
        l.clear();
        l.addAll(Arrays.asList(UNRESERVED));
        tables[Type.UNRESERVED.ordinal()] = UriComponent.initEncodingTable(l);
        l.addAll(Arrays.asList(SUB_DELIMS));
        tables[Type.HOST.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.PORT.ordinal()] = UriComponent.initEncodingTable(Arrays.asList("0-9"));
        l.add(":");
        tables[Type.USER_INFO.ordinal()] = UriComponent.initEncodingTable(l);
        l.add("@");
        tables[Type.AUTHORITY.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.PATH_SEGMENT.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.PATH_SEGMENT.ordinal()][59] = false;
        tables[Type.MATRIX_PARAM.ordinal()] = (boolean[])tables[Type.PATH_SEGMENT.ordinal()].clone();
        tables[Type.MATRIX_PARAM.ordinal()][61] = false;
        l.add("/");
        tables[Type.PATH.ordinal()] = UriComponent.initEncodingTable(l);
        l.add("?");
        tables[Type.QUERY.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.FRAGMENT.ordinal()] = tables[Type.QUERY.ordinal()];
        tables[Type.QUERY_PARAM.ordinal()] = UriComponent.initEncodingTable(l);
        tables[Type.QUERY_PARAM.ordinal()][61] = false;
        tables[Type.QUERY_PARAM.ordinal()][43] = false;
        tables[Type.QUERY_PARAM.ordinal()][38] = false;
        return tables;
    }

    private static boolean[] initEncodingTable(List<String> allowed) {
        boolean[] table2 = new boolean[128];
        for (String range2 : allowed) {
            if (range2.length() == 1) {
                table2[range2.charAt((int)0)] = true;
                continue;
            }
            if (range2.length() != 3 || range2.charAt(1) != '-') continue;
            for (int i = range2.charAt(0); i <= range2.charAt(2); ++i) {
                table2[i] = true;
            }
        }
        return table2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String decode(String s2, Type t2) {
        if (s2 == null) {
            throw new IllegalArgumentException();
        }
        int n = s2.length();
        if (n == 0) {
            return s2;
        }
        if (s2.indexOf(37) < 0) {
            if (t2 != Type.QUERY_PARAM) return s2;
            if (s2.indexOf(43) < 0) {
                return s2;
            }
        } else {
            if (n < 2) {
                throw new IllegalArgumentException("Malformed percent-encoded octet at index 1");
            }
            if (s2.charAt(n - 2) == '%') {
                throw new IllegalArgumentException("Malformed percent-encoded octet at index " + (n - 2));
            }
        }
        if (t2 == null) {
            return UriComponent.decode(s2, n);
        }
        switch (t2) {
            case HOST: {
                return UriComponent.decodeHost(s2, n);
            }
            case QUERY_PARAM: {
                return UriComponent.decodeQueryParam(s2, n);
            }
        }
        return UriComponent.decode(s2, n);
    }

    public static MultivaluedMap<String, String> decodeQuery(URI u, boolean decode) {
        return UriComponent.decodeQuery(u.getRawQuery(), decode);
    }

    public static MultivaluedMap<String, String> decodeQuery(String q, boolean decode) {
        MultivaluedMapImpl queryParameters = new MultivaluedMapImpl();
        if (q == null || q.length() == 0) {
            return queryParameters;
        }
        int s2 = 0;
        int e2 = 0;
        do {
            if ((e2 = q.indexOf(38, s2)) == -1) {
                UriComponent.decodeQueryParam(queryParameters, q.substring(s2), decode);
                continue;
            }
            if (e2 <= s2) continue;
            UriComponent.decodeQueryParam(queryParameters, q.substring(s2, e2), decode);
        } while ((s2 = e2 + 1) > 0 && s2 < q.length());
        return queryParameters;
    }

    private static void decodeQueryParam(MultivaluedMap<String, String> params2, String param2, boolean decode) {
        try {
            int equals2 = param2.indexOf(61);
            if (equals2 > 0) {
                params2.add(URLDecoder.decode(param2.substring(0, equals2), "UTF-8"), decode ? URLDecoder.decode(param2.substring(equals2 + 1), "UTF-8") : param2.substring(equals2 + 1));
            } else if (equals2 != 0 && param2.length() > 0) {
                params2.add(URLDecoder.decode(param2, "UTF-8"), "");
            }
        }
        catch (UnsupportedEncodingException ex2) {
            throw new IllegalArgumentException(ex2);
        }
    }

    public static List<PathSegment> decodePath(URI u, boolean decode) {
        String rawPath = u.getRawPath();
        if (rawPath != null && rawPath.length() > 0 && rawPath.charAt(0) == '/') {
            rawPath = rawPath.substring(1);
        }
        return UriComponent.decodePath(rawPath, decode);
    }

    public static List<PathSegment> decodePath(String path2, boolean decode) {
        LinkedList<PathSegment> segments2 = new LinkedList<PathSegment>();
        if (path2 == null) {
            return segments2;
        }
        int s2 = 0;
        int e2 = -1;
        do {
            if ((e2 = path2.indexOf(47, s2 = e2 + 1)) > s2) {
                UriComponent.decodePathSegment(segments2, path2.substring(s2, e2), decode);
                continue;
            }
            if (e2 != s2) continue;
            segments2.add(PathSegmentImpl.EMPTY_PATH_SEGMENT);
        } while (e2 != -1);
        if (s2 < path2.length()) {
            UriComponent.decodePathSegment(segments2, path2.substring(s2), decode);
        } else {
            segments2.add(PathSegmentImpl.EMPTY_PATH_SEGMENT);
        }
        return segments2;
    }

    public static void decodePathSegment(List<PathSegment> segments2, String segment, boolean decode) {
        int colon2 = segment.indexOf(59);
        if (colon2 != -1) {
            segments2.add(new PathSegmentImpl(colon2 == 0 ? "" : segment.substring(0, colon2), decode, UriComponent.decodeMatrix(segment, decode)));
        } else {
            segments2.add(new PathSegmentImpl(segment, decode));
        }
    }

    public static MultivaluedMap<String, String> decodeMatrix(String pathSegment, boolean decode) {
        MultivaluedMapImpl matrixMap = new MultivaluedMapImpl();
        int s2 = pathSegment.indexOf(59) + 1;
        if (s2 == 0 || s2 == pathSegment.length()) {
            return matrixMap;
        }
        int e2 = 0;
        do {
            if ((e2 = pathSegment.indexOf(59, s2)) == -1) {
                UriComponent.decodeMatrixParam(matrixMap, pathSegment.substring(s2), decode);
                continue;
            }
            if (e2 <= s2) continue;
            UriComponent.decodeMatrixParam(matrixMap, pathSegment.substring(s2, e2), decode);
        } while ((s2 = e2 + 1) > 0 && s2 < pathSegment.length());
        return matrixMap;
    }

    private static void decodeMatrixParam(MultivaluedMap<String, String> params2, String param2, boolean decode) {
        int equals2 = param2.indexOf(61);
        if (equals2 > 0) {
            params2.add(UriComponent.decode(param2.substring(0, equals2), Type.MATRIX_PARAM), decode ? UriComponent.decode(param2.substring(equals2 + 1), Type.MATRIX_PARAM) : param2.substring(equals2 + 1));
        } else if (equals2 != 0 && param2.length() > 0) {
            params2.add(UriComponent.decode(param2, Type.MATRIX_PARAM), "");
        }
    }

    private static String decode(String s2, int n) {
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = null;
        int i = 0;
        while (i < n) {
            char c2;
            if ((c2 = s2.charAt(i++)) != '%') {
                sb.append(c2);
                continue;
            }
            bb = UriComponent.decodePercentEncodedOctets(s2, i, bb);
            i = UriComponent.decodeOctets(i, bb, sb);
        }
        return sb.toString();
    }

    private static String decodeQueryParam(String s2, int n) {
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = null;
        int i = 0;
        while (i < n) {
            char c2;
            if ((c2 = s2.charAt(i++)) != '%') {
                if (c2 != '+') {
                    sb.append(c2);
                    continue;
                }
                sb.append(' ');
                continue;
            }
            bb = UriComponent.decodePercentEncodedOctets(s2, i, bb);
            i = UriComponent.decodeOctets(i, bb, sb);
        }
        return sb.toString();
    }

    private static String decodeHost(String s2, int n) {
        StringBuilder sb = new StringBuilder(n);
        ByteBuffer bb = null;
        boolean betweenBrackets = false;
        int i = 0;
        while (i < n) {
            char c2;
            if ((c2 = s2.charAt(i++)) == '[') {
                betweenBrackets = true;
            } else if (betweenBrackets && c2 == ']') {
                betweenBrackets = false;
            }
            if (c2 != '%' || betweenBrackets) {
                sb.append(c2);
                continue;
            }
            bb = UriComponent.decodePercentEncodedOctets(s2, i, bb);
            i = UriComponent.decodeOctets(i, bb, sb);
        }
        return sb.toString();
    }

    private static ByteBuffer decodePercentEncodedOctets(String s2, int i, ByteBuffer bb) {
        if (bb == null) {
            bb = ByteBuffer.allocate(1);
        } else {
            bb.clear();
        }
        while (true) {
            bb.put((byte)(UriComponent.decodeHex(s2, i++) << 4 | UriComponent.decodeHex(s2, i++)));
            if (i == s2.length() || s2.charAt(i++) != '%') break;
            if (bb.position() != bb.capacity()) continue;
            bb.flip();
            ByteBuffer bb_new = ByteBuffer.allocate(s2.length() / 3);
            bb_new.put(bb);
            bb = bb_new;
        }
        bb.flip();
        return bb;
    }

    private static int decodeOctets(int i, ByteBuffer bb, StringBuilder sb) {
        if (bb.limit() == 1 && (bb.get(0) & 0xFF) < 128) {
            sb.append((char)bb.get(0));
            return i + 2;
        }
        CharBuffer cb = UTF_8_CHARSET.decode(bb);
        sb.append(cb.toString());
        return i + bb.limit() * 3 - 1;
    }

    private static int decodeHex(String s2, int i) {
        int v = UriComponent.decodeHex(s2.charAt(i));
        if (v == -1) {
            throw new IllegalArgumentException("Malformed percent-encoded octet at index " + i + ", invalid hexadecimal digit '" + s2.charAt(i) + "'");
        }
        return v;
    }

    private static int[] initHexTable() {
        int c2;
        int[] table2 = new int[128];
        Arrays.fill(table2, -1);
        for (c2 = 48; c2 <= 57; c2 = (int)((char)(c2 + 1))) {
            table2[c2] = c2 - 48;
        }
        for (c2 = 65; c2 <= 70; c2 = (int)((char)(c2 + 1))) {
            table2[c2] = c2 - 65 + 10;
        }
        for (c2 = 97; c2 <= 102; c2 = (int)((char)(c2 + 1))) {
            table2[c2] = c2 - 97 + 10;
        }
        return table2;
    }

    private static int decodeHex(char c2) {
        return c2 < '\u0080' ? HEX_TABLE[c2] : -1;
    }

    private static boolean isHexCharacter(char c2) {
        return c2 < '\u0080' && HEX_TABLE[c2] != -1;
    }

    private static final class PathSegmentImpl
    implements PathSegment {
        private static final PathSegment EMPTY_PATH_SEGMENT = new PathSegmentImpl("", false);
        private final String path;
        private final MultivaluedMap<String, String> matrixParameters;

        PathSegmentImpl(String path2, boolean decode) {
            this(path2, decode, new MultivaluedMapImpl());
        }

        PathSegmentImpl(String path2, boolean decode, MultivaluedMap<String, String> matrixParameters) {
            this.path = decode ? UriComponent.decode(path2, Type.PATH_SEGMENT) : path2;
            this.matrixParameters = matrixParameters;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public MultivaluedMap<String, String> getMatrixParameters() {
            return this.matrixParameters;
        }
    }

    public static enum Type {
        UNRESERVED,
        SCHEME,
        AUTHORITY,
        USER_INFO,
        HOST,
        PORT,
        PATH,
        PATH_SEGMENT,
        MATRIX_PARAM,
        QUERY,
        QUERY_PARAM,
        FRAGMENT;

    }
}

