/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.uri;

import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.api.uri.UriPattern;
import com.sun.jersey.api.uri.UriTemplateParser;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class UriTemplate {
    public static final Comparator<UriTemplate> COMPARATOR = new Comparator<UriTemplate>(){

        @Override
        public int compare(UriTemplate o1, UriTemplate o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 == EMPTY && o2 == EMPTY) {
                return 0;
            }
            if (o1 == EMPTY) {
                return 1;
            }
            if (o2 == EMPTY) {
                return -1;
            }
            int i = o2.getNumberOfExplicitCharacters() - o1.getNumberOfExplicitCharacters();
            if (i != 0) {
                return i;
            }
            i = o2.getNumberOfTemplateVariables() - o1.getNumberOfTemplateVariables();
            if (i != 0) {
                return i;
            }
            i = o2.getNumberOfExplicitRegexes() - o1.getNumberOfExplicitRegexes();
            if (i != 0) {
                return i;
            }
            return o2.pattern.getRegex().compareTo(o1.pattern.getRegex());
        }
    };
    private static final Pattern TEMPLATE_NAMES_PATTERN = Pattern.compile("\\{(\\w[-\\w\\.]*)\\}");
    public static final UriTemplate EMPTY = new UriTemplate();
    private final String template;
    private final String normalizedTemplate;
    private final UriPattern pattern;
    private final boolean endsWithSlash;
    private final List<String> templateVariables;
    private final int numOfExplicitRegexes;
    private final int numOfCharacters;

    private UriTemplate() {
        this.normalizedTemplate = "";
        this.template = "";
        this.pattern = UriPattern.EMPTY;
        this.endsWithSlash = false;
        this.templateVariables = Collections.emptyList();
        this.numOfCharacters = 0;
        this.numOfExplicitRegexes = 0;
    }

    public UriTemplate(String template) throws PatternSyntaxException, IllegalArgumentException {
        this(new UriTemplateParser(template));
    }

    protected UriTemplate(UriTemplateParser templateParser) throws PatternSyntaxException, IllegalArgumentException {
        this.template = templateParser.getTemplate();
        this.normalizedTemplate = templateParser.getNormalizedTemplate();
        this.pattern = this.createUriPattern(templateParser);
        this.numOfExplicitRegexes = templateParser.getNumberOfExplicitRegexes();
        this.numOfCharacters = templateParser.getNumberOfLiteralCharacters();
        this.endsWithSlash = this.template.charAt(this.template.length() - 1) == '/';
        this.templateVariables = Collections.unmodifiableList(templateParser.getNames());
    }

    protected UriPattern createUriPattern(UriTemplateParser templateParser) {
        return new UriPattern(templateParser.getPattern(), templateParser.getGroupIndexes());
    }

    public final String getTemplate() {
        return this.template;
    }

    public final UriPattern getPattern() {
        return this.pattern;
    }

    public final boolean endsWithSlash() {
        return this.endsWithSlash;
    }

    public final List<String> getTemplateVariables() {
        return this.templateVariables;
    }

    public final boolean isTemplateVariablePresent(String name) {
        for (String s2 : this.templateVariables) {
            if (!s2.equals(name)) continue;
            return true;
        }
        return false;
    }

    public final int getNumberOfExplicitRegexes() {
        return this.numOfExplicitRegexes;
    }

    public final int getNumberOfExplicitCharacters() {
        return this.numOfCharacters;
    }

    public final int getNumberOfTemplateVariables() {
        return this.templateVariables.size();
    }

    public final boolean match(CharSequence uri, Map<String, String> templateVariableToValue) throws IllegalArgumentException {
        if (templateVariableToValue == null) {
            throw new IllegalArgumentException();
        }
        return this.pattern.match(uri, this.templateVariables, templateVariableToValue);
    }

    public final boolean match(CharSequence uri, List<String> groupValues) throws IllegalArgumentException {
        if (groupValues == null) {
            throw new IllegalArgumentException();
        }
        return this.pattern.match(uri, groupValues);
    }

    public final String createURI(Map<String, String> values2) {
        StringBuilder b = new StringBuilder();
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(this.normalizedTemplate);
        int i = 0;
        while (m.find()) {
            b.append(this.normalizedTemplate, i, m.start());
            String tValue = values2.get(m.group(1));
            if (tValue != null) {
                b.append(tValue);
            }
            i = m.end();
        }
        b.append(this.normalizedTemplate, i, this.normalizedTemplate.length());
        return b.toString();
    }

    public final String createURI(String ... values2) {
        return this.createURI(values2, 0, values2.length);
    }

    public final String createURI(String[] values2, int offset2, int length2) {
        HashMap<String, String> mapValues = new HashMap<String, String>();
        StringBuilder b = new StringBuilder();
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(this.normalizedTemplate);
        int v = offset2;
        length2 += offset2;
        int i = 0;
        while (m.find()) {
            b.append(this.normalizedTemplate, i, m.start());
            String tVariable = m.group(1);
            String tValue = (String)mapValues.get(tVariable);
            if (tValue != null) {
                b.append(tValue);
            } else if (v < length2 && (tValue = values2[v++]) != null) {
                mapValues.put(tVariable, tValue);
                b.append(tValue);
            }
            i = m.end();
        }
        b.append(this.normalizedTemplate, i, this.normalizedTemplate.length());
        return b.toString();
    }

    public final String toString() {
        return this.pattern.toString();
    }

    public final int hashCode() {
        return this.pattern.hashCode();
    }

    public final boolean equals(Object o) {
        if (o instanceof UriTemplate) {
            UriTemplate that = (UriTemplate)o;
            return this.pattern.equals(that.pattern);
        }
        return false;
    }

    public static final String createURI(String scheme, String userInfo, String host, String port, String path2, String query2, String fragment, Map<String, ? extends Object> values2, boolean encode2) {
        return UriTemplate.createURI(scheme, null, userInfo, host, port, path2, query2, fragment, values2, encode2);
    }

    public static final String createURI(String scheme, String authority, String userInfo, String host, String port, String path2, String query2, String fragment, Map<String, ? extends Object> values2, boolean encode2) {
        HashMap<String, String> stringValues = new HashMap<String, String>();
        for (Map.Entry<String, ? extends Object> e2 : values2.entrySet()) {
            if (e2.getValue() == null) continue;
            stringValues.put(e2.getKey(), e2.getValue().toString());
        }
        return UriTemplate.createURIWithStringValues(scheme, authority, userInfo, host, port, path2, query2, fragment, stringValues, encode2);
    }

    public static final String createURIWithStringValues(String scheme, String userInfo, String host, String port, String path2, String query2, String fragment, Map<String, ? extends Object> values2, boolean encode2) {
        return UriTemplate.createURIWithStringValues(scheme, null, userInfo, host, port, path2, query2, fragment, values2, encode2);
    }

    public static final String createURIWithStringValues(String scheme, String authority, String userInfo, String host, String port, String path2, String query2, String fragment, Map<String, ? extends Object> values2, boolean encode2) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            UriTemplate.createURIComponent(UriComponent.Type.SCHEME, scheme, values2, false, sb).append(':');
        }
        if (userInfo != null || host != null || port != null) {
            sb.append("//");
            if (userInfo != null && userInfo.length() > 0) {
                UriTemplate.createURIComponent(UriComponent.Type.USER_INFO, userInfo, values2, encode2, sb).append('@');
            }
            if (host != null) {
                UriTemplate.createURIComponent(UriComponent.Type.HOST, host, values2, encode2, sb);
            }
            if (port != null && port.length() > 0) {
                sb.append(':');
                UriTemplate.createURIComponent(UriComponent.Type.PORT, port, values2, false, sb);
            }
        } else if (authority != null) {
            sb.append("//");
            UriTemplate.createURIComponent(UriComponent.Type.AUTHORITY, authority, values2, encode2, sb);
        }
        if (path2 != null) {
            UriTemplate.createURIComponent(UriComponent.Type.PATH, path2, values2, encode2, sb);
        }
        if (query2 != null && query2.length() > 0) {
            sb.append('?');
            UriTemplate.createURIComponent(UriComponent.Type.QUERY_PARAM, query2, values2, encode2, sb);
        }
        if (fragment != null && fragment.length() > 0) {
            sb.append('#');
            UriTemplate.createURIComponent(UriComponent.Type.FRAGMENT, fragment, values2, encode2, sb);
        }
        return sb.toString();
    }

    private static StringBuilder createURIComponent(UriComponent.Type t2, String template, Map<String, ? extends Object> values2, boolean encode2, StringBuilder b) {
        if (template.indexOf(123) == -1) {
            b.append(template);
            return b;
        }
        template = new UriTemplateParser(template).getNormalizedTemplate();
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(template);
        int i = 0;
        while (m.find()) {
            b.append(template, i, m.start());
            Object tValue = values2.get(m.group(1));
            if (tValue == null) {
                throw UriTemplate.templateVariableHasNoValue(m.group(1));
            }
            tValue = encode2 ? UriComponent.encode(tValue.toString(), t2) : UriComponent.contextualEncode(tValue.toString(), t2);
            b.append(tValue);
            i = m.end();
        }
        b.append(template, i, template.length());
        return b;
    }

    public static final String createURI(String scheme, String userInfo, String host, String port, String path2, String query2, String fragment, Object[] values2, boolean encode2) {
        return UriTemplate.createURI(scheme, null, userInfo, host, port, path2, query2, fragment, values2, encode2);
    }

    public static final String createURI(String scheme, String authority, String userInfo, String host, String port, String path2, String query2, String fragment, Object[] values2, boolean encode2) {
        String[] stringValues = new String[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            if (values2[i] == null) continue;
            stringValues[i] = values2[i].toString();
        }
        return UriTemplate.createURIWithStringValues(scheme, authority, userInfo, host, port, path2, query2, fragment, stringValues, encode2);
    }

    public static final String createURIWithStringValues(String scheme, String userInfo, String host, String port, String path2, String query2, String fragment, String[] values2, boolean encode2) {
        return UriTemplate.createURIWithStringValues(scheme, null, userInfo, host, port, path2, query2, fragment, values2, encode2);
    }

    public static final String createURIWithStringValues(String scheme, String authority, String userInfo, String host, String port, String path2, String query2, String fragment, String[] values2, boolean encode2) {
        HashMap<String, String> mapValues = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        int offset2 = 0;
        if (scheme != null) {
            offset2 = UriTemplate.createURIComponent(UriComponent.Type.SCHEME, scheme, values2, offset2, false, mapValues, sb);
            sb.append(':');
        }
        if (userInfo != null || host != null || port != null) {
            sb.append("//");
            if (userInfo != null && userInfo.length() > 0) {
                offset2 = UriTemplate.createURIComponent(UriComponent.Type.USER_INFO, userInfo, values2, offset2, encode2, mapValues, sb);
                sb.append('@');
            }
            if (host != null) {
                offset2 = UriTemplate.createURIComponent(UriComponent.Type.HOST, host, values2, offset2, encode2, mapValues, sb);
            }
            if (port != null && port.length() > 0) {
                sb.append(':');
                offset2 = UriTemplate.createURIComponent(UriComponent.Type.PORT, port, values2, offset2, false, mapValues, sb);
            }
        } else if (authority != null) {
            sb.append("//");
            offset2 = UriTemplate.createURIComponent(UriComponent.Type.AUTHORITY, authority, values2, offset2, encode2, mapValues, sb);
        }
        if (path2 != null) {
            offset2 = UriTemplate.createURIComponent(UriComponent.Type.PATH, path2, values2, offset2, encode2, mapValues, sb);
        }
        if (query2 != null && query2.length() > 0) {
            sb.append('?');
            offset2 = UriTemplate.createURIComponent(UriComponent.Type.QUERY_PARAM, query2, values2, offset2, encode2, mapValues, sb);
        }
        if (fragment != null && fragment.length() > 0) {
            sb.append('#');
            offset2 = UriTemplate.createURIComponent(UriComponent.Type.FRAGMENT, fragment, values2, offset2, encode2, mapValues, sb);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int createURIComponent(UriComponent.Type t2, String template, String[] values2, int offset2, boolean encode2, Map<String, String> mapValues, StringBuilder b) {
        if (template.indexOf(123) == -1) {
            b.append(template);
            return offset2;
        }
        template = new UriTemplateParser(template).getNormalizedTemplate();
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(template);
        int v = offset2;
        int i = 0;
        while (m.find()) {
            b.append(template, i, m.start());
            String tVariable = m.group(1);
            String tValue = mapValues.get(tVariable);
            if (tValue != null) {
                b.append(tValue);
            } else {
                if (v >= values2.length) throw UriTemplate.templateVariableHasNoValue(tVariable);
                if ((tValue = values2[v++]) == null) throw UriTemplate.templateVariableHasNoValue(tVariable);
                tValue = encode2 ? UriComponent.encode(tValue, t2) : UriComponent.contextualEncode(tValue, t2);
                mapValues.put(tVariable, tValue);
                b.append(tValue);
            }
            i = m.end();
        }
        b.append(template, i, template.length());
        return v;
    }

    private static IllegalArgumentException templateVariableHasNoValue(String tVariable) {
        return new IllegalArgumentException("The template variable, " + tVariable + ", has no value");
    }
}

