/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class CopyOnWriteHashMap<K, V>
implements Map<K, V> {
    private volatile Map<K, V> core;
    private volatile Map<K, V> view;
    private final AtomicBoolean requiresCopyOnWrite;

    public CopyOnWriteHashMap() {
        this.core = new HashMap();
        this.requiresCopyOnWrite = new AtomicBoolean(false);
    }

    private CopyOnWriteHashMap(CopyOnWriteHashMap<K, V> that) {
        this.core = that.core;
        this.requiresCopyOnWrite = new AtomicBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyOnWriteHashMap<K, V> clone() {
        try {
            CopyOnWriteHashMap<K, V> copyOnWriteHashMap = new CopyOnWriteHashMap<K, V>(this);
            return copyOnWriteHashMap;
        }
        finally {
            this.requiresCopyOnWrite.set(true);
        }
    }

    private void copy() {
        if (this.requiresCopyOnWrite.compareAndSet(true, false)) {
            this.core = new HashMap<K, V>(this.core);
            this.view = null;
        }
    }

    @Override
    public int size() {
        return this.core.size();
    }

    @Override
    public boolean isEmpty() {
        return this.core.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.core.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.core.containsValue(value2);
    }

    @Override
    public V get(Object key) {
        return this.core.get(key);
    }

    @Override
    public V put(K key, V value2) {
        this.copy();
        return this.core.put(key, value2);
    }

    @Override
    public V remove(Object key) {
        this.copy();
        return this.core.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t2) {
        this.copy();
        this.core.putAll(t2);
    }

    @Override
    public void clear() {
        this.core = new HashMap();
        this.copy();
    }

    @Override
    public Set<K> keySet() {
        return this.getView().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getView().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getView().entrySet();
    }

    public String toString() {
        return this.core.toString();
    }

    private Map<K, V> getView() {
        if (this.view == null) {
            this.view = Collections.unmodifiableMap(this.core);
        }
        return this.view;
    }
}

