/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.header;

import com.sun.jersey.core.header.reader.HttpHeaderReader;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;

public class ParameterizedHeader {
    private String value;
    private Map<String, String> parameters;

    public ParameterizedHeader(String header) throws ParseException {
        this(HttpHeaderReader.newInstance(header));
    }

    public ParameterizedHeader(HttpHeaderReader reader2) throws ParseException {
        reader2.hasNext();
        this.value = "";
        while (reader2.hasNext() && !reader2.hasNextSeparator(';', false)) {
            reader2.next();
            this.value = this.value + reader2.getEventValue();
        }
        if (reader2.hasNext()) {
            this.parameters = HttpHeaderReader.readParameters(reader2);
        }
        this.parameters = this.parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.parameters);
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

