/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.header;

import com.sun.jersey.core.header.reader.HttpHeaderReader;
import java.text.ParseException;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class QualitySourceMediaType
extends MediaType {
    public static final String QUALITY_SOURCE_FACTOR = "qs";
    public static final int DEFAULT_QUALITY_SOURCE_FACTOR = 1000;
    private final int qs;

    public QualitySourceMediaType(String p, String s2) {
        super(p, s2);
        this.qs = 1000;
    }

    public QualitySourceMediaType(String p, String s2, int qs2, Map<String, String> parameters2) {
        super(p, s2, parameters2);
        this.qs = qs2;
    }

    public QualitySourceMediaType(MediaType mt) {
        this(mt.getType(), mt.getSubtype(), QualitySourceMediaType.getQs(mt), mt.getParameters());
    }

    public int getQualitySource() {
        return this.qs;
    }

    public static QualitySourceMediaType valueOf(HttpHeaderReader reader2) throws ParseException {
        reader2.hasNext();
        String type = reader2.nextToken();
        reader2.nextSeparator('/');
        String subType = reader2.nextToken();
        int qs2 = 1000;
        Map<String, String> parameters2 = null;
        if (reader2.hasNext() && (parameters2 = HttpHeaderReader.readParameters(reader2)) != null) {
            qs2 = QualitySourceMediaType.getQs(parameters2.get(QUALITY_SOURCE_FACTOR));
        }
        return new QualitySourceMediaType(type, subType, qs2, parameters2);
    }

    public static int getQualitySource(MediaType mt) {
        if (mt instanceof QualitySourceMediaType) {
            QualitySourceMediaType qsmt = (QualitySourceMediaType)mt;
            return qsmt.getQualitySource();
        }
        return QualitySourceMediaType.getQs(mt);
    }

    private static int getQs(MediaType mt) {
        try {
            return QualitySourceMediaType.getQs(mt.getParameters().get(QUALITY_SOURCE_FACTOR));
        }
        catch (ParseException ex2) {
            throw new IllegalArgumentException(ex2);
        }
    }

    private static int getQs(String v) throws ParseException {
        if (v == null) {
            return 1000;
        }
        try {
            int qs2 = (int)((double)Float.valueOf(v).floatValue() * 1000.0);
            if (qs2 < 0) {
                throw new ParseException("The quality source (qs) value, " + v + ", must be non-negative number", 0);
            }
            return qs2;
        }
        catch (NumberFormatException ex2) {
            ParseException pe = new ParseException("The quality source (qs) value, " + v + ", is not a valid value", 0);
            pe.initCause(ex2);
            throw pe;
        }
    }
}

