/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.header.reader;

import com.sun.jersey.core.header.AcceptableLanguageTag;
import com.sun.jersey.core.header.AcceptableMediaType;
import com.sun.jersey.core.header.AcceptableToken;
import com.sun.jersey.core.header.HttpDateFormat;
import com.sun.jersey.core.header.MatchingEntityTag;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.core.header.QualityFactor;
import com.sun.jersey.core.header.QualitySourceMediaType;
import com.sun.jersey.core.header.reader.CookiesParser;
import com.sun.jersey.core.header.reader.HttpHeaderListAdapter;
import com.sun.jersey.core.header.reader.HttpHeaderReaderImpl;
import com.sun.jersey.core.impl.provider.header.MediaTypeProvider;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;

public abstract class HttpHeaderReader {
    private static final ListElementCreator<MatchingEntityTag> MATCHING_ENTITY_TAG_CREATOR = new ListElementCreator<MatchingEntityTag>(){

        @Override
        public MatchingEntityTag create(HttpHeaderReader reader2) throws ParseException {
            return MatchingEntityTag.valueOf(reader2);
        }
    };
    private static final ListElementCreator<MediaType> MEDIA_TYPE_CREATOR = new ListElementCreator<MediaType>(){

        @Override
        public MediaType create(HttpHeaderReader reader2) throws ParseException {
            return MediaTypeProvider.valueOf(reader2);
        }
    };
    private static final ListElementCreator<AcceptableMediaType> ACCEPTABLE_MEDIA_TYPE_CREATOR = new ListElementCreator<AcceptableMediaType>(){

        @Override
        public AcceptableMediaType create(HttpHeaderReader reader2) throws ParseException {
            return AcceptableMediaType.valueOf(reader2);
        }
    };
    private static final Comparator<AcceptableMediaType> ACCEPTABLE_MEDIA_TYPE_COMPARATOR = new Comparator<AcceptableMediaType>(){

        @Override
        public int compare(AcceptableMediaType o1, AcceptableMediaType o2) {
            int i = o2.getQuality() - o1.getQuality();
            if (i != 0) {
                return i;
            }
            return MediaTypes.MEDIA_TYPE_COMPARATOR.compare(o1, o2);
        }
    };
    private static final ListElementCreator<QualitySourceMediaType> QUALITY_SOURCE_MEDIA_TYPE_CREATOR = new ListElementCreator<QualitySourceMediaType>(){

        @Override
        public QualitySourceMediaType create(HttpHeaderReader reader2) throws ParseException {
            return QualitySourceMediaType.valueOf(reader2);
        }
    };
    private static final ListElementCreator<AcceptableToken> ACCEPTABLE_TOKEN_CREATOR = new ListElementCreator<AcceptableToken>(){

        @Override
        public AcceptableToken create(HttpHeaderReader reader2) throws ParseException {
            return new AcceptableToken(reader2);
        }
    };
    private static final ListElementCreator<AcceptableLanguageTag> LANGUAGE_CREATOR = new ListElementCreator<AcceptableLanguageTag>(){

        @Override
        public AcceptableLanguageTag create(HttpHeaderReader reader2) throws ParseException {
            return new AcceptableLanguageTag(reader2);
        }
    };
    private static final Comparator<QualityFactor> QUALITY_COMPARATOR = new Comparator<QualityFactor>(){

        @Override
        public int compare(QualityFactor o1, QualityFactor o2) {
            return o2.getQuality() - o1.getQuality();
        }
    };

    public abstract boolean hasNext();

    public abstract boolean hasNextSeparator(char var1, boolean var2);

    public abstract Event next() throws ParseException;

    public abstract Event next(boolean var1) throws ParseException;

    public abstract String nextSeparatedString(char var1, char var2) throws ParseException;

    public abstract Event getEvent();

    public abstract String getEventValue();

    public abstract String getRemainder();

    public abstract int getIndex();

    public String nextToken() throws ParseException {
        Event e2 = this.next(false);
        if (e2 != Event.Token) {
            throw new ParseException("Next event is not a Token", this.getIndex());
        }
        return this.getEventValue();
    }

    public char nextSeparator() throws ParseException {
        Event e2 = this.next(false);
        if (e2 != Event.Separator) {
            throw new ParseException("Next event is not a Separator", this.getIndex());
        }
        return this.getEventValue().charAt(0);
    }

    public void nextSeparator(char c2) throws ParseException {
        Event e2 = this.next(false);
        if (e2 != Event.Separator) {
            throw new ParseException("Next event is not a Separator", this.getIndex());
        }
        if (c2 != this.getEventValue().charAt(0)) {
            throw new ParseException("Expected separator '" + c2 + "' instead of '" + this.getEventValue().charAt(0) + "'", this.getIndex());
        }
    }

    public String nextQuotedString() throws ParseException {
        Event e2 = this.next(false);
        if (e2 != Event.QuotedString) {
            throw new ParseException("Next event is not a Quoted String", this.getIndex());
        }
        return this.getEventValue();
    }

    public String nextTokenOrQuotedString() throws ParseException {
        Event e2 = this.next(false);
        if (e2 != Event.Token && e2 != Event.QuotedString) {
            throw new ParseException("Next event is not a Token or a Quoted String, " + this.getEventValue(), this.getIndex());
        }
        return this.getEventValue();
    }

    public static HttpHeaderReader newInstance(String header) {
        return new HttpHeaderReaderImpl(header);
    }

    public static HttpHeaderReader newInstance(String header, boolean processComments) {
        return new HttpHeaderReaderImpl(header, processComments);
    }

    public static Date readDate(String date) throws ParseException {
        return HttpDateFormat.readDate(date);
    }

    public static int readQualityFactor(String q) throws ParseException {
        char wholeNumber;
        char c2;
        if (q == null || q.length() == 0) {
            throw new ParseException("Quality value cannot be null or an empty String", 0);
        }
        int index2 = 0;
        int length2 = q.length();
        if (length2 > 5) {
            throw new ParseException("Quality value is greater than the maximum length, 5", 0);
        }
        if ((c2 = (wholeNumber = q.charAt(index2++))) == '0' || c2 == '1') {
            if (index2 == length2) {
                return (c2 - 48) * 1000;
            }
            if ((c2 = q.charAt(index2++)) != '.') {
                throw new ParseException("Error parsing Quality value: a decimal place is expected rather than '" + c2 + "'", index2);
            }
            if (index2 == length2) {
                return (c2 - 48) * 1000;
            }
        } else if (c2 == '.') {
            if (index2 == length2) {
                throw new ParseException("Error parsing Quality value: a decimal numeral is expected after the decimal point", index2);
            }
        } else {
            throw new ParseException("Error parsing Quality value: a decimal numeral '0' or '1' is expected rather than '" + c2 + "'", index2);
        }
        int value2 = 0;
        int exponent2 = 100;
        while (index2 < length2) {
            if ((c2 = q.charAt(index2++)) >= '0' && c2 <= '9') {
                value2 += (c2 - 48) * exponent2;
                exponent2 /= 10;
                continue;
            }
            throw new ParseException("Error parsing Quality value: a decimal numeral is expected rather than '" + c2 + "'", index2);
        }
        if (wholeNumber == '1') {
            if (value2 > 0) {
                throw new ParseException("The Quality value, " + q + ", is greater than 1", index2);
            }
            return 1000;
        }
        return value2;
    }

    public static int readQualityFactorParameter(HttpHeaderReader reader2) throws ParseException {
        int q = -1;
        while (reader2.hasNext()) {
            reader2.nextSeparator(';');
            if (!reader2.hasNext()) {
                return 1000;
            }
            String name = reader2.nextToken();
            reader2.nextSeparator('=');
            String value2 = reader2.nextTokenOrQuotedString();
            if (q != -1 || !name.equalsIgnoreCase("q")) continue;
            q = HttpHeaderReader.readQualityFactor(value2);
        }
        return q == -1 ? 1000 : q;
    }

    public static Map<String, String> readParameters(HttpHeaderReader reader2) throws ParseException {
        LinkedHashMap<String, String> m = null;
        while (reader2.hasNext()) {
            reader2.nextSeparator(';');
            while (reader2.hasNextSeparator(';', true)) {
                reader2.next();
            }
            if (!reader2.hasNext()) break;
            String name = reader2.nextToken();
            reader2.nextSeparator('=');
            String value2 = reader2.nextTokenOrQuotedString();
            if (m == null) {
                m = new LinkedHashMap<String, String>();
            }
            m.put(name.toLowerCase(), value2);
        }
        return m;
    }

    public static Map<String, Cookie> readCookies(String header) {
        return CookiesParser.parseCookies(header);
    }

    public static Cookie readCookie(String header) {
        return CookiesParser.parseCookie(header);
    }

    public static NewCookie readNewCookie(String header) {
        return CookiesParser.parseNewCookie(header);
    }

    public static Set<MatchingEntityTag> readMatchingEntityTag(String header) throws ParseException {
        if (header.equals("*")) {
            return MatchingEntityTag.ANY_MATCH;
        }
        HttpHeaderReaderImpl reader2 = new HttpHeaderReaderImpl(header);
        HashSet<MatchingEntityTag> l = new HashSet<MatchingEntityTag>(1);
        HttpHeaderListAdapter adapter = new HttpHeaderListAdapter(reader2);
        while (((HttpHeaderReader)reader2).hasNext()) {
            l.add(MATCHING_ENTITY_TAG_CREATOR.create(adapter));
            adapter.reset();
            if (!((HttpHeaderReader)reader2).hasNext()) continue;
            ((HttpHeaderReader)reader2).next();
        }
        return l;
    }

    public static List<MediaType> readMediaTypes(List<MediaType> l, String header) throws ParseException {
        return HttpHeaderReader.readList(l, MEDIA_TYPE_CREATOR, header);
    }

    public static List<AcceptableMediaType> readAcceptMediaType(String header) throws ParseException {
        return HttpHeaderReader.readAcceptableList(ACCEPTABLE_MEDIA_TYPE_COMPARATOR, ACCEPTABLE_MEDIA_TYPE_CREATOR, header);
    }

    public static List<QualitySourceMediaType> readQualitySourceMediaType(String header) throws ParseException {
        return HttpHeaderReader.readAcceptableList(MediaTypes.QUALITY_SOURCE_MEDIA_TYPE_COMPARATOR, QUALITY_SOURCE_MEDIA_TYPE_CREATOR, header);
    }

    public static List<QualitySourceMediaType> readQualitySourceMediaType(String[] header) throws ParseException {
        if (header.length < 2) {
            return HttpHeaderReader.readQualitySourceMediaType(header[0]);
        }
        StringBuffer sb = new StringBuffer();
        for (String h : header) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(h);
        }
        return HttpHeaderReader.readQualitySourceMediaType(sb.toString());
    }

    public static List<AcceptableMediaType> readAcceptMediaType(String header, final List<QualitySourceMediaType> priorityMediaTypes) throws ParseException {
        return HttpHeaderReader.readAcceptableList(new Comparator<AcceptableMediaType>(){

            @Override
            public int compare(AcceptableMediaType o1, AcceptableMediaType o2) {
                boolean q_o1_set = false;
                int q_o1 = 1000000;
                boolean q_o2_set = false;
                int q_o2 = 1000000;
                for (QualitySourceMediaType m : priorityMediaTypes) {
                    if (!q_o1_set && MediaTypes.typeEquals(o1, m)) {
                        q_o1 = o1.getQuality() * m.getQualitySource();
                        q_o1_set = true;
                        continue;
                    }
                    if (q_o2_set || !MediaTypes.typeEquals(o2, m)) continue;
                    q_o2 = o2.getQuality() * m.getQualitySource();
                    q_o2_set = true;
                }
                int i = q_o2 - q_o1;
                if (i != 0) {
                    return i;
                }
                i = o2.getQuality() - o1.getQuality();
                if (i != 0) {
                    return i;
                }
                return MediaTypes.MEDIA_TYPE_COMPARATOR.compare(o1, o2);
            }
        }, ACCEPTABLE_MEDIA_TYPE_CREATOR, header);
    }

    public static List<AcceptableToken> readAcceptToken(String header) throws ParseException {
        return HttpHeaderReader.readAcceptableList(ACCEPTABLE_TOKEN_CREATOR, header);
    }

    public static List<AcceptableLanguageTag> readAcceptLanguage(String header) throws ParseException {
        return HttpHeaderReader.readAcceptableList(LANGUAGE_CREATOR, header);
    }

    public static <T extends QualityFactor> List<T> readAcceptableList(ListElementCreator<T> c2, String header) throws ParseException {
        List<T> l = HttpHeaderReader.readList(c2, header);
        Collections.sort(l, QUALITY_COMPARATOR);
        return l;
    }

    public static <T> List<T> readAcceptableList(Comparator<T> comparator, ListElementCreator<T> c2, String header) throws ParseException {
        List<T> l = HttpHeaderReader.readList(c2, header);
        Collections.sort(l, comparator);
        return l;
    }

    public static <T> List<T> readList(ListElementCreator<T> c2, String header) throws ParseException {
        return HttpHeaderReader.readList(new ArrayList(), c2, header);
    }

    public static <T> List<T> readList(List<T> l, ListElementCreator<T> c2, String header) throws ParseException {
        HttpHeaderReaderImpl reader2 = new HttpHeaderReaderImpl(header);
        HttpHeaderListAdapter adapter = new HttpHeaderListAdapter(reader2);
        while (((HttpHeaderReader)reader2).hasNext()) {
            l.add(c2.create(adapter));
            adapter.reset();
            if (!((HttpHeaderReader)reader2).hasNext()) continue;
            ((HttpHeaderReader)reader2).next();
        }
        return l;
    }

    public static interface ListElementCreator<T> {
        public T create(HttpHeaderReader var1) throws ParseException;
    }

    public static enum Event {
        Token,
        QuotedString,
        Comment,
        Separator,
        Control;

    }
}

