/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.header.reader;

import com.sun.jersey.core.header.reader.HttpHeaderReader;
import java.text.ParseException;

final class HttpHeaderReaderImpl
extends HttpHeaderReader {
    private static final int TOKEN = 0;
    private static final int QUOTED_STRING = 1;
    private static final int COMMENT = 2;
    private static final int SEPARATOR = 3;
    private static final int CONTROL = 4;
    private static final char[] WHITE_SPACE = new char[]{'\t', '\r', '\n', ' '};
    private static final char[] SEPARATORS = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'};
    private static final int[] EVENT_TABLE = HttpHeaderReaderImpl.createEventTable();
    private static final boolean[] IS_WHITE_SPACE = HttpHeaderReaderImpl.createWhiteSpaceTable();
    private static final boolean[] IS_TOKEN = HttpHeaderReaderImpl.createTokenTable();
    private String header;
    private boolean processComments;
    private int index;
    private int length;
    private HttpHeaderReader.Event event;
    private String value;

    private static int[] createEventTable() {
        int[] table2 = new int[128];
        for (int i = 0; i < 127; ++i) {
            table2[i] = 0;
        }
        for (char c2 : SEPARATORS) {
            table2[c2] = 3;
        }
        table2[40] = 2;
        table2[34] = 1;
        for (int i = 0; i < 32; ++i) {
            table2[i] = 4;
        }
        table2[127] = 4;
        for (char c2 : WHITE_SPACE) {
            table2[c2] = -1;
        }
        return table2;
    }

    private static boolean[] createWhiteSpaceTable() {
        boolean[] table2 = new boolean[128];
        for (char c2 : WHITE_SPACE) {
            table2[c2] = true;
        }
        return table2;
    }

    private static boolean[] createTokenTable() {
        boolean[] table2 = new boolean[128];
        for (int i = 0; i < 128; ++i) {
            table2[i] = EVENT_TABLE[i] == 0;
        }
        return table2;
    }

    public HttpHeaderReaderImpl(String header, boolean processComments) {
        this.header = header == null ? "" : header;
        this.processComments = processComments;
        this.index = 0;
        this.length = this.header.length();
    }

    public HttpHeaderReaderImpl(String header) {
        this(header, false);
    }

    @Override
    public boolean hasNext() {
        return this.skipWhiteSpace();
    }

    @Override
    public boolean hasNextSeparator(char separator, boolean skipWhiteSpace) {
        if (skipWhiteSpace) {
            this.skipWhiteSpace();
        }
        if (this.index >= this.length) {
            return false;
        }
        char c2 = this.header.charAt(this.index);
        return EVENT_TABLE[c2] == 3 ? c2 == separator : false;
    }

    @Override
    public String nextSeparatedString(char startSeparator, char endSeparator) throws ParseException {
        this.nextSeparator(startSeparator);
        int start2 = this.index;
        while (this.index < this.length && this.header.charAt(this.index) != endSeparator) {
            ++this.index;
        }
        if (start2 == this.index) {
            throw new ParseException("No characters between the separators '" + startSeparator + "' and '" + endSeparator + "'", this.index);
        }
        if (this.index == this.length) {
            throw new ParseException("No end separator '" + endSeparator + "'", this.index);
        }
        this.event = HttpHeaderReader.Event.Token;
        this.value = this.header.substring(start2, this.index++);
        return this.value;
    }

    @Override
    public HttpHeaderReader.Event next() throws ParseException {
        this.event = this.process(this.getNextCharacter(true));
        return this.event;
    }

    @Override
    public HttpHeaderReader.Event next(boolean skipWhiteSpace) throws ParseException {
        this.event = this.process(this.getNextCharacter(skipWhiteSpace));
        return this.event;
    }

    @Override
    public HttpHeaderReader.Event getEvent() {
        return this.event;
    }

    @Override
    public String getEventValue() {
        return this.value;
    }

    @Override
    public String getRemainder() {
        return this.index < this.length ? this.header.substring(this.index) : null;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    private boolean skipWhiteSpace() {
        while (this.index < this.length) {
            if (!this.isWhiteSpace(this.header.charAt(this.index))) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    private char getNextCharacter(boolean skipWhiteSpace) throws ParseException {
        if (skipWhiteSpace) {
            this.skipWhiteSpace();
        }
        if (this.index >= this.length) {
            throw new ParseException("End of header", this.index);
        }
        return this.header.charAt(this.index);
    }

    private HttpHeaderReader.Event process(char c2) throws ParseException {
        if (c2 > '\u007f') {
            ++this.index;
            return HttpHeaderReader.Event.Control;
        }
        switch (EVENT_TABLE[c2]) {
            case 0: {
                int start2 = this.index++;
                while (this.index < this.length && this.isToken(this.header.charAt(this.index))) {
                    ++this.index;
                }
                this.value = this.header.substring(start2, this.index);
                return HttpHeaderReader.Event.Token;
            }
            case 1: {
                this.processQuotedString();
                return HttpHeaderReader.Event.QuotedString;
            }
            case 2: {
                if (!this.processComments) {
                    throw new ParseException("Comments are not allowed", this.index);
                }
                this.processComment();
                return HttpHeaderReader.Event.Comment;
            }
            case 3: {
                ++this.index;
                this.value = String.valueOf(c2);
                return HttpHeaderReader.Event.Separator;
            }
            case 4: {
                ++this.index;
                this.value = String.valueOf(c2);
                return HttpHeaderReader.Event.Control;
            }
        }
        throw new ParseException("White space not allowed", this.index);
    }

    private void processComment() throws ParseException {
        boolean filter2 = false;
        int start2 = ++this.index;
        int nesting = 1;
        while (nesting > 0 && this.index < this.length) {
            char c2 = this.header.charAt(this.index);
            if (c2 == '\\') {
                ++this.index;
                filter2 = true;
            } else if (c2 == '\r') {
                filter2 = true;
            } else if (c2 == '(') {
                ++nesting;
            } else if (c2 == ')') {
                --nesting;
            }
            ++this.index;
        }
        if (nesting != 0) {
            throw new ParseException("Unbalanced comments", this.index);
        }
        this.value = filter2 ? HttpHeaderReaderImpl.filterToken(this.header, start2, this.index - 1) : this.header.substring(start2, this.index - 1);
    }

    private void processQuotedString() throws ParseException {
        boolean filter2 = false;
        int start2 = ++this.index;
        while (this.index < this.length) {
            char c2 = this.header.charAt(this.index);
            if (c2 == '\\') {
                ++this.index;
                filter2 = true;
            } else if (c2 == '\r') {
                filter2 = true;
            } else if (c2 == '\"') {
                this.value = filter2 ? HttpHeaderReaderImpl.filterToken(this.header, start2, this.index) : this.header.substring(start2, this.index);
                ++this.index;
                return;
            }
            ++this.index;
        }
        throw new ParseException("Unbalanced quoted string", this.index);
    }

    private boolean isWhiteSpace(char c2) {
        return c2 < '\u0080' && IS_WHITE_SPACE[c2];
    }

    private boolean isToken(char c2) {
        return c2 < '\u0080' && IS_TOKEN[c2];
    }

    private static String filterToken(String s2, int start2, int end2) {
        StringBuffer sb = new StringBuffer();
        boolean gotEscape = false;
        boolean gotCR = false;
        for (int i = start2; i < end2; ++i) {
            char c2 = s2.charAt(i);
            if (c2 == '\n' && gotCR) {
                gotCR = false;
                continue;
            }
            gotCR = false;
            if (!gotEscape) {
                if (c2 == '\\') {
                    gotEscape = true;
                    continue;
                }
                if (c2 == '\r') {
                    gotCR = true;
                    continue;
                }
                sb.append(c2);
                continue;
            }
            sb.append(c2);
            gotEscape = false;
        }
        return sb.toString();
    }
}

