/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.entity;

import com.sun.jersey.core.provider.AbstractMessageReaderWriterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import javax.mail.util.ByteArrayDataSource;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public final class MimeMultipartProvider
extends AbstractMessageReaderWriterProvider<MimeMultipart> {
    public MimeMultipartProvider() {
        Class<MimeMultipart> c2 = MimeMultipart.class;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations2, MediaType mediaType) {
        return type == MimeMultipart.class;
    }

    @Override
    public MimeMultipart readFrom(Class<MimeMultipart> type, Type genericType, Annotation[] annotations2, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        if (mediaType == null) {
            mediaType = new MediaType("multipart", "form-data");
        }
        ByteArrayDataSource ds = new ByteArrayDataSource(entityStream, mediaType.toString());
        try {
            return new MimeMultipart(ds);
        }
        catch (ParseException ex2) {
            throw new WebApplicationException((Throwable)ex2, Response.Status.BAD_REQUEST);
        }
        catch (MessagingException ex3) {
            throw new WebApplicationException((Throwable)ex3, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations2, MediaType mediaType) {
        return type == MimeMultipart.class;
    }

    @Override
    public void writeTo(MimeMultipart t2, Class<?> type, Type genericType, Annotation[] annotations2, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            t2.writeTo(entityStream);
        }
        catch (MessagingException ex2) {
            throw new WebApplicationException((Throwable)ex2, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

