/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.header;

import com.sun.jersey.core.header.reader.HttpHeaderReader;
import com.sun.jersey.spi.HeaderDelegateProvider;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.CacheControl;

public final class CacheControlProvider
implements HeaderDelegateProvider<CacheControl> {
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    private static final Pattern COMMA_SEPARATED_LIST = Pattern.compile("[\\s]*,[\\s]*");

    @Override
    public boolean supports(Class<?> type) {
        return type == CacheControl.class;
    }

    @Override
    public String toString(CacheControl header) {
        StringBuffer b = new StringBuffer();
        if (header.isPrivate()) {
            this.appendQuotedWithSeparator(b, "private", this.buildListValue(header.getPrivateFields()));
        }
        if (header.isNoCache()) {
            this.appendQuotedWithSeparator(b, "no-cache", this.buildListValue(header.getNoCacheFields()));
        }
        if (header.isNoStore()) {
            this.appendWithSeparator(b, "no-store");
        }
        if (header.isNoTransform()) {
            this.appendWithSeparator(b, "no-transform");
        }
        if (header.isMustRevalidate()) {
            this.appendWithSeparator(b, "must-revalidate");
        }
        if (header.isProxyRevalidate()) {
            this.appendWithSeparator(b, "proxy-revalidate");
        }
        if (header.getMaxAge() != -1) {
            this.appendWithSeparator(b, "max-age", header.getMaxAge());
        }
        if (header.getSMaxAge() != -1) {
            this.appendWithSeparator(b, "s-maxage", header.getSMaxAge());
        }
        for (Map.Entry<String, String> e2 : header.getCacheExtension().entrySet()) {
            this.appendWithSeparator(b, e2.getKey(), this.quoteIfWhitespace(e2.getValue()));
        }
        return b.toString();
    }

    private void readFieldNames(List<String> fieldNames, HttpHeaderReader reader2, String directiveName) throws ParseException {
        if (!reader2.hasNextSeparator('=', false)) {
            return;
        }
        reader2.nextSeparator('=');
        fieldNames.addAll(Arrays.asList(COMMA_SEPARATED_LIST.split(reader2.nextQuotedString())));
    }

    private int readIntValue(HttpHeaderReader reader2, String directiveName) throws ParseException {
        reader2.nextSeparator('=');
        int index2 = reader2.getIndex();
        try {
            return Integer.parseInt(reader2.nextToken());
        }
        catch (NumberFormatException nfe) {
            ParseException pe = new ParseException("Error parsing integer value for " + directiveName + " directive", index2);
            pe.initCause(nfe);
            throw pe;
        }
    }

    private void readDirective(CacheControl cacheControl, HttpHeaderReader reader2) throws ParseException {
        String directiveName = reader2.nextToken();
        if (directiveName.equalsIgnoreCase("private")) {
            cacheControl.setPrivate(true);
            this.readFieldNames(cacheControl.getPrivateFields(), reader2, directiveName);
        } else if (directiveName.equalsIgnoreCase("public")) {
            cacheControl.getCacheExtension().put(directiveName, null);
        } else if (directiveName.equalsIgnoreCase("no-cache")) {
            cacheControl.setNoCache(true);
            this.readFieldNames(cacheControl.getNoCacheFields(), reader2, directiveName);
        } else if (directiveName.equalsIgnoreCase("no-store")) {
            cacheControl.setNoStore(true);
        } else if (directiveName.equalsIgnoreCase("no-transform")) {
            cacheControl.setNoTransform(true);
        } else if (directiveName.equalsIgnoreCase("must-revalidate")) {
            cacheControl.setMustRevalidate(true);
        } else if (directiveName.equalsIgnoreCase("proxy-revalidate")) {
            cacheControl.setProxyRevalidate(true);
        } else if (directiveName.equalsIgnoreCase("max-age")) {
            cacheControl.setMaxAge(this.readIntValue(reader2, directiveName));
        } else if (directiveName.equalsIgnoreCase("s-maxage")) {
            cacheControl.setSMaxAge(this.readIntValue(reader2, directiveName));
        } else {
            String value2 = null;
            if (reader2.hasNextSeparator('=', false)) {
                reader2.nextSeparator('=');
                value2 = reader2.nextTokenOrQuotedString();
            }
            cacheControl.getCacheExtension().put(directiveName, value2);
        }
    }

    @Override
    public CacheControl fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException("Cache control is null");
        }
        try {
            HttpHeaderReader reader2 = HttpHeaderReader.newInstance(header);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoTransform(false);
            while (reader2.hasNext()) {
                this.readDirective(cacheControl, reader2);
                if (!reader2.hasNextSeparator(',', true)) continue;
                reader2.nextSeparator(',');
            }
            return cacheControl;
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Error parsing cache control '" + header + "'", pe);
        }
    }

    private void appendWithSeparator(StringBuffer b, String field2) {
        if (b.length() > 0) {
            b.append(", ");
        }
        b.append(field2);
    }

    private void appendQuotedWithSeparator(StringBuffer b, String field2, String value2) {
        this.appendWithSeparator(b, field2);
        if (value2 != null && value2.length() > 0) {
            b.append("=\"");
            b.append(value2);
            b.append("\"");
        }
    }

    private void appendWithSeparator(StringBuffer b, String field2, String value2) {
        this.appendWithSeparator(b, field2);
        if (value2 != null && value2.length() > 0) {
            b.append("=");
            b.append(value2);
        }
    }

    private void appendWithSeparator(StringBuffer b, String field2, int value2) {
        this.appendWithSeparator(b, field2);
        b.append("=");
        b.append(value2);
    }

    private String buildListValue(List<String> values2) {
        StringBuffer b = new StringBuffer();
        for (String value2 : values2) {
            this.appendWithSeparator(b, value2);
        }
        return b.toString();
    }

    private String quoteIfWhitespace(String value2) {
        if (value2 == null) {
            return null;
        }
        Matcher m = WHITESPACE.matcher(value2);
        if (m.find()) {
            return "\"" + value2 + "\"";
        }
        return value2;
    }
}

