/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.header;

import com.sun.jersey.core.header.reader.HttpHeaderReader;
import com.sun.jersey.core.impl.provider.header.WriterUtil;
import com.sun.jersey.spi.HeaderDelegateProvider;
import java.text.ParseException;
import javax.ws.rs.core.EntityTag;

public class EntityTagProvider
implements HeaderDelegateProvider<EntityTag> {
    @Override
    public boolean supports(Class<?> type) {
        return type == EntityTag.class;
    }

    @Override
    public String toString(EntityTag header) {
        StringBuilder b = new StringBuilder();
        if (header.isWeak()) {
            b.append("W/");
        }
        WriterUtil.appendQuoted(b, header.getValue());
        return b.toString();
    }

    @Override
    public EntityTag fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException("Entity tag is null");
        }
        try {
            HttpHeaderReader reader2 = HttpHeaderReader.newInstance(header);
            HttpHeaderReader.Event e2 = reader2.next(false);
            if (e2 == HttpHeaderReader.Event.QuotedString) {
                return new EntityTag(reader2.getEventValue());
            }
            if (e2 == HttpHeaderReader.Event.Token && reader2.getEventValue().equals("W")) {
                reader2.nextSeparator('/');
                return new EntityTag(reader2.nextQuotedString(), true);
            }
        }
        catch (ParseException ex2) {
            throw new IllegalArgumentException("Error parsing entity tag '" + header + "'", ex2);
        }
        throw new IllegalArgumentException("Error parsing entity tag '" + header + "'");
    }
}

