/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.header;

import com.sun.jersey.core.header.reader.HttpHeaderReader;
import com.sun.jersey.core.impl.provider.header.WriterUtil;
import com.sun.jersey.spi.HeaderDelegateProvider;
import java.text.ParseException;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class MediaTypeProvider
implements HeaderDelegateProvider<MediaType> {
    @Override
    public boolean supports(Class<?> type) {
        return MediaType.class.isAssignableFrom(type);
    }

    @Override
    public String toString(MediaType header) {
        StringBuilder b = new StringBuilder();
        b.append(header.getType()).append('/').append(header.getSubtype());
        for (Map.Entry<String, String> e2 : header.getParameters().entrySet()) {
            b.append("; ").append(e2.getKey()).append('=');
            WriterUtil.appendQuotedIfWhiteSpaceOrQuote(b, e2.getValue());
        }
        return b.toString();
    }

    @Override
    public MediaType fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException("Media type is null");
        }
        try {
            return MediaTypeProvider.valueOf(HttpHeaderReader.newInstance(header));
        }
        catch (ParseException ex2) {
            throw new IllegalArgumentException("Error parsing media type '" + header + "'", ex2);
        }
    }

    public static MediaType valueOf(HttpHeaderReader reader2) throws ParseException {
        reader2.hasNext();
        String type = reader2.nextToken();
        reader2.nextSeparator('/');
        String subType = reader2.nextToken();
        Map<String, String> params2 = null;
        if (reader2.hasNext()) {
            params2 = HttpHeaderReader.readParameters(reader2);
        }
        return new MediaType(type, subType, params2);
    }
}

