/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.impl.provider.header;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WriterUtil {
    private static Pattern whitespace = Pattern.compile("\\s");
    private static Pattern whitespaceOrQuote = Pattern.compile("[\\s\"]");

    public static void appendQuotedIfWhiteSpaceOrQuote(StringBuilder b, String value2) {
        if (value2 == null) {
            return;
        }
        Matcher m = whitespaceOrQuote.matcher(value2);
        boolean quote2 = m.find();
        if (quote2) {
            b.append('\"');
        }
        WriterUtil.appendEscapingQuotes(b, value2);
        if (quote2) {
            b.append('\"');
        }
    }

    public static void appendQuotedIfWhitespace(StringBuilder b, String value2) {
        if (value2 == null) {
            return;
        }
        Matcher m = whitespace.matcher(value2);
        boolean quote2 = m.find();
        if (quote2) {
            b.append('\"');
        }
        WriterUtil.appendEscapingQuotes(b, value2);
        if (quote2) {
            b.append('\"');
        }
    }

    public static void appendQuoted(StringBuilder b, String value2) {
        b.append('\"');
        WriterUtil.appendEscapingQuotes(b, value2);
        b.append('\"');
    }

    public static void appendEscapingQuotes(StringBuilder b, String value2) {
        for (int i = 0; i < value2.length(); ++i) {
            char c2 = value2.charAt(i);
            if (c2 == '\"') {
                b.append('\\');
            }
            b.append(c2);
        }
    }
}

