/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OsgiLocator {
    private static Map<String, List<Callable<List<Class>>>> factories = new HashMap<String, List<Callable<List<Class>>>>();
    private static ReadWriteLock lock = new ReentrantReadWriteLock();

    private OsgiLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(String id2, Callable<List<Class>> factory) {
        lock.writeLock().lock();
        try {
            List<Callable<List<Class>>> l = factories.get(id2);
            if (l != null) {
                l.remove(factory);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String id2, Callable<List<Class>> factory) {
        lock.writeLock().lock();
        try {
            List<Callable<List<Class>>> l = factories.get(id2);
            if (l == null) {
                l = new ArrayList<Callable<List<Class>>>();
                factories.put(id2, l);
            }
            l.add(factory);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Class locate(String factoryId) {
        lock.readLock().lock();
        try {
            List<Class> classes2;
            List<Callable<List<Class>>> l = factories.get(factoryId);
            if (l == null || l.isEmpty()) {
                Class clazz2 = null;
                return clazz2;
            }
            Callable<List<Class>> c2 = l.get(l.size() - 1);
            try {
                classes2 = c2.call();
            }
            catch (Exception e2) {
                Class clazz3 = null;
                lock.readLock().unlock();
                return clazz3;
            }
            Class clazz4 = classes2.get(0);
            return clazz4;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static synchronized List<Class> locateAll(String factoryId) {
        ArrayList<Class> classes2 = new ArrayList<Class>();
        List<Callable<List<Class>>> l = factories.get(factoryId);
        if (l == null) {
            return classes2;
        }
        for (Callable<List<Class>> c2 : l) {
            try {
                classes2.addAll((Collection<Class>)c2.call());
            }
            catch (Exception e2) {}
        }
        return classes2;
    }
}

