/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.provider.jaxb;

import com.sun.jersey.core.impl.provider.entity.Inflector;
import com.sun.jersey.core.provider.jaxb.AbstractJAXBProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class AbstractListElementProvider
extends AbstractJAXBProvider<Object> {
    private final Inflector inflector = Inflector.getInstance();

    public AbstractListElementProvider(Providers ps) {
        super(ps);
    }

    public AbstractListElementProvider(Providers ps, MediaType mt) {
        super(ps, mt);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations2, MediaType mediaType) {
        if (type == List.class || type == Collection.class) {
            return this.verifyGenericType(genericType) && this.isSupported(mediaType);
        }
        if (type.isArray()) {
            return this.verifyArrayType(type) && this.isSupported(mediaType);
        }
        return false;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations2, MediaType mediaType) {
        if (List.class.isAssignableFrom(type)) {
            return this.verifyGenericType(genericType) && this.isSupported(mediaType);
        }
        if (type.isArray()) {
            return this.verifyArrayType(type) && this.isSupported(mediaType);
        }
        return false;
    }

    private boolean verifyArrayType(Class type) {
        return (type = type.getComponentType()).isAnnotationPresent(XmlRootElement.class) || type.isAnnotationPresent(XmlType.class) || JAXBElement.class.isAssignableFrom(type);
    }

    private boolean verifyGenericType(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType pt = (ParameterizedType)genericType;
        if (pt.getActualTypeArguments().length > 1) {
            return false;
        }
        Type ta = pt.getActualTypeArguments()[0];
        if (ta instanceof ParameterizedType) {
            ParameterizedType lpt = (ParameterizedType)ta;
            return lpt.getRawType() instanceof Class && JAXBElement.class.isAssignableFrom((Class)lpt.getRawType());
        }
        if (!(pt.getActualTypeArguments()[0] instanceof Class)) {
            return false;
        }
        Class listClass = (Class)pt.getActualTypeArguments()[0];
        return listClass.isAnnotationPresent(XmlRootElement.class) || listClass.isAnnotationPresent(XmlType.class);
    }

    @Override
    public final void writeTo(Object t2, Class<?> type, Type genericType, Annotation[] annotations2, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            List<Object> c2 = type.isArray() ? Arrays.asList((Object[])t2) : (List<Object>)t2;
            Class elementType2 = this.getElementClass(type, genericType);
            Charset charset = AbstractListElementProvider.getCharset(mediaType);
            String charsetName = charset.name();
            Marshaller m = this.getMarshaller(elementType2, mediaType);
            m.setProperty("jaxb.fragment", (Object)true);
            if (charset != UTF8) {
                m.setProperty("jaxb.encoding", (Object)charsetName);
            }
            this.setHeader(m, annotations2);
            this.writeList(elementType2, c2, mediaType, charset, m, entityStream);
        }
        catch (JAXBException ex2) {
            throw new WebApplicationException((Throwable)ex2, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public abstract void writeList(Class<?> var1, Collection<?> var2, MediaType var3, Charset var4, Marshaller var5, OutputStream var6) throws JAXBException, IOException;

    @Override
    public final Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations2, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            Class elementType2 = this.getElementClass(type, genericType);
            Unmarshaller u = this.getUnmarshaller(elementType2, mediaType);
            XMLStreamReader r = this.getXMLStreamReader(elementType2, mediaType, u, entityStream);
            ArrayList<Object> l = new ArrayList<Object>();
            boolean jaxbElement = false;
            int event = r.next();
            while (event != 1) {
                event = r.next();
            }
            event = r.next();
            while (event != 1 && event != 8) {
                event = r.next();
            }
            while (event != 8) {
                if (elementType2.isAnnotationPresent(XmlRootElement.class)) {
                    l.add(u.unmarshal(r));
                } else if (elementType2.isAnnotationPresent(XmlType.class)) {
                    l.add(u.unmarshal(r, elementType2).getValue());
                } else {
                    l.add(u.unmarshal(r, elementType2));
                    jaxbElement = true;
                }
                event = r.getEventType();
                while (event != 1 && event != 8) {
                    event = r.next();
                }
            }
            return type.isArray() ? this.createArray(l, jaxbElement ? JAXBElement.class : elementType2) : l;
        }
        catch (UnmarshalException ex2) {
            throw new WebApplicationException((Throwable)ex2, Response.Status.BAD_REQUEST);
        }
        catch (XMLStreamException ex3) {
            throw new WebApplicationException((Throwable)ex3, Response.Status.BAD_REQUEST);
        }
        catch (JAXBException ex4) {
            throw new WebApplicationException((Throwable)ex4, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Object createArray(List l, Class componentType) {
        Object array2 = Array.newInstance(componentType, l.size());
        for (int i = 0; i < l.size(); ++i) {
            Array.set(array2, i, l.get(i));
        }
        return array2;
    }

    protected abstract XMLStreamReader getXMLStreamReader(Class<?> var1, MediaType var2, Unmarshaller var3, InputStream var4) throws XMLStreamException;

    protected Class getElementClass(Class<?> type, Type genericType) {
        Type ta = genericType instanceof ParameterizedType ? ((ParameterizedType)genericType).getActualTypeArguments()[0] : (genericType instanceof GenericArrayType ? ((GenericArrayType)genericType).getGenericComponentType() : type.getComponentType());
        if (ta instanceof ParameterizedType) {
            ta = ((ParameterizedType)ta).getActualTypeArguments()[0];
        }
        return ta;
    }

    private String convertToXmlName(String name) {
        return name.replace("$", "_");
    }

    protected final String getRootElementName(Class<?> elementType2) {
        if (this.isXmlRootElementProcessing()) {
            return this.convertToXmlName(this.inflector.pluralize(this.inflector.demodulize(this.getElementName(elementType2))));
        }
        return this.convertToXmlName(this.inflector.decapitalize(this.inflector.pluralize(this.inflector.demodulize(elementType2.getName()))));
    }

    protected final String getElementName(Class<?> elementType2) {
        String name = elementType2.getName();
        XmlRootElement xre = elementType2.getAnnotation(XmlRootElement.class);
        if (xre != null && !xre.name().equals("##default")) {
            name = xre.name();
        }
        return name;
    }
}

