/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.reflection;

import com.sun.jersey.core.reflection.AnnotatedMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MethodList
implements Iterable<AnnotatedMethod> {
    private AnnotatedMethod[] methods;

    public MethodList(Class c2) {
        this(c2, false);
    }

    public MethodList(Class c2, boolean declaredMethods) {
        this(declaredMethods ? MethodList.getAllDeclaredMethods(c2) : MethodList.getMethods(c2));
    }

    private static List<Method> getAllDeclaredMethods(Class c2) {
        ArrayList<Method> l = new ArrayList<Method>();
        while (c2 != null && c2 != Object.class) {
            l.addAll(Arrays.asList(c2.getDeclaredMethods()));
            c2 = c2.getSuperclass();
        }
        return l;
    }

    private static List<Method> getMethods(Class c2) {
        return Arrays.asList(c2.getMethods());
    }

    public MethodList(List<Method> methods2) {
        ArrayList<AnnotatedMethod> l = new ArrayList<AnnotatedMethod>();
        for (Method m : methods2) {
            if (m.isBridge() || m.getDeclaringClass() == Object.class) continue;
            l.add(new AnnotatedMethod(m));
        }
        this.methods = new AnnotatedMethod[l.size()];
        this.methods = l.toArray(this.methods);
    }

    public MethodList(Method ... methods2) {
        ArrayList<AnnotatedMethod> l = new ArrayList<AnnotatedMethod>();
        for (Method m : methods2) {
            if (m.isBridge() || m.getDeclaringClass() == Object.class) continue;
            l.add(new AnnotatedMethod(m));
        }
        this.methods = new AnnotatedMethod[l.size()];
        this.methods = l.toArray(this.methods);
    }

    public MethodList(AnnotatedMethod ... methods2) {
        this.methods = methods2;
    }

    @Override
    public Iterator<AnnotatedMethod> iterator() {
        return Arrays.asList(this.methods).iterator();
    }

    public <T extends Annotation> MethodList isNotPublic() {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return !Modifier.isPublic(m.getMethod().getModifiers());
            }
        });
    }

    public <T extends Annotation> MethodList hasNumParams(final int i) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return m.getParameterTypes().length == i;
            }
        });
    }

    public <T extends Annotation> MethodList hasReturnType(final Class<?> r) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return m.getMethod().getReturnType() == r;
            }
        });
    }

    public <T extends Annotation> MethodList nameStartsWith(final String s2) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return m.getMethod().getName().startsWith(s2);
            }
        });
    }

    public <T extends Annotation> MethodList hasAnnotation(final Class<T> annotation2) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return m.getAnnotation(annotation2) != null;
            }
        });
    }

    public <T extends Annotation> MethodList hasMetaAnnotation(final Class<T> annotation2) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                for (Annotation a2 : m.getAnnotations()) {
                    if (a2.annotationType().getAnnotation(annotation2) == null) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public <T extends Annotation> MethodList hasNotAnnotation(final Class<T> annotation2) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return m.getAnnotation(annotation2) == null;
            }
        });
    }

    public <T extends Annotation> MethodList hasNotMetaAnnotation(final Class<T> annotation2) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                for (Annotation a2 : m.getAnnotations()) {
                    if (a2.annotationType().getAnnotation(annotation2) == null) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public MethodList filter(Filter f2) {
        ArrayList<AnnotatedMethod> r = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod m : this.methods) {
            if (!f2.keep(m)) continue;
            r.add(m);
        }
        return new MethodList(r.toArray(new AnnotatedMethod[0]));
    }

    public static interface Filter {
        public boolean keep(AnnotatedMethod var1);
    }
}

