/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.reflection;

import com.sun.jersey.impl.ImplMessages;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

public class ReflectionHelper {
    public static Class getDeclaringClass(AccessibleObject ao) {
        if (ao instanceof Method) {
            return ((Method)ao).getDeclaringClass();
        }
        if (ao instanceof Field) {
            return ((Field)ao).getDeclaringClass();
        }
        if (ao instanceof Constructor) {
            return ((Constructor)ao).getDeclaringClass();
        }
        throw new RuntimeException();
    }

    public static String objectToString(Object o) {
        if (o == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(o.getClass().getName()).append('@').append(Integer.toHexString(o.hashCode()));
        return sb.toString();
    }

    public static String methodInstanceToString(Object o, Method m) {
        StringBuffer sb = new StringBuffer();
        sb.append(o.getClass().getName()).append('@').append(Integer.toHexString(o.hashCode())).append('.').append(m.getName()).append('(');
        Class<?>[] params2 = m.getParameterTypes();
        for (int i = 0; i < params2.length; ++i) {
            sb.append(ReflectionHelper.getTypeName(params2[i]));
            if (i >= params2.length - 1) continue;
            sb.append(",");
        }
        sb.append(')');
        return sb.toString();
    }

    private static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static Class classForName(String name) {
        return ReflectionHelper.classForName(name, ReflectionHelper.getContextClassLoader());
    }

    public static Class classForName(String name, ClassLoader cl) {
        if (cl != null) {
            try {
                return Class.forName(name, false, cl);
            }
            catch (ClassNotFoundException ex2) {
                // empty catch block
            }
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class classForNameWithException(String name) throws ClassNotFoundException {
        return ReflectionHelper.classForNameWithException(name, ReflectionHelper.getContextClassLoader());
    }

    public static Class classForNameWithException(String name, ClassLoader cl) throws ClassNotFoundException {
        if (cl != null) {
            try {
                return Class.forName(name, false, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(name);
    }

    public static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    public static void setAccessibleMethod(final Method m) {
        if (Modifier.isPublic(m.getModifiers())) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                return m;
            }
        });
    }

    public static Class getGenericClass(Type parameterizedType) throws IllegalArgumentException {
        Type t2 = ReflectionHelper.getTypeArgumentOfParameterizedType(parameterizedType);
        if (t2 == null) {
            return null;
        }
        Class c2 = ReflectionHelper.getClassOfType(t2);
        if (c2 == null) {
            throw new IllegalArgumentException(ImplMessages.GENERIC_TYPE_NOT_SUPPORTED(t2, parameterizedType));
        }
        return c2;
    }

    public static TypeClassPair getTypeArgumentAndClass(Type parameterizedType) throws IllegalArgumentException {
        Type t2 = ReflectionHelper.getTypeArgumentOfParameterizedType(parameterizedType);
        if (t2 == null) {
            return null;
        }
        Class c2 = ReflectionHelper.getClassOfType(t2);
        if (c2 == null) {
            throw new IllegalArgumentException(ImplMessages.GENERIC_TYPE_NOT_SUPPORTED(t2, parameterizedType));
        }
        return new TypeClassPair(t2, c2);
    }

    private static Type getTypeArgumentOfParameterizedType(Type parameterizedType) {
        if (!(parameterizedType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType type = (ParameterizedType)parameterizedType;
        Type[] genericTypes = type.getActualTypeArguments();
        if (genericTypes.length != 1) {
            return null;
        }
        return genericTypes[0];
    }

    private static Class getClassOfType(Type type) {
        ParameterizedType subType;
        Type t2;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type t3 = arrayType.getGenericComponentType();
            if (t3 instanceof Class) {
                return ReflectionHelper.getArrayClass((Class)t3);
            }
        } else if (type instanceof ParameterizedType && (t2 = (subType = (ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)t2;
        }
        return null;
    }

    public static Class getArrayClass(Class c2) {
        try {
            Object o = Array.newInstance(c2, 0);
            return o.getClass();
        }
        catch (Exception e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static Method getValueOfStringMethod(Class c2) {
        try {
            Method m = c2.getDeclaredMethod("valueOf", String.class);
            if (!Modifier.isStatic(m.getModifiers()) && m.getReturnType() == c2) {
                return null;
            }
            return m;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Method getFromStringStringMethod(Class c2) {
        try {
            Method m = c2.getDeclaredMethod("fromString", String.class);
            if (!Modifier.isStatic(m.getModifiers()) && m.getReturnType() == c2) {
                return null;
            }
            return m;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Constructor getStringConstructor(Class c2) {
        try {
            return c2.getConstructor(String.class);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Class[] getParameterizedClassArguments(DeclaringClassInterfacePair p) {
        if (p.genericInterface instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)p.genericInterface;
            Type[] as2 = pt.getActualTypeArguments();
            Class[] cas = new Class[as2.length];
            for (int i = 0; i < as2.length; ++i) {
                Type a2 = as2[i];
                if (a2 instanceof Class) {
                    cas[i] = (Class)a2;
                    continue;
                }
                if (a2 instanceof ParameterizedType) {
                    pt = (ParameterizedType)a2;
                    cas[i] = (Class)pt.getRawType();
                    continue;
                }
                if (!(a2 instanceof TypeVariable)) continue;
                ClassTypePair ctp = ReflectionHelper.resolveTypeVariable(p.concreteClass, p.declaringClass, (TypeVariable)a2);
                cas[i] = ctp != null ? ctp.c : Object.class;
            }
            return cas;
        }
        return null;
    }

    public static Type[] getParameterizedTypeArguments(DeclaringClassInterfacePair p) {
        if (p.genericInterface instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)p.genericInterface;
            Type[] as2 = pt.getActualTypeArguments();
            Type[] ras = new Type[as2.length];
            for (int i = 0; i < as2.length; ++i) {
                Type a2 = as2[i];
                if (a2 instanceof Class) {
                    ras[i] = a2;
                    continue;
                }
                if (a2 instanceof ParameterizedType) {
                    pt = (ParameterizedType)a2;
                    ras[i] = a2;
                    continue;
                }
                if (!(a2 instanceof TypeVariable)) continue;
                ClassTypePair ctp = ReflectionHelper.resolveTypeVariable(p.concreteClass, p.declaringClass, (TypeVariable)a2);
                ras[i] = ctp.t;
            }
            return ras;
        }
        return null;
    }

    public static DeclaringClassInterfacePair getClass(Class concrete, Class iface) {
        return ReflectionHelper.getClass(concrete, iface, concrete);
    }

    private static DeclaringClassInterfacePair getClass(Class concrete, Class iface, Class c2) {
        Type[] gis = c2.getGenericInterfaces();
        DeclaringClassInterfacePair p = ReflectionHelper.getType(concrete, iface, c2, gis);
        if (p != null) {
            return p;
        }
        if ((c2 = c2.getSuperclass()) == null || c2 == Object.class) {
            return null;
        }
        return ReflectionHelper.getClass(concrete, iface, c2);
    }

    private static DeclaringClassInterfacePair getType(Class concrete, Class iface, Class c2, Type[] ts) {
        for (Type t2 : ts) {
            DeclaringClassInterfacePair p = ReflectionHelper.getType(concrete, iface, c2, t2);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private static DeclaringClassInterfacePair getType(Class concrete, Class iface, Class c2, Type t2) {
        if (t2 instanceof Class) {
            if (t2 == iface) {
                return new DeclaringClassInterfacePair(concrete, c2, t2);
            }
            return ReflectionHelper.getClass(concrete, iface, (Class)t2);
        }
        if (t2 instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t2;
            if (pt.getRawType() == iface) {
                return new DeclaringClassInterfacePair(concrete, c2, t2);
            }
            return ReflectionHelper.getClass(concrete, iface, (Class)pt.getRawType());
        }
        return null;
    }

    public static ClassTypePair resolveTypeVariable(Class c2, Class dc, TypeVariable tv) {
        return ReflectionHelper.resolveTypeVariable(c2, dc, tv, new HashMap<TypeVariable, Type>());
    }

    private static ClassTypePair resolveTypeVariable(Class c2, Class dc, TypeVariable tv, Map<TypeVariable, Type> map3) {
        Type[] gis;
        for (Type gi : gis = c2.getGenericInterfaces()) {
            ParameterizedType pt;
            ClassTypePair ctp;
            if (!(gi instanceof ParameterizedType) || (ctp = ReflectionHelper.resolveTypeVariable(pt = (ParameterizedType)gi, (Class)pt.getRawType(), dc, tv, map3)) == null) continue;
            return ctp;
        }
        Type gsc = c2.getGenericSuperclass();
        if (gsc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gsc;
            return ReflectionHelper.resolveTypeVariable(pt, c2.getSuperclass(), dc, tv, map3);
        }
        if (gsc instanceof Class) {
            return ReflectionHelper.resolveTypeVariable(c2.getSuperclass(), dc, tv, map3);
        }
        return null;
    }

    private static ClassTypePair resolveTypeVariable(ParameterizedType pt, Class c2, Class dc, TypeVariable tv, Map<TypeVariable, Type> map3) {
        Type[] typeArguments = pt.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeParameters2 = c2.getTypeParameters();
        HashMap<TypeVariable, Type> submap2 = new HashMap<TypeVariable, Type>();
        for (int i = 0; i < typeArguments.length; ++i) {
            if (typeArguments[i] instanceof TypeVariable) {
                Type t2 = map3.get(typeArguments[i]);
                submap2.put(typeParameters2[i], t2);
                continue;
            }
            submap2.put(typeParameters2[i], typeArguments[i]);
        }
        if (c2 == dc) {
            Type t3 = (Type)submap2.get(tv);
            if (t3 instanceof Class) {
                return new ClassTypePair((Class)t3);
            }
            if (t3 instanceof GenericArrayType) {
                if ((t3 = ((GenericArrayType)t3).getGenericComponentType()) instanceof Class) {
                    c2 = (Class)t3;
                    try {
                        return new ClassTypePair(ReflectionHelper.getArrayClass(c2));
                    }
                    catch (Exception e2) {
                        return null;
                    }
                }
                if (t3 instanceof ParameterizedType) {
                    Type rt = ((ParameterizedType)t3).getRawType();
                    if (!(rt instanceof Class)) {
                        return null;
                    }
                    c2 = (Class)rt;
                    try {
                        return new ClassTypePair(ReflectionHelper.getArrayClass(c2), t3);
                    }
                    catch (Exception e3) {
                        return null;
                    }
                }
                return null;
            }
            if (t3 instanceof ParameterizedType) {
                pt = (ParameterizedType)t3;
                if (pt.getRawType() instanceof Class) {
                    return new ClassTypePair((Class)pt.getRawType(), pt);
                }
                return null;
            }
            return null;
        }
        return ReflectionHelper.resolveTypeVariable(c2, dc, tv, submap2);
    }

    public static Method findMethodOnClass(Class c2, Method m) {
        try {
            return c2.getMethod(m.getName(), m.getParameterTypes());
        }
        catch (NoSuchMethodException ex2) {
            for (Method _m : c2.getMethods()) {
                if (!_m.getName().equals(m.getName()) || _m.getParameterTypes().length != m.getParameterTypes().length || !ReflectionHelper.compareParameterTypes(m.getGenericParameterTypes(), _m.getGenericParameterTypes())) continue;
                return _m;
            }
            return null;
        }
    }

    private static boolean compareParameterTypes(Type[] ts, Type[] _ts) {
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i].equals(_ts[i]) || _ts[i] instanceof TypeVariable) continue;
            return false;
        }
        return true;
    }

    public static class ClassTypePair {
        public final Class c;
        public final Type t;

        public ClassTypePair(Class c2) {
            this(c2, c2);
        }

        public ClassTypePair(Class c2, Type t2) {
            this.c = c2;
            this.t = t2;
        }
    }

    public static class DeclaringClassInterfacePair {
        public final Class concreteClass;
        public final Class declaringClass;
        public final Type genericInterface;

        private DeclaringClassInterfacePair(Class concreteClass, Class declaringClass, Type genericInteface) {
            this.concreteClass = concreteClass;
            this.declaringClass = declaringClass;
            this.genericInterface = genericInteface;
        }
    }

    public static final class TypeClassPair {
        public final Type t;
        public final Class c;

        public TypeClassPair(Type t2, Class c2) {
            this.t = t2;
            this.c = c2;
        }
    }
}

