/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.component;

import com.sun.jersey.core.reflection.AnnotatedMethod;
import com.sun.jersey.core.reflection.MethodList;
import com.sun.jersey.core.spi.component.AnnotatedContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.spi.inject.Errors;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;

public class ComponentInjector<T> {
    protected final InjectableProviderContext ipc;
    protected final Class<T> c;

    public ComponentInjector(InjectableProviderContext ipc, Class<T> c2) {
        this.ipc = ipc;
        this.c = c2;
    }

    public void inject(T t2) {
        Annotation[] as2;
        AnnotatedContext aoc = new AnnotatedContext();
        for (Class<T> oClass = this.c; oClass != Object.class; oClass = oClass.getSuperclass()) {
            for (Field f2 : oClass.getDeclaredFields()) {
                aoc.setAccessibleObject(f2);
                as2 = f2.getAnnotations();
                aoc.setAnnotations(as2);
                boolean missingDependency = false;
                for (Annotation a2 : as2) {
                    Injectable i = this.ipc.getInjectable(a2.annotationType(), (ComponentContext)aoc, a2, f2.getGenericType(), ComponentScope.UNDEFINED_SINGLETON);
                    if (i != null) {
                        missingDependency = false;
                        this.setFieldValue(t2, f2, i.getValue());
                        break;
                    }
                    if (!this.ipc.isAnnotationRegistered(a2.annotationType(), f2.getGenericType().getClass())) continue;
                    missingDependency = true;
                }
                if (!missingDependency) continue;
                Errors.missingDependency(f2);
            }
        }
        MethodList ml = new MethodList(this.c.getMethods());
        int methodIndex = 0;
        for (AnnotatedMethod m : ml.hasNotMetaAnnotation(HttpMethod.class).hasNotAnnotation(Path.class).hasNumParams(1).hasReturnType(Void.TYPE).nameStartsWith("set")) {
            as2 = m.getAnnotations();
            aoc.setAccessibleObject(m.getMethod());
            aoc.setAnnotations(as2);
            Type gpt = m.getGenericParameterTypes()[0];
            boolean missingDependency = false;
            for (Annotation a3 : as2) {
                Injectable i = this.ipc.getInjectable(a3.annotationType(), (ComponentContext)aoc, a3, gpt, ComponentScope.UNDEFINED_SINGLETON);
                if (i != null) {
                    missingDependency = false;
                    this.setMethodValue(t2, m, i.getValue());
                    break;
                }
                if (!this.ipc.isAnnotationRegistered(a3.annotationType(), gpt.getClass())) continue;
                missingDependency = true;
            }
            if (missingDependency) {
                Errors.missingDependency(m.getMethod(), methodIndex);
            }
            ++methodIndex;
        }
    }

    private void setFieldValue(final Object resource, final Field f2, final Object value2) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    if (!f2.isAccessible()) {
                        f2.setAccessible(true);
                    }
                    f2.set(resource, value2);
                    return null;
                }
                catch (IllegalAccessException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
        });
    }

    private void setMethodValue(Object o, AnnotatedMethod m, Object value2) {
        try {
            m.getMethod().invoke(o, value2);
        }
        catch (Exception ex2) {
            throw new RuntimeException(ex2);
        }
    }
}

