/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.factory;

import com.sun.jersey.core.header.OutBoundHeaders;
import com.sun.jersey.core.spi.factory.ResponseImpl;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;

public final class ResponseBuilderImpl
extends Response.ResponseBuilder {
    private Response.StatusType statusType = Response.Status.NO_CONTENT;
    private OutBoundHeaders headers;
    private Object entity;
    private Type entityType;

    public ResponseBuilderImpl() {
    }

    private ResponseBuilderImpl(ResponseBuilderImpl that) {
        this.statusType = that.statusType;
        this.entity = that.entity;
        this.headers = that.headers != null ? new OutBoundHeaders(that.headers) : null;
        this.entityType = that.entityType;
    }

    public Response.ResponseBuilder entityWithType(Object entity, Type entityType) {
        this.entity = entity;
        this.entityType = entityType;
        return this;
    }

    private OutBoundHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new OutBoundHeaders();
        }
        return this.headers;
    }

    @Override
    public Response build() {
        ResponseImpl r = new ResponseImpl(this.statusType, this.getHeaders(), this.entity, this.entityType);
        this.reset();
        return r;
    }

    private void reset() {
        this.statusType = Response.Status.NO_CONTENT;
        this.headers = null;
        this.entity = null;
        this.entityType = null;
    }

    @Override
    public Response.ResponseBuilder clone() {
        return new ResponseBuilderImpl(this);
    }

    @Override
    public Response.ResponseBuilder status(Response.StatusType status) {
        if (status == null) {
            throw new IllegalArgumentException();
        }
        this.statusType = status;
        return this;
    }

    @Override
    public Response.ResponseBuilder status(int status) {
        return this.status(ResponseImpl.toStatusType(status));
    }

    @Override
    public Response.ResponseBuilder entity(Object entity) {
        this.entity = entity;
        this.entityType = entity != null ? entity.getClass() : null;
        return this;
    }

    @Override
    public Response.ResponseBuilder type(MediaType type) {
        this.headerSingle("Content-Type", type);
        return this;
    }

    @Override
    public Response.ResponseBuilder type(String type) {
        return this.type(type == null ? null : MediaType.valueOf(type));
    }

    @Override
    public Response.ResponseBuilder variant(Variant variant) {
        if (variant == null) {
            this.type((MediaType)null);
            this.language((String)null);
            this.encoding(null);
            return this;
        }
        this.type(variant.getMediaType());
        this.language(variant.getLanguage());
        this.encoding(variant.getEncoding());
        return this;
    }

    @Override
    public Response.ResponseBuilder variants(List<Variant> variants) {
        if (variants == null) {
            this.header("Vary", null);
            return this;
        }
        if (variants.isEmpty()) {
            return this;
        }
        MediaType accept2 = variants.get(0).getMediaType();
        boolean vAccept = false;
        Locale acceptLanguage = variants.get(0).getLanguage();
        boolean vAcceptLanguage = false;
        String acceptEncoding = variants.get(0).getEncoding();
        boolean vAcceptEncoding = false;
        for (Variant v : variants) {
            vAccept |= !vAccept && this.vary(v.getMediaType(), accept2);
            vAcceptLanguage |= !vAcceptLanguage && this.vary(v.getLanguage(), acceptLanguage);
            vAcceptEncoding |= !vAcceptEncoding && this.vary(v.getEncoding(), acceptEncoding);
        }
        StringBuilder vary = new StringBuilder();
        this.append(vary, vAccept, "Accept");
        this.append(vary, vAcceptLanguage, "Accept-Language");
        this.append(vary, vAcceptEncoding, "Accept-Encoding");
        if (vary.length() > 0) {
            this.header("Vary", vary.toString());
        }
        return this;
    }

    private boolean vary(MediaType v, MediaType vary) {
        return v != null && !v.equals(vary);
    }

    private boolean vary(Locale v, Locale vary) {
        return v != null && !v.equals(vary);
    }

    private boolean vary(String v, String vary) {
        return v != null && !v.equalsIgnoreCase(vary);
    }

    private void append(StringBuilder sb, boolean v, String s2) {
        if (v) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(s2);
        }
    }

    @Override
    public Response.ResponseBuilder language(String language2) {
        this.headerSingle("Content-Language", language2);
        return this;
    }

    @Override
    public Response.ResponseBuilder language(Locale language2) {
        this.headerSingle("Content-Language", language2);
        return this;
    }

    @Override
    public Response.ResponseBuilder location(URI location2) {
        this.headerSingle("Location", location2);
        return this;
    }

    @Override
    public Response.ResponseBuilder contentLocation(URI location2) {
        this.headerSingle("Content-Location", location2);
        return this;
    }

    public Response.ResponseBuilder encoding(String encoding) {
        this.headerSingle("Content-Encoding", encoding);
        return this;
    }

    @Override
    public Response.ResponseBuilder tag(EntityTag tag2) {
        this.headerSingle("ETag", tag2);
        return this;
    }

    @Override
    public Response.ResponseBuilder tag(String tag2) {
        return this.tag(tag2 == null ? null : new EntityTag(tag2));
    }

    @Override
    public Response.ResponseBuilder lastModified(Date lastModified) {
        this.headerSingle("Last-Modified", lastModified);
        return this;
    }

    @Override
    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        this.headerSingle("Cache-Control", cacheControl);
        return this;
    }

    @Override
    public Response.ResponseBuilder expires(Date expires) {
        this.headerSingle("Expires", expires);
        return this;
    }

    @Override
    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        if (cookies != null) {
            for (NewCookie cookie : cookies) {
                this.header("Set-Cookie", cookie);
            }
        } else {
            this.header("Set-Cookie", null);
        }
        return this;
    }

    @Override
    public Response.ResponseBuilder header(String name, Object value2) {
        return this.header(name, value2, false);
    }

    public Response.ResponseBuilder headerSingle(String name, Object value2) {
        return this.header(name, value2, true);
    }

    public Response.ResponseBuilder header(String name, Object value2, boolean single) {
        if (value2 != null) {
            if (single) {
                this.getHeaders().putSingle(name, value2);
            } else {
                this.getHeaders().add(name, value2);
            }
        } else {
            this.getHeaders().remove(name);
        }
        return this;
    }
}

