/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.scanning;

import com.sun.jersey.core.spi.scanning.JarFileScanner;
import com.sun.jersey.core.spi.scanning.Scanner;
import com.sun.jersey.core.spi.scanning.ScannerException;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import com.sun.jersey.core.util.Closing;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FilesScanner
implements Scanner {
    private final File[] files;

    public FilesScanner(File[] files2) {
        this.files = files2;
    }

    @Override
    public void scan(ScannerListener cfl) {
        for (File f2 : this.files) {
            this.scan(f2, cfl);
        }
    }

    private void scan(File f2, ScannerListener cfl) {
        if (f2.isDirectory()) {
            this.scanDir(f2, cfl);
        } else if (f2.getName().endsWith(".jar") || f2.getName().endsWith(".zip")) {
            try {
                JarFileScanner.scan(f2, "", cfl);
            }
            catch (IOException ex2) {
                throw new ScannerException("IO error when scanning jar file " + f2, ex2);
            }
        }
    }

    private void scanDir(File root2, final ScannerListener cfl) {
        for (final File child : root2.listFiles()) {
            if (child.isDirectory()) {
                this.scanDir(child, cfl);
                continue;
            }
            if (child.getName().endsWith(".jar")) {
                try {
                    JarFileScanner.scan(child, "", cfl);
                    continue;
                }
                catch (IOException ex2) {
                    throw new ScannerException("IO error when scanning jar file " + child, ex2);
                }
            }
            if (!cfl.onAccept(child.getName())) continue;
            try {
                new Closing(new BufferedInputStream(new FileInputStream(child))).f(new Closing.Closure(){

                    @Override
                    public void f(InputStream in2) throws IOException {
                        cfl.onProcess(child.getName(), in2);
                    }
                });
            }
            catch (IOException ex3) {
                throw new ScannerException("IO error when scanning file " + child, ex3);
            }
        }
    }
}

