/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.spi.scanning.uri;

import com.sun.jersey.core.spi.scanning.JarFileScanner;
import com.sun.jersey.core.spi.scanning.ScannerException;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import com.sun.jersey.core.spi.scanning.uri.FileSchemeScanner;
import com.sun.jersey.core.spi.scanning.uri.UriSchemeScanner;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;

public class VfsSchemeScanner
implements UriSchemeScanner {
    @Override
    public Set<String> getSchemes() {
        return new HashSet<String>(Arrays.asList("vfsfile", "vfszip"));
    }

    @Override
    public void scan(final URI u, final ScannerListener sl) {
        if (u.getScheme().equalsIgnoreCase("vfsfile")) {
            new FileSchemeScanner().scan(UriBuilder.fromUri(u).scheme("file").build(new Object[0]), sl);
        } else {
            String su = u.toString();
            int webInfIndex = su.indexOf("/WEB-INF/classes");
            if (webInfIndex != -1) {
                String war = su.substring(0, webInfIndex);
                final String path2 = su.substring(webInfIndex + 1);
                int warParentIndex = war.lastIndexOf(47);
                String warParent = su.substring(0, warParentIndex);
                if (warParent.endsWith(".ear")) {
                    final String warName = su.substring(warParentIndex + 1, war.length());
                    try {
                        JarFileScanner.scan(new URL(warParent.replace("vfszip", "file")).openStream(), "", new ScannerListener(){

                            @Override
                            public boolean onAccept(String name) {
                                return name.equals(warName);
                            }

                            @Override
                            public void onProcess(String name, InputStream in2) throws IOException {
                                in2 = new FilterInputStream(in2){

                                    @Override
                                    public void close() throws IOException {
                                    }
                                };
                                try {
                                    JarFileScanner.scan(in2, path2, sl);
                                }
                                catch (IOException ex2) {
                                    throw new ScannerException("IO error when scanning war " + u, ex2);
                                }
                            }
                        });
                    }
                    catch (IOException ex2) {
                        throw new ScannerException("IO error when scanning war " + u, ex2);
                    }
                } else {
                    try {
                        JarFileScanner.scan(new URL(war.replace("vfszip", "file")).openStream(), path2, sl);
                    }
                    catch (IOException ex3) {
                        throw new ScannerException("IO error when scanning war " + u, ex3);
                    }
                }
            } else {
                try {
                    JarFileScanner.scan(new URL(su).openStream(), "", sl);
                }
                catch (IOException ex4) {
                    throw new ScannerException("IO error when scanning jar " + u, ex4);
                }
            }
        }
    }
}

