/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.core.util;

import com.sun.jersey.core.util.KeyComparator;
import com.sun.jersey.core.util.KeyComparatorHashMap;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class KeyComparatorLinkedHashMap<K, V>
extends KeyComparatorHashMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    private transient Entry<K, V> header;
    private final boolean accessOrder;

    public KeyComparatorLinkedHashMap(int initialCapacity, float loadFactor, KeyComparator<K> keyComparator) {
        super(initialCapacity, loadFactor, keyComparator);
        this.accessOrder = false;
    }

    public KeyComparatorLinkedHashMap(int initialCapacity, KeyComparator<K> keyComparator) {
        super(initialCapacity, keyComparator);
        this.accessOrder = false;
    }

    public KeyComparatorLinkedHashMap(KeyComparator<K> keyComparator) {
        super(keyComparator);
        this.accessOrder = false;
    }

    public KeyComparatorLinkedHashMap(Map<? extends K, ? extends V> m, KeyComparator<K> keyComparator) {
        super(m, keyComparator);
        this.accessOrder = false;
    }

    public KeyComparatorLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder, KeyComparator<K> keyComparator) {
        super(initialCapacity, loadFactor, keyComparator);
        this.accessOrder = accessOrder;
    }

    @Override
    void init() {
        this.header = new Entry<Object, Object>(-1, null, null, null);
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    void transfer(KeyComparatorHashMap.Entry[] newTable) {
        int newCapacity = newTable.length;
        Entry e2 = this.header.after;
        while (e2 != this.header) {
            int index2 = KeyComparatorLinkedHashMap.indexFor(e2.hash, newCapacity);
            e2.next = newTable[index2];
            newTable[index2] = e2;
            e2 = e2.after;
        }
    }

    @Override
    public boolean containsValue(Object value2) {
        if (value2 == null) {
            Entry e2 = this.header.after;
            while (e2 != this.header) {
                if (e2.value == null) {
                    return true;
                }
                e2 = e2.after;
            }
        } else {
            Entry e3 = this.header.after;
            while (e3 != this.header) {
                if (value2.equals(e3.value)) {
                    return true;
                }
                e3 = e3.after;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Entry e2 = (Entry)this.getEntry(key);
        if (e2 == null) {
            return null;
        }
        e2.recordAccess(this);
        return (V)e2.value;
    }

    @Override
    public void clear() {
        super.clear();
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    @Override
    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    @Override
    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    void addEntry(int hash2, K key, V value2, int bucketIndex) {
        this.createEntry(hash2, key, value2, bucketIndex);
        Entry eldest = this.header.after;
        if (this.removeEldestEntry(eldest)) {
            this.removeEntryForKey(eldest.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    @Override
    void createEntry(int hash2, K key, V value2, int bucketIndex) {
        Entry<K, V> e2;
        KeyComparatorHashMap.Entry old = this.table[bucketIndex];
        this.table[bucketIndex] = e2 = new Entry<K, V>(hash2, key, value2, old);
        ((Entry)e2).addBefore((Entry)this.header);
        ++this.size;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    private class EntryIterator
    extends LinkedHashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends LinkedHashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        Entry<K, V> nextEntry;
        Entry<K, V> lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = ((KeyComparatorLinkedHashMap)KeyComparatorLinkedHashMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = KeyComparatorLinkedHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != KeyComparatorLinkedHashMap.this.header;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (KeyComparatorLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            KeyComparatorLinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = KeyComparatorLinkedHashMap.this.modCount;
        }

        Entry<K, V> nextEntry() {
            if (KeyComparatorLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == KeyComparatorLinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            Entry e2 = this.lastReturned;
            this.nextEntry = e2.after;
            return e2;
        }
    }

    private static class Entry<K, V>
    extends KeyComparatorHashMap.Entry<K, V> {
        Entry<K, V> before;
        Entry<K, V> after;

        Entry(int hash2, K key, V value2, KeyComparatorHashMap.Entry<K, V> next2) {
            super(hash2, key, value2, next2);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry<K, V> existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        void recordAccess(KeyComparatorHashMap<K, V> m) {
            KeyComparatorLinkedHashMap lm = (KeyComparatorLinkedHashMap)m;
            if (lm.accessOrder) {
                ++lm.modCount;
                this.remove();
                this.addBefore(lm.header);
            }
        }

        @Override
        void recordRemoval(KeyComparatorHashMap<K, V> m) {
            this.remove();
        }
    }
}

