/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.api.impl;

import com.sun.xml.bind.api.impl.NameUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public interface NameConverter {
    public static final NameConverter standard = new Standard();
    public static final NameConverter jaxrpcCompatible = new Standard(){

        protected boolean isPunct(char c2) {
            return c2 == '.' || c2 == '-' || c2 == ';' || c2 == '\u00b7' || c2 == '\u0387' || c2 == '\u06dd' || c2 == '\u06de';
        }

        protected boolean isLetter(char c2) {
            return super.isLetter(c2) || c2 == '_';
        }

        protected int classify(char c0) {
            if (c0 == '_') {
                return 2;
            }
            return super.classify(c0);
        }
    };
    public static final NameConverter smart = new Standard(){

        public String toConstantName(String token2) {
            String name = super.toConstantName(token2);
            if (NameUtil.isJavaIdentifier(name)) {
                return name;
            }
            return '_' + name;
        }
    };

    public String toClassName(String var1);

    public String toInterfaceName(String var1);

    public String toPropertyName(String var1);

    public String toConstantName(String var1);

    public String toVariableName(String var1);

    public String toPackageName(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Standard
    extends NameUtil
    implements NameConverter {
        @Override
        public String toClassName(String s2) {
            return this.toMixedCaseName(this.toWordList(s2), true);
        }

        @Override
        public String toVariableName(String s2) {
            return this.toMixedCaseName(this.toWordList(s2), false);
        }

        @Override
        public String toInterfaceName(String token2) {
            return this.toClassName(token2);
        }

        @Override
        public String toPropertyName(String s2) {
            String prop2 = this.toClassName(s2);
            if (prop2.equals("Class")) {
                prop2 = "Clazz";
            }
            return prop2;
        }

        @Override
        public String toConstantName(String token2) {
            return super.toConstantName(token2);
        }

        @Override
        public String toPackageName(String nsUri) {
            ArrayList<String> r;
            String domain;
            String lastToken;
            ArrayList<String> tokens;
            int idx = nsUri.indexOf(58);
            String scheme = "";
            if (idx >= 0 && ((scheme = nsUri.substring(0, idx)).equalsIgnoreCase("http") || scheme.equalsIgnoreCase("urn"))) {
                nsUri = nsUri.substring(idx + 1);
            }
            if ((idx = nsUri.indexOf("#")) >= 0) {
                nsUri = nsUri.substring(0, idx);
            }
            if ((tokens = Standard.tokenize(nsUri, "/: ")).size() == 0) {
                return null;
            }
            if (tokens.size() > 1 && (idx = (lastToken = tokens.get(tokens.size() - 1)).lastIndexOf(46)) > 0) {
                lastToken = lastToken.substring(0, idx);
                tokens.set(tokens.size() - 1, lastToken);
            }
            if ((idx = (domain = tokens.get(0)).indexOf(58)) >= 0) {
                domain = domain.substring(0, idx);
            }
            if ((r = Standard.reverse(Standard.tokenize(domain, scheme.equals("urn") ? ".-" : "."))).get(r.size() - 1).equalsIgnoreCase("www")) {
                r.remove(r.size() - 1);
            }
            tokens.addAll(1, r);
            tokens.remove(0);
            for (int i = 0; i < tokens.size(); ++i) {
                String token2 = tokens.get(i);
                if (!NameUtil.isJavaIdentifier((token2 = Standard.removeIllegalIdentifierChars(token2)).toLowerCase())) {
                    token2 = '_' + token2;
                }
                tokens.set(i, token2.toLowerCase());
            }
            return Standard.combine(tokens, '.');
        }

        private static String removeIllegalIdentifierChars(String token2) {
            StringBuffer newToken = new StringBuffer();
            for (int i = 0; i < token2.length(); ++i) {
                char c2 = token2.charAt(i);
                if (i == 0 && !Character.isJavaIdentifierStart(c2)) {
                    newToken.append('_').append(c2);
                    continue;
                }
                if (!Character.isJavaIdentifierPart(c2)) {
                    newToken.append('_');
                    continue;
                }
                newToken.append(c2);
            }
            return newToken.toString();
        }

        private static ArrayList<String> tokenize(String str, String sep) {
            StringTokenizer tokens = new StringTokenizer(str, sep);
            ArrayList<String> r = new ArrayList<String>();
            while (tokens.hasMoreTokens()) {
                r.add(tokens.nextToken());
            }
            return r;
        }

        private static <T> ArrayList<T> reverse(List<T> a2) {
            ArrayList<T> r = new ArrayList<T>();
            for (int i = a2.size() - 1; i >= 0; --i) {
                r.add(a2.get(i));
            }
            return r;
        }

        private static String combine(List r, char sep) {
            StringBuilder buf = new StringBuilder(r.get(0).toString());
            for (int i = 1; i < r.size(); ++i) {
                buf.append(sep);
                buf.append(r.get(i));
            }
            return buf.toString();
        }
    }
}

