/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.marshaller;

import com.sun.istack.FinalArrayList;
import com.sun.xml.bind.marshaller.Messages;
import com.sun.xml.bind.util.Which;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAX2DOMEx
implements ContentHandler {
    private Node node = null;
    private final Stack<Node> nodeStack = new Stack();
    private final FinalArrayList<String> unprocessedNamespaces = new FinalArrayList();
    private final Document document;

    public SAX2DOMEx(Node node4) {
        this.node = node4;
        this.nodeStack.push(this.node);
        this.document = node4 instanceof Document ? (Document)node4 : node4.getOwnerDocument();
    }

    public SAX2DOMEx() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        this.document = factory.newDocumentBuilder().newDocument();
        this.node = this.document;
        this.nodeStack.push(this.document);
    }

    public final Element getCurrentElement() {
        return (Element)this.nodeStack.peek();
    }

    public Node getDOM() {
        return this.node;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String namespace, String localName, String qName, Attributes attrs) {
        Node parent2 = this.nodeStack.peek();
        Element element2 = this.document.createElementNS(namespace, qName);
        if (element2 == null) {
            throw new AssertionError((Object)Messages.format("SAX2DOMEx.DomImplDoesntSupportCreateElementNs", this.document.getClass().getName(), Which.which(this.document.getClass())));
        }
        for (int i = 0; i < this.unprocessedNamespaces.size(); i += 2) {
            String prefix2 = (String)this.unprocessedNamespaces.get(i + 0);
            String uri = (String)this.unprocessedNamespaces.get(i + 1);
            String qname = "".equals(prefix2) || prefix2 == null ? "xmlns" : "xmlns:" + prefix2;
            if (element2.hasAttributeNS("http://www.w3.org/2000/xmlns/", qname)) {
                element2.removeAttributeNS("http://www.w3.org/2000/xmlns/", qname);
            }
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", qname, uri);
        }
        this.unprocessedNamespaces.clear();
        int length2 = attrs.getLength();
        for (int i = 0; i < length2; ++i) {
            String namespaceuri = attrs.getURI(i);
            String value2 = attrs.getValue(i);
            String qname = attrs.getQName(i);
            element2.setAttributeNS(namespaceuri, qname, value2);
        }
        parent2.appendChild(element2);
        this.nodeStack.push(element2);
    }

    public void endElement(String namespace, String localName, String qName) {
        this.nodeStack.pop();
    }

    public void characters(char[] ch, int start2, int length2) {
        Node parent2 = this.nodeStack.peek();
        Text text2 = this.document.createTextNode(new String(ch, start2, length2));
        parent2.appendChild(text2);
    }

    public void ignorableWhitespace(char[] ch, int start2, int length2) {
    }

    public void processingInstruction(String target2, String data2) throws SAXException {
        Node parent2 = this.nodeStack.peek();
        ProcessingInstruction node4 = this.document.createProcessingInstruction(target2, data2);
        parent2.appendChild(node4);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) {
    }

    public void startPrefixMapping(String prefix2, String uri) {
        this.unprocessedNamespaces.add(prefix2);
        this.unprocessedNamespaces.add(uri);
    }

    public void endPrefixMapping(String prefix2) {
    }
}

