/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import com.sun.xml.bind.unmarshaller.InfosetScanner;
import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
import java.util.Enumeration;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMScanner
implements LocatorEx,
InfosetScanner {
    private Node currentNode = null;
    private final AttributesImpl atts = new AttributesImpl();
    private ContentHandler receiver = null;
    private Locator locator = this;

    public void setLocator(Locator loc) {
        this.locator = loc;
    }

    public void scan(Object node4) throws SAXException {
        if (node4 instanceof Document) {
            this.scan((Document)node4);
        } else {
            this.scan((Element)node4);
        }
    }

    public void scan(Document doc) throws SAXException {
        this.scan(doc.getDocumentElement());
    }

    public void scan(Element e2) throws SAXException {
        String prefix2;
        this.setCurrentLocation(e2);
        this.receiver.setDocumentLocator(this.locator);
        this.receiver.startDocument();
        NamespaceSupport nss = new NamespaceSupport();
        this.buildNamespaceSupport(nss, e2.getParentNode());
        Enumeration<String> en = nss.getPrefixes();
        while (en.hasMoreElements()) {
            prefix2 = en.nextElement();
            this.receiver.startPrefixMapping(prefix2, nss.getURI(prefix2));
        }
        this.visit(e2);
        en = nss.getPrefixes();
        while (en.hasMoreElements()) {
            prefix2 = en.nextElement();
            this.receiver.endPrefixMapping(prefix2);
        }
        this.setCurrentLocation(e2);
        this.receiver.endDocument();
    }

    public void parse(Element e2, ContentHandler handler) throws SAXException {
        this.receiver = handler;
        this.setCurrentLocation(e2);
        this.receiver.startDocument();
        this.receiver.setDocumentLocator(this.locator);
        this.visit(e2);
        this.setCurrentLocation(e2);
        this.receiver.endDocument();
    }

    public void parseWithContext(Element e2, ContentHandler handler) throws SAXException {
        this.setContentHandler(handler);
        this.scan(e2);
    }

    private void buildNamespaceSupport(NamespaceSupport nss, Node node4) {
        if (node4 == null || node4.getNodeType() != 1) {
            return;
        }
        this.buildNamespaceSupport(nss, node4.getParentNode());
        nss.pushContext();
        NamedNodeMap atts = node4.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr a2 = (Attr)atts.item(i);
            if ("xmlns".equals(a2.getPrefix())) {
                nss.declarePrefix(a2.getLocalName(), a2.getValue());
                continue;
            }
            if (!"xmlns".equals(a2.getName())) continue;
            nss.declarePrefix("", a2.getValue());
        }
    }

    public void visit(Element e2) throws SAXException {
        int i;
        this.setCurrentLocation(e2);
        NamedNodeMap attributes2 = e2.getAttributes();
        this.atts.clear();
        int len2 = attributes2 == null ? 0 : attributes2.getLength();
        for (int i2 = len2 - 1; i2 >= 0; --i2) {
            String local;
            Attr a2 = (Attr)attributes2.item(i2);
            String name = a2.getName();
            if (name.startsWith("xmlns")) {
                if (name.length() == 5) {
                    this.receiver.startPrefixMapping("", a2.getValue());
                    continue;
                }
                String localName = a2.getLocalName();
                if (localName == null) {
                    localName = name.substring(6);
                }
                this.receiver.startPrefixMapping(localName, a2.getValue());
                continue;
            }
            String uri = a2.getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            if ((local = a2.getLocalName()) == null) {
                local = a2.getName();
            }
            this.atts.addAttribute(uri, local, a2.getName(), "CDATA", a2.getValue());
        }
        String uri = e2.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        String local = e2.getLocalName();
        String qname = e2.getTagName();
        if (local == null) {
            local = qname;
        }
        this.receiver.startElement(uri, local, qname, this.atts);
        NodeList children2 = e2.getChildNodes();
        int clen = children2.getLength();
        for (i = 0; i < clen; ++i) {
            this.visit(children2.item(i));
        }
        this.setCurrentLocation(e2);
        this.receiver.endElement(uri, local, qname);
        for (i = len2 - 1; i >= 0; --i) {
            Attr a3 = (Attr)attributes2.item(i);
            String name = a3.getName();
            if (!name.startsWith("xmlns")) continue;
            if (name.length() == 5) {
                this.receiver.endPrefixMapping("");
                continue;
            }
            this.receiver.endPrefixMapping(a3.getLocalName());
        }
    }

    private void visit(Node n) throws SAXException {
        this.setCurrentLocation(n);
        switch (n.getNodeType()) {
            case 3: 
            case 4: {
                String value2 = n.getNodeValue();
                this.receiver.characters(value2.toCharArray(), 0, value2.length());
                break;
            }
            case 1: {
                this.visit((Element)n);
                break;
            }
            case 5: {
                this.receiver.skippedEntity(n.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)n;
                this.receiver.processingInstruction(pi.getTarget(), pi.getData());
            }
        }
    }

    private void setCurrentLocation(Node currNode) {
        this.currentNode = currNode;
    }

    public Node getCurrentLocation() {
        return this.currentNode;
    }

    public Object getCurrentElement() {
        return this.currentNode;
    }

    public LocatorEx getLocator() {
        return this;
    }

    public void setContentHandler(ContentHandler handler) {
        this.receiver = handler;
    }

    public ContentHandler getContentHandler() {
        return this.receiver;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public ValidationEventLocator getLocation() {
        return new ValidationEventLocatorImpl(this.getCurrentLocation());
    }
}

