/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2;

import com.sun.xml.bind.Util;
import com.sun.xml.bind.v2.Messages;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassFactory {
    private static final Class[] emptyClass = new Class[0];
    private static final Object[] emptyObject = new Object[0];
    private static final Logger logger = Util.getClassLogger();
    private static final ThreadLocal<Map<Class, WeakReference<Constructor>>> tls = new ThreadLocal<Map<Class, WeakReference<Constructor>>>(){

        @Override
        public Map<Class, WeakReference<Constructor>> initialValue() {
            return new WeakHashMap<Class, WeakReference<Constructor>>();
        }
    };

    public static <T> T create0(Class<T> clazz2) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Map<Class, WeakReference<Constructor>> m = tls.get();
        Constructor<T> cons2 = null;
        WeakReference<Constructor> consRef = m.get(clazz2);
        if (consRef != null) {
            cons2 = (Constructor<T>)consRef.get();
        }
        if (cons2 == null) {
            try {
                cons2 = clazz2.getDeclaredConstructor(emptyClass);
            }
            catch (NoSuchMethodException e2) {
                logger.log(Level.INFO, "No default constructor found on " + clazz2, e2);
                NoSuchMethodError exp = clazz2.getDeclaringClass() != null && !Modifier.isStatic(clazz2.getModifiers()) ? new NoSuchMethodError(Messages.NO_DEFAULT_CONSTRUCTOR_IN_INNER_CLASS.format(clazz2.getName())) : new NoSuchMethodError(e2.getMessage());
                exp.initCause(e2);
                throw exp;
            }
            int classMod = clazz2.getModifiers();
            if (!Modifier.isPublic(classMod) || !Modifier.isPublic(cons2.getModifiers())) {
                try {
                    cons2.setAccessible(true);
                }
                catch (SecurityException e3) {
                    logger.log(Level.FINE, "Unable to make the constructor of " + clazz2 + " accessible", e3);
                    throw e3;
                }
            }
            m.put(clazz2, new WeakReference<Constructor<T>>(cons2));
        }
        return cons2.newInstance(emptyObject);
    }

    public static <T> T create(Class<T> clazz2) {
        try {
            return ClassFactory.create0(clazz2);
        }
        catch (InstantiationException e2) {
            logger.log(Level.INFO, "failed to create a new instance of " + clazz2, e2);
            throw new InstantiationError(e2.toString());
        }
        catch (IllegalAccessException e3) {
            logger.log(Level.INFO, "failed to create a new instance of " + clazz2, e3);
            throw new IllegalAccessError(e3.toString());
        }
        catch (InvocationTargetException e4) {
            Throwable target2 = e4.getTargetException();
            if (target2 instanceof RuntimeException) {
                throw (RuntimeException)target2;
            }
            if (target2 instanceof Error) {
                throw (Error)target2;
            }
            throw new IllegalStateException(target2);
        }
    }

    public static Object create(Method method) {
        Throwable errorMsg;
        try {
            return method.invoke(null, emptyObject);
        }
        catch (InvocationTargetException ive) {
            Throwable target2 = ive.getTargetException();
            if (target2 instanceof RuntimeException) {
                throw (RuntimeException)target2;
            }
            if (target2 instanceof Error) {
                throw (Error)target2;
            }
            throw new IllegalStateException(target2);
        }
        catch (IllegalAccessException e2) {
            logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), e2);
            throw new IllegalAccessError(e2.toString());
        }
        catch (IllegalArgumentException iae) {
            logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), iae);
            errorMsg = iae;
        }
        catch (NullPointerException npe) {
            logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), npe);
            errorMsg = npe;
        }
        catch (ExceptionInInitializerError eie) {
            logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), eie);
            errorMsg = eie;
        }
        NoSuchMethodError exp = new NoSuchMethodError(errorMsg.getMessage());
        exp.initCause(errorMsg);
        throw exp;
    }

    public static <T> Class<? extends T> inferImplClass(Class<T> fieldType, Class[] knownImplClasses) {
        if (!fieldType.isInterface()) {
            return fieldType;
        }
        for (Class impl : knownImplClasses) {
            if (!fieldType.isAssignableFrom(impl)) continue;
            return impl.asSubclass(fieldType);
        }
        return null;
    }
}

