/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.model.annotation;

import com.sun.xml.bind.v2.model.annotation.AbstractInlineAnnotationReaderImpl;
import com.sun.xml.bind.v2.model.annotation.Locatable;
import com.sun.xml.bind.v2.model.annotation.LocatableAnnotation;
import com.sun.xml.bind.v2.model.annotation.RuntimeAnnotationReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeInlineAnnotationReader
extends AbstractInlineAnnotationReaderImpl<Type, Class, Field, Method>
implements RuntimeAnnotationReader {
    private final Map<Class<? extends Annotation>, Map<Package, Annotation>> packageCache = new HashMap<Class<? extends Annotation>, Map<Package, Annotation>>();

    @Override
    public <A extends Annotation> A getFieldAnnotation(Class<A> annotation2, Field field2, Locatable srcPos) {
        return LocatableAnnotation.create(field2.getAnnotation(annotation2), srcPos);
    }

    @Override
    public boolean hasFieldAnnotation(Class<? extends Annotation> annotationType, Field field2) {
        return field2.isAnnotationPresent(annotationType);
    }

    @Override
    public boolean hasClassAnnotation(Class clazz2, Class<? extends Annotation> annotationType) {
        return clazz2.isAnnotationPresent(annotationType);
    }

    @Override
    public Annotation[] getAllFieldAnnotations(Field field2, Locatable srcPos) {
        Annotation[] r = field2.getAnnotations();
        for (int i = 0; i < r.length; ++i) {
            r[i] = LocatableAnnotation.create(r[i], srcPos);
        }
        return r;
    }

    @Override
    public <A extends Annotation> A getMethodAnnotation(Class<A> annotation2, Method method, Locatable srcPos) {
        return LocatableAnnotation.create(method.getAnnotation(annotation2), srcPos);
    }

    @Override
    public boolean hasMethodAnnotation(Class<? extends Annotation> annotation2, Method method) {
        return method.isAnnotationPresent(annotation2);
    }

    @Override
    public Annotation[] getAllMethodAnnotations(Method method, Locatable srcPos) {
        Annotation[] r = method.getAnnotations();
        for (int i = 0; i < r.length; ++i) {
            r[i] = LocatableAnnotation.create(r[i], srcPos);
        }
        return r;
    }

    @Override
    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> annotation2, Method method, int paramIndex, Locatable srcPos) {
        Annotation[] pa;
        for (Annotation a2 : pa = method.getParameterAnnotations()[paramIndex]) {
            if (a2.annotationType() != annotation2) continue;
            return (A)LocatableAnnotation.create(a2, srcPos);
        }
        return null;
    }

    @Override
    public <A extends Annotation> A getClassAnnotation(Class<A> a2, Class clazz2, Locatable srcPos) {
        return LocatableAnnotation.create(clazz2.getAnnotation(a2), srcPos);
    }

    @Override
    public <A extends Annotation> A getPackageAnnotation(Class<A> a2, Class clazz2, Locatable srcPos) {
        Package p = clazz2.getPackage();
        if (p == null) {
            return null;
        }
        Map<Package, Annotation> cache = this.packageCache.get(a2);
        if (cache == null) {
            cache = new HashMap<Package, Annotation>();
            this.packageCache.put(a2, cache);
        }
        if (cache.containsKey(p)) {
            return (A)cache.get(p);
        }
        A ann = LocatableAnnotation.create(p.getAnnotation(a2), srcPos);
        cache.put(p, (Annotation)ann);
        return ann;
    }

    @Override
    public Class getClassValue(Annotation a2, String name) {
        try {
            return (Class)a2.annotationType().getMethod(name, new Class[0]).invoke((Object)a2, new Object[0]);
        }
        catch (IllegalAccessException e2) {
            throw new IllegalAccessError(e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            throw new InternalError(e3.getMessage());
        }
        catch (NoSuchMethodException e4) {
            throw new NoSuchMethodError(e4.getMessage());
        }
    }

    public Class[] getClassArrayValue(Annotation a2, String name) {
        try {
            return (Class[])a2.annotationType().getMethod(name, new Class[0]).invoke((Object)a2, new Object[0]);
        }
        catch (IllegalAccessException e2) {
            throw new IllegalAccessError(e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            throw new InternalError(e3.getMessage());
        }
        catch (NoSuchMethodException e4) {
            throw new NoSuchMethodError(e4.getMessage());
        }
    }

    @Override
    protected String fullName(Method m) {
        return m.getDeclaringClass().getName() + '#' + m.getName();
    }
}

