/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.model.nav;

import com.sun.xml.bind.v2.model.nav.GenericArrayTypeImpl;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.bind.v2.model.nav.ParameterizedTypeImpl;
import com.sun.xml.bind.v2.model.nav.TypeVisitor;
import com.sun.xml.bind.v2.model.nav.WildcardTypeImpl;
import com.sun.xml.bind.v2.runtime.Location;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionNavigator
implements Navigator<Type, Class, Field, Method> {
    private static final TypeVisitor<Type, Class> baseClassFinder = new TypeVisitor<Type, Class>(){

        @Override
        public Type onClass(Class c2, Class sup) {
            Type r;
            if (sup == c2) {
                return sup;
            }
            Type sc = c2.getGenericSuperclass();
            if (sc != null && (r = (Type)this.visit(sc, sup)) != null) {
                return r;
            }
            for (Type i : c2.getGenericInterfaces()) {
                r = (Type)this.visit(i, sup);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public Type onParameterizdType(ParameterizedType p, Class sup) {
            Class raw2 = (Class)p.getRawType();
            if (raw2 == sup) {
                return p;
            }
            Type r = raw2.getGenericSuperclass();
            if (r != null) {
                r = (Type)this.visit(this.bind(r, raw2, p), sup);
            }
            if (r != null) {
                return r;
            }
            for (Type i : raw2.getGenericInterfaces()) {
                r = (Type)this.visit(this.bind(i, raw2, p), sup);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public Type onGenericArray(GenericArrayType g, Class sup) {
            return null;
        }

        @Override
        public Type onVariable(TypeVariable v, Class sup) {
            return (Type)this.visit(v.getBounds()[0], sup);
        }

        @Override
        public Type onWildcard(WildcardType w, Class sup) {
            return null;
        }

        private Type bind(Type t2, GenericDeclaration decl, ParameterizedType args2) {
            return (Type)binder.visit(t2, new BinderArg(decl, args2.getActualTypeArguments()));
        }
    };
    private static final TypeVisitor<Type, BinderArg> binder = new TypeVisitor<Type, BinderArg>(){

        @Override
        public Type onClass(Class c2, BinderArg args2) {
            return c2;
        }

        @Override
        public Type onParameterizdType(ParameterizedType p, BinderArg args2) {
            Type[] params2 = p.getActualTypeArguments();
            boolean different = false;
            for (int i = 0; i < params2.length; ++i) {
                Type t2 = params2[i];
                params2[i] = (Type)this.visit(t2, args2);
                different |= t2 != params2[i];
            }
            Type newOwner = p.getOwnerType();
            if (newOwner != null) {
                newOwner = (Type)this.visit(newOwner, args2);
            }
            if (!(different |= p.getOwnerType() != newOwner)) {
                return p;
            }
            return new ParameterizedTypeImpl((Class)p.getRawType(), params2, newOwner);
        }

        @Override
        public Type onGenericArray(GenericArrayType g, BinderArg types2) {
            Type c2 = (Type)this.visit(g.getGenericComponentType(), types2);
            if (c2 == g.getGenericComponentType()) {
                return g;
            }
            return new GenericArrayTypeImpl(c2);
        }

        @Override
        public Type onVariable(TypeVariable v, BinderArg types2) {
            return types2.replace(v);
        }

        @Override
        public Type onWildcard(WildcardType w, BinderArg types2) {
            Type t2;
            int i;
            Type[] lb = w.getLowerBounds();
            Type[] ub = w.getUpperBounds();
            boolean diff2 = false;
            for (i = 0; i < lb.length; ++i) {
                t2 = lb[i];
                lb[i] = (Type)this.visit(t2, types2);
                diff2 |= t2 != lb[i];
            }
            for (i = 0; i < ub.length; ++i) {
                t2 = ub[i];
                ub[i] = (Type)this.visit(t2, types2);
                diff2 |= t2 != ub[i];
            }
            if (!diff2) {
                return w;
            }
            return new WildcardTypeImpl(lb, ub);
        }
    };
    private static final TypeVisitor<Class, Void> eraser = new TypeVisitor<Class, Void>(){

        @Override
        public Class onClass(Class c2, Void _) {
            return c2;
        }

        @Override
        public Class onParameterizdType(ParameterizedType p, Void _) {
            return (Class)this.visit(p.getRawType(), null);
        }

        @Override
        public Class onGenericArray(GenericArrayType g, Void _) {
            return Array.newInstance((Class)this.visit(g.getGenericComponentType(), null), 0).getClass();
        }

        @Override
        public Class onVariable(TypeVariable v, Void _) {
            return (Class)this.visit(v.getBounds()[0], null);
        }

        @Override
        public Class onWildcard(WildcardType w, Void _) {
            return (Class)this.visit(w.getUpperBounds()[0], null);
        }
    };

    ReflectionNavigator() {
    }

    @Override
    public Class getSuperClass(Class clazz2) {
        if (clazz2 == Object.class) {
            return null;
        }
        Class<Object> sc = clazz2.getSuperclass();
        if (sc == null) {
            sc = Object.class;
        }
        return sc;
    }

    @Override
    public Type getBaseClass(Type t2, Class sup) {
        return baseClassFinder.visit(t2, sup);
    }

    @Override
    public String getClassName(Class clazz2) {
        return clazz2.getName();
    }

    @Override
    public String getTypeName(Type type) {
        if (type instanceof Class) {
            Class c2 = (Class)type;
            if (c2.isArray()) {
                return this.getTypeName(c2.getComponentType()) + "[]";
            }
            return c2.getName();
        }
        return type.toString();
    }

    @Override
    public String getClassShortName(Class clazz2) {
        return clazz2.getSimpleName();
    }

    @Override
    public Collection<? extends Field> getDeclaredFields(Class clazz2) {
        return Arrays.asList(clazz2.getDeclaredFields());
    }

    @Override
    public Field getDeclaredField(Class clazz2, String fieldName) {
        try {
            return clazz2.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e2) {
            return null;
        }
    }

    @Override
    public Collection<? extends Method> getDeclaredMethods(Class clazz2) {
        return Arrays.asList(clazz2.getDeclaredMethods());
    }

    @Override
    public Class getDeclaringClassForField(Field field2) {
        return field2.getDeclaringClass();
    }

    @Override
    public Class getDeclaringClassForMethod(Method method) {
        return method.getDeclaringClass();
    }

    @Override
    public Type getFieldType(Field field2) {
        return this.fix(field2.getGenericType());
    }

    @Override
    public String getFieldName(Field field2) {
        return field2.getName();
    }

    @Override
    public String getMethodName(Method method) {
        return method.getName();
    }

    @Override
    public Type getReturnType(Method method) {
        return this.fix(method.getGenericReturnType());
    }

    public Type[] getMethodParameters(Method method) {
        return method.getGenericParameterTypes();
    }

    @Override
    public boolean isStaticMethod(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    @Override
    public boolean isFinalMethod(Method method) {
        return Modifier.isFinal(method.getModifiers());
    }

    @Override
    public boolean isSubClassOf(Type sub, Type sup) {
        return this.erasure(sup).isAssignableFrom(this.erasure(sub));
    }

    @Override
    public Class ref(Class c2) {
        return c2;
    }

    @Override
    public Class use(Class c2) {
        return c2;
    }

    @Override
    public Class asDecl(Type t2) {
        return this.erasure(t2);
    }

    @Override
    public Class asDecl(Class c2) {
        return c2;
    }

    @Override
    public <T> Class<T> erasure(Type t2) {
        return eraser.visit(t2, null);
    }

    @Override
    public boolean isAbstract(Class clazz2) {
        return Modifier.isAbstract(clazz2.getModifiers());
    }

    @Override
    public boolean isFinal(Class clazz2) {
        return Modifier.isFinal(clazz2.getModifiers());
    }

    public Type createParameterizedType(Class rawType, Type ... arguments2) {
        return new ParameterizedTypeImpl(rawType, arguments2, null);
    }

    @Override
    public boolean isArray(Type t2) {
        if (t2 instanceof Class) {
            Class c2 = (Class)t2;
            return c2.isArray();
        }
        return t2 instanceof GenericArrayType;
    }

    @Override
    public boolean isArrayButNotByteArray(Type t2) {
        if (t2 instanceof Class) {
            Class c2 = (Class)t2;
            return c2.isArray() && c2 != byte[].class;
        }
        if (t2 instanceof GenericArrayType) {
            return (t2 = ((GenericArrayType)t2).getGenericComponentType()) != Byte.TYPE;
        }
        return false;
    }

    @Override
    public Type getComponentType(Type t2) {
        if (t2 instanceof Class) {
            Class c2 = (Class)t2;
            return c2.getComponentType();
        }
        if (t2 instanceof GenericArrayType) {
            return ((GenericArrayType)t2).getGenericComponentType();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Type getTypeArgument(Type type, int i) {
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            return this.fix(p.getActualTypeArguments()[i]);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isParameterizedType(Type type) {
        return type instanceof ParameterizedType;
    }

    @Override
    public boolean isPrimitive(Type type) {
        if (type instanceof Class) {
            Class c2 = (Class)type;
            return c2.isPrimitive();
        }
        return false;
    }

    @Override
    public Type getPrimitive(Class primitiveType) {
        assert (primitiveType.isPrimitive());
        return primitiveType;
    }

    @Override
    public Location getClassLocation(final Class clazz2) {
        return new Location(){

            public String toString() {
                return clazz2.getName();
            }
        };
    }

    @Override
    public Location getFieldLocation(final Field field2) {
        return new Location(){

            public String toString() {
                return field2.toString();
            }
        };
    }

    @Override
    public Location getMethodLocation(final Method method) {
        return new Location(){

            public String toString() {
                return method.toString();
            }
        };
    }

    @Override
    public boolean hasDefaultConstructor(Class c2) {
        try {
            c2.getDeclaredConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e2) {
            return false;
        }
    }

    @Override
    public boolean isStaticField(Field field2) {
        return Modifier.isStatic(field2.getModifiers());
    }

    @Override
    public boolean isPublicMethod(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    @Override
    public boolean isPublicField(Field field2) {
        return Modifier.isPublic(field2.getModifiers());
    }

    @Override
    public boolean isEnum(Class c2) {
        return Enum.class.isAssignableFrom(c2);
    }

    public Field[] getEnumConstants(Class clazz2) {
        try {
            T[] values2 = clazz2.getEnumConstants();
            Field[] fields = new Field[values2.length];
            for (int i = 0; i < values2.length; ++i) {
                fields[i] = clazz2.getField(((Enum)values2[i]).name());
            }
            return fields;
        }
        catch (NoSuchFieldException e2) {
            throw new NoSuchFieldError(e2.getMessage());
        }
    }

    @Override
    public Type getVoidType() {
        return Void.class;
    }

    @Override
    public String getPackageName(Class clazz2) {
        String name = clazz2.getName();
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return "";
        }
        return name.substring(0, idx);
    }

    @Override
    public Class findClass(String className, Class referencePoint) {
        try {
            ClassLoader cl = referencePoint.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
    }

    @Override
    public boolean isBridgeMethod(Method method) {
        return method.isBridge();
    }

    @Override
    public boolean isOverriding(Method method, Class base) {
        String name = method.getName();
        Class<?>[] params2 = method.getParameterTypes();
        while (base != null) {
            try {
                if (base.getDeclaredMethod(name, params2) != null) {
                    return true;
                }
            }
            catch (NoSuchMethodException e2) {
                // empty catch block
            }
            base = base.getSuperclass();
        }
        return false;
    }

    @Override
    public boolean isInterface(Class clazz2) {
        return clazz2.isInterface();
    }

    @Override
    public boolean isTransient(Field f2) {
        return Modifier.isTransient(f2.getModifiers());
    }

    @Override
    public boolean isInnerClass(Class clazz2) {
        return clazz2.getEnclosingClass() != null && !Modifier.isStatic(clazz2.getModifiers());
    }

    private Type fix(Type t2) {
        if (!(t2 instanceof GenericArrayType)) {
            return t2;
        }
        GenericArrayType gat = (GenericArrayType)t2;
        if (gat.getGenericComponentType() instanceof Class) {
            Class c2 = (Class)gat.getGenericComponentType();
            return Array.newInstance(c2, 0).getClass();
        }
        return t2;
    }

    private static class BinderArg {
        final TypeVariable[] params;
        final Type[] args;

        BinderArg(TypeVariable[] params2, Type[] args2) {
            this.params = params2;
            this.args = args2;
            assert (params2.length == args2.length);
        }

        public BinderArg(GenericDeclaration decl, Type[] args2) {
            this(decl.getTypeParameters(), args2);
        }

        Type replace(TypeVariable v) {
            for (int i = 0; i < this.params.length; ++i) {
                if (!this.params[i].equals(v)) continue;
                return this.args[i];
            }
            return v;
        }
    }
}

