/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime;

import com.sun.istack.FinalArrayList;
import com.sun.istack.SAXException2;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ContentHandlerAdaptor
extends DefaultHandler {
    private final FinalArrayList<String> prefixMap = new FinalArrayList();
    private final XMLSerializer serializer;
    private final StringBuffer text = new StringBuffer();

    ContentHandlerAdaptor(XMLSerializer _serializer) {
        this.serializer = _serializer;
    }

    public void startDocument() {
        this.prefixMap.clear();
    }

    public void startPrefixMapping(String prefix2, String uri) {
        this.prefixMap.add(prefix2);
        this.prefixMap.add(uri);
    }

    private boolean containsPrefixMapping(String prefix2, String uri) {
        for (int i = 0; i < this.prefixMap.size(); i += 2) {
            if (!((String)this.prefixMap.get(i)).equals(prefix2) || !((String)this.prefixMap.get(i + 1)).equals(uri)) continue;
            return true;
        }
        return false;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            int i;
            this.flushText();
            int len2 = atts.getLength();
            String p = this.getPrefix(qName);
            if (this.containsPrefixMapping(p, namespaceURI)) {
                this.serializer.startElementForce(namespaceURI, localName, p, null);
            } else {
                this.serializer.startElement(namespaceURI, localName, p, null);
            }
            for (i = 0; i < this.prefixMap.size(); i += 2) {
                this.serializer.getNamespaceContext().force((String)this.prefixMap.get(i + 1), (String)this.prefixMap.get(i));
            }
            for (i = 0; i < len2; ++i) {
                String qname = atts.getQName(i);
                if (qname.startsWith("xmlns") || atts.getURI(i).length() == 0) continue;
                String prefix2 = this.getPrefix(qname);
                this.serializer.getNamespaceContext().declareNamespace(atts.getURI(i), prefix2, true);
            }
            this.serializer.endNamespaceDecls(null);
            for (i = 0; i < len2; ++i) {
                if (atts.getQName(i).startsWith("xmlns")) continue;
                this.serializer.attribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
            }
            this.prefixMap.clear();
            this.serializer.endAttributes();
        }
        catch (IOException e2) {
            throw new SAXException2(e2);
        }
        catch (XMLStreamException e3) {
            throw new SAXException2(e3);
        }
    }

    private String getPrefix(String qname) {
        int idx = qname.indexOf(58);
        String prefix2 = idx == -1 ? qname : qname.substring(0, idx);
        return prefix2;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.flushText();
            this.serializer.endElement();
        }
        catch (IOException e2) {
            throw new SAXException2(e2);
        }
        catch (XMLStreamException e3) {
            throw new SAXException2(e3);
        }
    }

    private void flushText() throws SAXException, IOException, XMLStreamException {
        if (this.text.length() != 0) {
            this.serializer.text(this.text.toString(), null);
            this.text.setLength(0);
        }
    }

    public void characters(char[] ch, int start2, int length2) {
        this.text.append(ch, start2, length2);
    }
}

