/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.MarshallerImpl;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.bind.v2.runtime.output.Pcdata;
import com.sun.xml.bind.v2.runtime.output.XmlOutput;
import com.sun.xml.bind.v2.runtime.output.XmlOutputAbstractImpl;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallerImpl;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamWriterOutput
extends XmlOutputAbstractImpl {
    private final XMLStreamWriter out;
    protected final char[] buf = new char[256];
    private static final Class FI_STAX_WRITER_CLASS = XMLStreamWriterOutput.initFIStAXWriterClass();
    private static final Constructor<? extends XmlOutput> FI_OUTPUT_CTOR = XMLStreamWriterOutput.initFastInfosetOutputClass();
    private static final Class STAXEX_WRITER_CLASS = XMLStreamWriterOutput.initStAXExWriterClass();
    private static final Constructor<? extends XmlOutput> STAXEX_OUTPUT_CTOR = XMLStreamWriterOutput.initStAXExOutputClass();

    public static XmlOutput create(XMLStreamWriter out, JAXBContextImpl context) {
        Class<?> writerClass = out.getClass();
        if (writerClass == FI_STAX_WRITER_CLASS) {
            try {
                return FI_OUTPUT_CTOR.newInstance(new Object[]{out, context});
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (STAXEX_WRITER_CLASS != null && STAXEX_WRITER_CLASS.isAssignableFrom(writerClass)) {
            try {
                return STAXEX_OUTPUT_CTOR.newInstance(out);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new XMLStreamWriterOutput(out);
    }

    protected XMLStreamWriterOutput(XMLStreamWriter out) {
        this.out = out;
    }

    @Override
    public void startDocument(XMLSerializer serializer, boolean fragment, int[] nsUriIndex2prefixIndex, NamespaceContextImpl nsContext) throws IOException, SAXException, XMLStreamException {
        super.startDocument(serializer, fragment, nsUriIndex2prefixIndex, nsContext);
        if (!fragment) {
            this.out.writeStartDocument();
        }
    }

    @Override
    public void endDocument(boolean fragment) throws IOException, SAXException, XMLStreamException {
        if (!fragment) {
            this.out.writeEndDocument();
            this.out.flush();
        }
        super.endDocument(fragment);
    }

    @Override
    public void beginStartTag(int prefix2, String localName) throws IOException, XMLStreamException {
        this.out.writeStartElement(this.nsContext.getPrefix(prefix2), localName, this.nsContext.getNamespaceURI(prefix2));
        NamespaceContextImpl.Element nse = this.nsContext.getCurrent();
        if (nse.count() > 0) {
            for (int i = nse.count() - 1; i >= 0; --i) {
                String uri = nse.getNsUri(i);
                if (uri.length() == 0 && nse.getBase() == 1) continue;
                this.out.writeNamespace(nse.getPrefix(i), uri);
            }
        }
    }

    @Override
    public void attribute(int prefix2, String localName, String value2) throws IOException, XMLStreamException {
        if (prefix2 == -1) {
            this.out.writeAttribute(localName, value2);
        } else {
            this.out.writeAttribute(this.nsContext.getPrefix(prefix2), this.nsContext.getNamespaceURI(prefix2), localName, value2);
        }
    }

    @Override
    public void endStartTag() throws IOException, SAXException {
    }

    @Override
    public void endTag(int prefix2, String localName) throws IOException, SAXException, XMLStreamException {
        this.out.writeEndElement();
    }

    @Override
    public void text(String value2, boolean needsSeparatingWhitespace) throws IOException, SAXException, XMLStreamException {
        if (needsSeparatingWhitespace) {
            this.out.writeCharacters(" ");
        }
        this.out.writeCharacters(value2);
    }

    @Override
    public void text(Pcdata value2, boolean needsSeparatingWhitespace) throws IOException, SAXException, XMLStreamException {
        int len2;
        if (needsSeparatingWhitespace) {
            this.out.writeCharacters(" ");
        }
        if ((len2 = value2.length()) < this.buf.length) {
            value2.writeTo(this.buf, 0);
            this.out.writeCharacters(this.buf, 0, len2);
        } else {
            this.out.writeCharacters(value2.toString());
        }
    }

    private static Class initFIStAXWriterClass() {
        try {
            Class<?> llfisw = Class.forName("org.jvnet.fastinfoset.stax.LowLevelFastInfosetStreamWriter", true, MarshallerImpl.class.getClassLoader());
            Class<?> sds = MarshallerImpl.class.getClassLoader().loadClass("com.sun.xml.fastinfoset.stax.StAXDocumentSerializer");
            if (llfisw.isAssignableFrom(sds)) {
                return sds;
            }
            return null;
        }
        catch (Throwable e2) {
            return null;
        }
    }

    private static Constructor<? extends XmlOutput> initFastInfosetOutputClass() {
        try {
            if (FI_STAX_WRITER_CLASS == null) {
                return null;
            }
            Class<?> c2 = Class.forName("com.sun.xml.bind.v2.runtime.output.FastInfosetStreamWriterOutput", true, UnmarshallerImpl.class.getClassLoader());
            return c2.getConstructor(FI_STAX_WRITER_CLASS, JAXBContextImpl.class);
        }
        catch (Throwable e2) {
            return null;
        }
    }

    private static Class initStAXExWriterClass() {
        try {
            return Class.forName("org.jvnet.staxex.XMLStreamWriterEx", true, MarshallerImpl.class.getClassLoader());
        }
        catch (Throwable e2) {
            return null;
        }
    }

    private static Constructor<? extends XmlOutput> initStAXExOutputClass() {
        try {
            Class<?> c2 = Class.forName("com.sun.xml.bind.v2.runtime.output.StAXExStreamWriterOutput", true, UnmarshallerImpl.class.getClassLoader());
            return c2.getConstructor(STAXEX_WRITER_CLASS);
        }
        catch (Throwable e2) {
            return null;
        }
    }
}

