/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect.opt;

import com.sun.xml.bind.Util;
import com.sun.xml.bind.v2.bytecode.ClassTailor;
import com.sun.xml.bind.v2.runtime.reflect.opt.Injector;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AccessorInjector {
    private static final Logger logger = Util.getClassLogger();
    protected static final boolean noOptimize;
    private static final ClassLoader CLASS_LOADER;

    AccessorInjector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> prepare(Class beanClass, String templateClassName, String newClassName, String ... replacements) {
        if (noOptimize) {
            return null;
        }
        try {
            ClassLoader cl = beanClass.getClassLoader();
            if (cl == null) {
                return null;
            }
            Class c2 = null;
            Class<AccessorInjector> clazz2 = AccessorInjector.class;
            synchronized (AccessorInjector.class) {
                c2 = Injector.find(cl, newClassName);
                if (c2 == null) {
                    byte[] image = AccessorInjector.tailor(templateClassName, newClassName, replacements);
                    if (image == null) {
                        // ** MonitorExit[var6_7] (shouldn't be in output)
                        return null;
                    }
                    c2 = Injector.inject(cl, newClassName, image);
                }
                // ** MonitorExit[var6_7] (shouldn't be in output)
                return c2;
            }
        }
        catch (SecurityException e2) {
            logger.log(Level.INFO, "Unable to create an optimized TransducedAccessor ", e2);
            return null;
        }
    }

    private static byte[] tailor(String templateClassName, String newClassName, String ... replacements) {
        InputStream resource = CLASS_LOADER != null ? CLASS_LOADER.getResourceAsStream(templateClassName + ".class") : ClassLoader.getSystemResourceAsStream(templateClassName + ".class");
        if (resource == null) {
            return null;
        }
        return ClassTailor.tailor(resource, templateClassName, newClassName, replacements);
    }

    static {
        boolean bl = noOptimize = Util.getSystemProperty(ClassTailor.class.getName() + ".noOptimize") != null;
        if (noOptimize) {
            logger.info("The optimized code generation is disabled");
        }
        CLASS_LOADER = AccessorInjector.class.getClassLoader();
    }
}

